(*Mathematica:: Verizon 7.0      *)
(*:Context:: "rufit`"        *)
(*:Title::  relative utility  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2016 Stuart G. Baker *)

   	      
BeginPackage["rufittangentcondition`"]


TangentCondition::usage="TangentCondition"

Clear[TangentCondition]
					
Begin["Private`"]	  
  

TangentCondition[x_,set_:1]:=
Module[{plotmat,plotmat1,plotmat1z,plotmat2,plotmat2x,plotmat2z,shapevec,ncol,shape},
If[set==1, 
shape=0;
ncol=2;
plotmat1=TangentConditionCore[x,shape,set];
  plotmat1z=Show[GraphicsRow[plotmat1],ImageSize->Large];
  ExportPlotX["Fig5",plotmat1z,"manu"]];

 
If[set==2, 
  shapevec=Range[8]; 
  ncol=4;
  plotmat2=TangentConditionCore[x,#,set]& /@ shapevec;
  plotmat2x=Partition[Flatten[plotmat2],ncol];
  plotmat2z=Show[GraphicsGrid[plotmat2x],ImageSize->Large];
  ExportPlotX["Fig6",plotmat2z,"manu"]];
Return[Null]]




TangentConditionCore[x_,shape_,set_]:=
Module[{plotA,plotB,plot,plotROC, plotRU,lineA1,lineA2,lineB1,lineB2,ruA1,ruA2,ruB1,ruB2,letter,nameRU,nameROC},
colorA=Red;
colorB=Blue;
k1=1; 
k2=2;
k3=2.8; 
k4=3.2;
k5=3.5;
(*Assume P=.5*)
T1=k1/(1+k1);
T2=k2/(1+k2);
T3=k3/(1+k3);
T4=k4/(1+k4);
T5=k5/(1+k5);
kvec={k1,k2,k3,k4,k5};
(*POINT SIZE*)
r=.03;
If[shape==0, a1=13; a2=24; b1=14; b2=5;  zA=3;zB=1];
If[shape==1, a1=13; a2=3; b1=64; b2=2; zA=2; zB=2];
If[shape==2, a1=3; a2=24; b1=13; b2=3;  zA=2;zB=2];
If[shape==3, a1=13; a2=3; b1=14; b2=5;  zA=3;zB=1];
If[shape==4, a1=15; a2=3; b1=4; b2=2;  zA=2;zB=1];
If[shape==5, a1=15; a2=3; b1=4; b2=2;  zA=2;zB=3];
If[shape==6, a1=14; a2=3; b1=13; b2=164; zA=1;zB=1];
If[shape==7, a1=21; a2=5; b1=4; b2=12;  zA=2;zB=3];
If[shape==8, a1=3; a2=3; b1=3; b2=164; zA=1;zB=1];



If[set==1, letter=" "];
If[set==2,
If[shape==1, letter="A"];
If[shape==2, letter="B"];
If[shape==3, letter="C"];
If[shape==4, letter="D"];
If[shape==5, letter="E"];
If[shape==6, letter="F"];
If[shape==7, letter="G"];
If[shape==8, letter="H"]];
{plotA,ruA1,ruA2,ruA3,ruA4,ruA5,maxruA,vec1}=TangentConditionKey[{a1,a2,zA},x,colorA,kvec,r,set,1];
{plotB,ruB1,ruB2,ruB3,ruB4,ruB5,maxruB,vec2}=TangentConditionKey[{b1,b2,zB},x,colorB,kvec,r,set,2];
If[set==2,Print["Panel ",letter]];
If[set==1,CheckTC1[vec1,vec2]];
If[set==2,CheckTC2[vec1,vec2]];
dif1=ruB1-ruA1;
dif2=ruB2-ruA2;
dif3=ruB3-ruA3;
dif4=ruB4-ruA4;
dif5=ruB5-ruA5;
difvec={dif1,dif2,dif3,dif4,dif5};
difmax=Max[difvec];
k=dif1/difmax;
font=Automatic;
name1=Style["Model 2",Blue];
name2=Style["Model 1",Red];
  color1= Blue;
  color2=Red;
  dash=Dashing[{.02,.02}];
   style1={color1};
    style2={color2,dash};
    v1=.25;
    v2=.15;
    a=.6;
    b=.7;
text1=Graphics@Text[name1,{a, v1},{1,0}];
text2=Graphics@Text[name2,{a, v2},{1,0}];
     rect1=ListPlot[{{a+.01,v1},{b,v1}},Joined->True,PlotStyle->style1];
     rect2=ListPlot[{{a+.01,v2},{b,v2}},Joined->True,PlotStyle->style2];
nameROC0="ROC curves";
 nameRU0="RU curves";
 If[set==1,
 nameRU=nameRU0;
 nameROC=nameROC0];


 If[set==2,
 nameRU=StringJoin["(",letter,"): ",nameRU0];
 nameROC=StringJoin["(",letter,"): ",nameROC0]];


 If[set==1,
   color1=Darker[Green];
   color2=Brown;
 
RUnameA1=Style["maxRU1",color1,Italic,FontSize->12];
RUnameB1=Style["maxRU2",color1,Italic,FontSize->12];
RUnameA2=Style["RU1b",color2,Italic,FontSize->12];
RUnameB2=Style["RU2b",color2,Italic,FontSize->12];


  ticks={{{0,"0"},{1,"1"}},
  {{0,"0"},
  {ruA1,RUnameA1},{ruB1,RUnameB1},
   {ruA2,RUnameA2},{ruB2,RUnameB2},
   {1,"1"}}, 
   None, None};
 plotROC=Show[plotA,plotB,text1,text2,rect1,rect2,
Frame->True,LabelStyle->font, FrameTicks->ticks,
FrameLabel->{"FPR", "TPR", nameROC,None}]];



 
 If[set==2,
 RUnameA1=Style["maxRU1",Red,FontSize->12];
RUnameB1=Style["maxRU2",Blue,FontSize->12];
  ticks={{{0,"0"},{1,"1"}},
  {{0,"0"},{ruA1,RUnameA1},{ruB1,RUnameB1},{1,"1"}},
  None, None};
   ticks={{{0,"0"},{1,"1"}},
    {{0,"0"},{1,"1"}},
  None, None};
 plotROC=Show[plotA,plotB,text1,text2,rect1,rect2,
Frame->True,LabelStyle->font, FrameTicks->ticks,
FrameLabel->{"FPR", "TPR", nameROC,None}]];






(*Risk threshold from slope for P=.5*)

dash=Dashing[{.02,.02}];
lineA1=Graphics@{colorA, dash,Line[{{T1,ruA1},{T2,ruA2}}]};
lineA2=Graphics@{colorA,dash,Line[{{T2,ruA2},{T3,ruA3}}]};
lineA3=Graphics@{colorA,dash,Line[{{T3,ruA3},{T4,ruA4}}]};
lineA4=Graphics@{colorA,dash,Line[{{T4,ruA4},{T5,ruA5}}]};
lineA5=Graphics@{colorA,dash,Line[{{T5,ruA5},{1,0}}]};
lineB1=Graphics@{colorB,Line[{{T1,ruB1},{T2,ruB2}}]};
lineB2=Graphics@{colorB,Line[{{T2,ruB2},{T3,ruB3}}]};
lineB3=Graphics@{colorB,Line[{{T3,ruB3},{T4,ruB4}}]};
lineB4=Graphics@{colorB,Line[{{T4,ruB4},{T5,ruB5}}]};
lineB5=Graphics@{colorB,Line[{{T5,ruB5},{1,0}}]};

color1=Darker[Green];
color2=Brown;
pointA1= Graphics@{color1,PointSize[r],Point[{T1,ruA1}]};
pointA2= Graphics@{color2,PointSize[r],Point[{T2,ruA2}]};

pointB1= Graphics@{color1,PointSize[r],Point[{T1,ruB1}]};
pointB2= Graphics@{color2,PointSize[r],Point[{T2,ruB2}]};
 maxru=Max[maxruA,maxruB];
 v1=.8 maxru;
    v2=.7 maxru;
    a=T5+ (T5-T1) .8;
    b=a+ (T5-T1).2;
text1=Graphics@Text[name1,{a, v1},{1,0}];
text2=Graphics@Text[name2,{a, v2},{1,0}];  
     rect1=ListPlot[{{a+.01,v1},{b,v1}},Joined->True,PlotStyle->style1];
     rect2=ListPlot[{{a+.01,v2},{b,v2}},Joined->True,PlotStyle->style2];
     ticks={{{T1,"P"}},None, None, None};
     
     
If[set==1,
ticks={{{T1,"P"}},
{{ruA1,RUnameA1},{ruB1,RUnameB1},
{ruA2,RUnameA2},{ruB2,RUnameB2}}, 
None, None};
plotRU=Show[lineA1,lineA2,lineA3,lineA4,lineA5,pointA1,pointA2,
                    lineB1,lineB2,lineB3,lineB4,lineB5,pointB1,pointB2,
                     text1,text2,rect1,rect2,
                     LabelStyle->font, 
Frame->True,FrameLabel->{"Risk threshold T", "Relative utility", "Relative utility curves",None},
PlotRange->{Automatic,{0,maxru}}, FrameTicks->ticks, AspectRatio->1]];   
     
 
If[set==2,
ticks={{{T1,"P"}},None, None, None};
plotRU=Show[lineA1,lineA2,lineA3,lineA4,lineA5,
                    lineB1,lineB2,lineB3,lineB4,lineB5,
                     text1,text2,rect1,rect2,
                     LabelStyle->font, 
Frame->True,FrameLabel->{"risk threshold T", "RU", nameRU,None},
PlotRange->{Automatic,{0,maxru}}, FrameTicks->ticks, AspectRatio->1]];


plot=GraphicsRow[{plotROC, plotRU}];
Return[{plotROC, plotRU}]]







    

TangentConditionKey[{a_,b_,z_},x_,color_,{k1_,k2_,k3_,k4_,k5_},r_,set_,model_]:=
Module[{roc,plot1,ROCslope, xrule,xvec,xvec0,x0,y0,hL,line1,line2,line3,ru1,ru2,ru3,plot,point1,point2,point3,point4,point5,pointkey,color1,color2},
  roc=ROCZ[x,a,b,z];
  dash=Dashing[{.02,.02}];
  If[color==Blue,   plot1=Plot[roc,{x,0,1},PlotRange->All,PlotStyle->color]];
  If[color==Red,   plot1=Plot[roc,{x,0,1},PlotRange->All,PlotStyle->{color,dash}]];  
  ROCslope=D[roc,x];
  color1=Black;
  color1=Darker[Green];
  color2=Brown;
  color3=Darker[Green];
  color4=Purple;
  color5=Orange;
  {line1,ru1,x1,y1}=TangentLineTOP[ROCslope,{a,b,z},k1,x,color1];
  {line2,ru2,x2,y2}=TangentLine[ROCslope,{a,b,z},k2,x,color2];
   {line3,ru3,x3,y3}=TangentLine[ROCslope,{a,b,z},k3,x,color3];
      {line4,ru4,x4,y4}=TangentLine[ROCslope,{a,b,z},k4,x,color4];
         {line5,ru5,x5,y5}=TangentLine[ROCslope,{a,b,z},k5,x,color5];
    vec={x1,y1,x2,y2}//N;
    point1=Graphics@{color1,PointSize[r],Point[{0,ru1}]};
   point2=Graphics@{color2,PointSize[r],Point[{0,ru2}]};
   point3=Graphics@{color3,PointSize[r],Point[{0,ru3}]};
   point4=Graphics@{color4,PointSize[r],Point[{0,ru4}]};
   point5=Graphics@{color5,PointSize[r],Point[{0,ru5}]};
   {pointkey,namekey}=TangentPointTop[ROCslope,{a,b,z},k1,x,model];
   {pointkey2,namekey2}=TangentPointTopSet2[ROCslope,{a,b,z},k1,x,model];

    {pointkeyB,namekeyB}=TangentPoint[ROCslope,{a,b,z},k2,x,model];
 If[set==1,
       plot=Show[plot1,line1,line2,point1,point2,
       pointkey, namekey, pointkeyB, namekeyB,AspectRatio->1]];
   If[set==2,
    plot=Show[plot1,pointkey, AspectRatio->1]];
  maxru=MaxRU[ROCslope,{a,b,z},x];
  Return[{plot,ru1,ru2,ru3,ru4,ru5,maxru,vec}]]
  
  
  
   MaxRU[ROCslope_,{a_,b_,z_},x_]:=
    Module[{xrule,xvec,xvec0,xvec1,xvec2,x0,y0,ru,line},
     xrule=Quiet@Solve[ROCslope==1,x];
        xvec=x/.xrule;
             xvec0=Flatten[xvec];
       xvec1=Select[xvec0, (Head[#] =!= Complex) &];
       xvec2=Select[xvec1,(#>0 && # <1)&];
       x0=Max[xvec1];
          y0=ROCZ[x0,a,b,z]//N;
     ru=y0-x0;
  Return[ru]];
  
  
  
  TangentLineTOP[ROCslope_,{a_,b_,z_},k_,x_,color_]:=
    Module[{xrule,xvec,xvec0,xvec1,xvec2,x0,y0,ru,line},
     xrule=Quiet@Solve[ROCslope==k,x];
        xvec=x/.xrule;
       xvec0=Flatten[xvec];
       xvec1=Select[xvec0, (Head[#] =!= Complex) &];
       xvec2=Select[xvec1,(#>0 && # <1)&];       
       x0=Max[xvec1];
       y0=ROCZ[x0,a,b,z]//N;       
       ru=y0-x0 k; 
   line=Graphics@{color,Thickness[.01],Line[{{0,ru},{x0,y0}}]};
  Return[{line,ru,x0,y0}]]
  
  
  
  TangentLine[ROCslope_,{a_,b_,z_},k_,x_,color_]:=
  Module[{xrule,xvec,xvec0,xvec1,xvec2,x0,y0,ru,line},
   xrule=Quiet@Solve[ROCslope==k,x];
      xvec=x/.xrule;
     xvec0=Flatten[xvec];
     xvec1=Select[xvec0, (Head[#] =!= Complex) &];
     xvec2=Select[xvec1,(#>0 && # <1)&];     
     x0=Max[xvec1];
     y0=ROCZ[x0,a,b,z]//N;     
     ru=y0-x0 k; 
        line=Graphics@{color,Line[{{0,ru},{x0,y0}}]};
  Return[{line,ru,x0,y0}]]
  
  

  TangentPointTop[ROCslope_,{a_,b_,z_},k_,x_,model_]:=
  Module[{xrule,xvec,xvec0,xvec1,xvec2,x0,y0,ru,line,name,namex},
   xrule=Quiet@Solve[ROCslope==k,x];
      xvec=x/.xrule;
     xvec0=Flatten[xvec];
     xvec1=Select[xvec0, (Head[#] =!= Complex) &];
     xvec2=Select[xvec1,(#>0 && # <1)&];     
     x0=Max[xvec1];
     y0=ROCZ[x0,a,b,z]//N;
     ru=y0-x0 k;
     point=Graphics@{Black,PointSize[.05],Point[{x0,y0}]};
    If[model==1,namex="A1"];
    If[model==2,namex="A2"];
    namez=StringJoin["Point ",namex];
    name=Graphics@Text[namez,{x0 +.05 ,y0},{-1,0}]; 
  Return[{point,name}]]

  
  TangentPointTopSet2[ROCslope_,{a_,b_,z_},k_,x_,model_]:=
  Module[{xrule,xvec,xvec0,xvec1,xvec2,x0,y0,ru,line,name,namex},
   xrule=Quiet@Solve[ROCslope==k,x];
      xvec=x/.xrule;
     xvec0=Flatten[xvec];
     xvec1=Select[xvec0, (Head[#] =!= Complex) &];
     xvec2=Select[xvec1,(#>0 && # <1)&];     
     x0=Max[xvec1];
     y0=ROCZ[x0,a,b,z]//N;
     ru=y0-x0 k;
     point=Graphics@{Black,PointSize[.05],Point[{x0,y0}]};
    If[model==1,namex="A1";
      namez=StringJoin["Point ",namex];
    name=Graphics@Text[namez,{x0 +.05 ,y0},{0,-1}]];
    If[model==2,namex="A2";
          namez=StringJoin["Point ",namex];
        name=Graphics@Text[namez,{x0 +.05 ,y0},{0,1}]];
    
  Return[{point,name}]]

  


  TangentPoint[ROCslope_,{a_,b_,z_},k_,x_,model_]:=
  Module[{xrule,xvec,xvec0,xvec1,xvec2,x0,y0,ru,line,name,namex,color1},
   xrule=Quiet@Solve[ROCslope==k,x];
      xvec=x/.xrule;
     xvec0=Flatten[xvec];
     xvec1=Select[xvec0, (Head[#] =!= Complex) &];
     xvec2=Select[xvec1,(#>0 && # <1)&];     
     x0=Max[xvec1];
     y0=ROCZ[x0,a,b,z]//N;
     ru=y0-x0 k;
     color1=Brown;
     point=Graphics@{color1,PointSize[.03],Point[{x0,y0}]};
    If[model==1,namex="B1"];
    If[model==2,namex="B2"];
    namez=StringJoin["Point ",namex];
    name=Graphics@Text[namez,{x0 +.05 ,y0},{-1,0}]; 
  Return[{point,name}]]





ROC[x_,a_,b_]:= (a x /(1- x + a x)) .8 + (b x /(1- x + b x)) .2 


ROCZ[x_,a_,b_,z_]:=
Module[{roc},
If[z==1,roc= (a x /(1- x + a x)) .8 + (b x /(1- x + b x)) .2];
If[z==2, roc= Sqrt[a x + b x^2]/Sqrt[a + b]];
If[z==3, roc= (a x + b x^2)^(1/3)/  (a + b)^(1/3)];
Return[roc]]


ExportPlotX[figname_,plot0_,format_:"manu"]:=
	  Module[{plotnamejpg,plot},
	  If[format=="talk",
	  plot=Show[plot0,ImageSize->Large], plot=plot0];
	 Print[plot];
         plotnameeps=StringJoin["figrufit",figname,".eps"];    
	 	    	       Export[plotnameeps,plot]; 
	 	              Print["    exporting ",plotnameeps];
	  plotnamejpg=StringJoin["figrufit",figname,".jpg"];    
	 	    	       Export[plotnamejpg,plot]; 
	 	              Print["    exporting ",plotnamejpg]; 	              
	 Return[Null]]



CheckTC1[vec1_,vec2_]:=
Module[{FA1,TA1,FB1,TB1,FA2,TA2,FB2,TB2,maxRU1,maxRU2, RUB1,RUB2, RUB1X, RUB2X},
{FA1,TA1,FB1,TB1}=vec1;
{FA2,TA2,FB2,TB2}=vec2;
maxRU1=TA1-FA1;
maxRU2=TA2-FA2;
RUB1X=TB1-FB1;
RUB2X=TB2-FB2;
RUB1=TB1- 2 FB1;
RUB2=TB2- 2 FB2;
difmaxRU=maxRU2-maxRU1;
difRUB=RUB2-RUB1;
difRUBX=RUB2X-RUB1X;
Print["difmaxRU=  ",difmaxRU];
Print["difRUB=  ",difRUB];
Print["difRUB slope1 = ",difRUBX];
Print["FB2 FB1 ", {FB2, FB1}];
Print["TB2 TB1 ", {TB2, TB1}];
Print["slope B2, slope B1 ", {TB2/FB2, TB1/FB1}];
Print["FA2 FA1 ", {FA2, FA1}];
Print["TA2 TA1 ", {TA2, TA1}];
Print["slope A2, slope A1 ", {TA2/FA2, TA1/FA1}];
Print["delTAB2  delFAB2, slope2 = ", {TA2-TB2, FA2-FB2, (TA2-TB2)/(FA2-FB2)}];
Print["delTAB1  delFAB1  slope1= ", {TA1-TB1, FA1-FB1, (TA1-TB1)/(FA1-FB1)}];
Return[Null]]

CheckTC2[vec1_,vec2_]:=
Module[{FA1,TA1,FB1,TB1,FA2,TA2,FB2,TB2,maxRU1,maxRU2, RUB1,RUB2, RUB1X, RUB2X},
{FA1,TA1,FB1,TB1}=vec1;
{FA2,TA2,FB2,TB2}=vec2;
maxRU1=TA1-FA1;
maxRU2=TA2-FA2;
RUB1X=TB1-FB1;
RUB2X=TB2-FB2;
RUB1=TB1- 2 FB1;
RUB2=TB2- 2 FB2;
difmaxRU=maxRU2-maxRU1;
difRUB=RUB2-RUB1;
difRUBX=RUB2X-RUB1X;


slopeA1=TA1/FA1;
slopeA2=TA2/FA2;
slopeB1=TB1/FB1;
slopeB2=TB2/FB2;
slopeAB1=(TA1-TB1)/(FA1-FB1);
slopeAB2=(TA2-TB2)/(FA2-FB2);

If[slopeAB2> slopeAB1,
     Print["  STEEPER: YES to steeper Model 2 at between A and B"],      
      Print[" STEEPER: NO to steeper Model 2 at between A and B"]];
If[(FA2-FB2) > (FA1-FB1) ,
    Print["   TC2: Yes to larger difference in FPR Model 2"], 
   Print["  TC2: No to larger difference FPR in Model 2"]];
If[difmaxRU> difRUB, Print["  RESULT Yes  to max versus slope 2"],   Print["  RESULT No to max versus slope 2"]];
If[difmaxRU> difRUBX, Print["  RESULT Yes to max versus slope 1"], Print["  RESULT No to max versus slope 1"]];
Print["   percentage increase in maxRU over point B ",  100 (difmaxRU-difRUB)/difmaxRU];


Return[Null]]






End[] 
EndPackage[]

Print["TangentCondition[x,1]  for Figure 5"];
Print["TangentCondition[x,2]  for Figure 6"];

