(*Mathematica:: Verizon 7.0      *)
(*:Context:: "rufit`"        *)
(*:Title::  relative utility  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
  
   	      
BeginPackage["rufitreport`","rufitcore`"]  

TableData::usage="TableData"
TableEstimate::usage="TableEstimate"

Clear[TableData, TableEstimate]



					
Begin["Private`"]	  
    

(*-----------------------------ESTIMATE--------------------------------------------*)

TableEstimate[dataM_,P_,slopemat1_,slopemat2_,
   riskscorevec1_,riskscorevec2_,riskscorename1_,riskscorename2_]:=
Module[{tabORIG1,tabORIG2,tabCONCAVE1,tabCONCAVE2,skipvec1s,skipvec2s},
(*estimation*)
{tabORIG1,tabORIG2,tabCONCAVE1,tabCONCAVE2,skipvec1s,skipvec2s}=
  GenEstimationTable[dataM,P,riskscorevec1,riskscorevec2,riskscorename1,riskscorename2];    
  Print["  "];
  Print["----Model 1 ESTIMATES----------------"];
  Print["Orginal ROC"];
     Print[tabORIG1];
  Print["Concave  slope remainder  (a value of 1000 is default if division by 0)"];
      Print@TableForm[slopemat1,TableHeadings->{skipvec1s,None}];
  Print["Model 1 Concave ROC and RU"];
      Print[tabCONCAVE1];
 Print[" "];
Print["----Model 2 ESTIMATES------"];
  Print["Model 2    Orginal ROC"]; 
    Print[tabORIG2];
 Print["Concave  slope remainder  (a value of 1000 is default if division by 0)"];
        Print@TableForm[slopemat2,TableHeadings->{skipvec2s,None}];
   Print["Model 2    Concave ROC and RU"]; 
       Print[tabCONCAVE2];
       Print[" "];
Return[Null]] 


GenEstimationTable[dataM_,P_,riskscorevec1_,riskscorevec2_,riskscorename1_,riskscorename2_]:=
Module[{tabORG1,tabORIG2,tabCONC1,tabCONC2,skipvec1s,skipvec2s},
{tabORIG1,tabORIG2}=PrintEstORIG[dataM,P,riskscorevec1,riskscorevec2,riskscorename1,riskscorename2];
{tabCONC1,tabCONC2,skipvec1s,skipvec2s}=PrintEstCONC[dataM,P];
Return[{tabORIG1,tabORIG2,tabCONC1,tabCONC2,skipvec1s,skipvec2s}]]

    
    


PrintEstORIG[dataM_,P_,riskscorevec1_,riskscorevec2_,riskscorename1_,riskscorename2_]:=
Module[{ rM1,x1,n1,rM2,x2,n2,modelname1,modelname2,namefit,
range1,range2,x1r,x2r,n1r,nr2,
   R1,P1,roc1,ru1,skipvec1,r1,slope1,fpr1,tpr1,matORIG1,list1,tabORIG1,
   R2,P2,roc2,ru2,skipvec2,r2,slope2,fpr2,tpr2,matORIG2,list2,tabORIG2,head},
  {rM1,x1,n1,rM2,x2,n2,modelname1,modelname2,namefit}=dataM;
 {R1,P1,roc1,ru1,r1,slope1}=RUOriginal[rM1,n1,P];
 {R2,P2,roc2,ru2,r2,slope2}=RUOriginal[rM2,n2,P];
 w1=n1/Apply[Plus,n1];
 w2=n2/Apply[Plus,n2];
 {fpr1,tpr1}=Transpose@Reverse@Drop[roc1,1];
{fpr2,tpr2}=Transpose@Reverse@Drop[roc2,1];
list1=roundz@{w1,r1,fpr1,tpr1,slope1};
list2=roundz@{w2,r2,fpr2,tpr2,slope2};
range1=Range@Length[r1];
range2=Range@Length[r2];
x1r=Round[x1];
x2r=Round[x2];
n1r=Round[n1];
n2r=Round[n2];
matORIG1=Transpose@Join[{range1,riskscorevec1,riskscorename1,x1r,n1r},list1];
matORIG2=Transpose@Join[{range2,riskscorevec2,riskscorename2,x2r,n2r},list2];
head={None,{"interval","avg\nrisk","risk\nrange","x","n","w","r","fpr","tpr","slope"}};
tabORIG1=TableForm[matORIG1,TableHeadings->head];
tabORIG2=TableForm[matORIG2,TableHeadings->head];
Return[{tabORIG1,tabORIG2}]]


PrintEstCONC[dataM_,P_]:=
Module[{ rM1,x1,n1,rM2,x2,n2,modelname1,modelname2,namefit,
R1,P1,roc1,ru1,skipvec1,r1,slope1,slopemat1,fpr1,tpr1,matCONC1,tabCONC1,
R2,P2,roc2,ru2,skipvec2,r2,slope2,slopemat2,fpr2,tpr2,matCONC2,tabCONC2,head},
   {rM1,x1,n1,rM2,x2,n2,modelname1,modelname2,namefit}=dataM;
 {R1,P1,roc1,ru1,skipvec1,r1,slope1,slopemat1}=RUConcave[rM1,n1,P];
 {R2,P2,roc2,ru2,skipvec2,r2,slope2,slopemat2}=RUConcave[rM2,n2,P];
{fpr1,tpr1}=Transpose@Reverse@Drop[roc1,1];
{fpr2,tpr2}=Transpose@Reverse@Drop[roc2,1];
 list1=roundz@{fpr1,tpr1,slope1,r1,ru1,R1};
list2= roundz@{fpr2,tpr2,slope2,r2,ru2,R2};
skipvec1s=SkipSet[skipvec1];
skipvec2s=SkipSet[skipvec2];
matCONC1=Transpose@ Join[{skipvec1s},list1];
matCONC2=Transpose@ Join[{skipvec2s},list2];
head={None,{"intervals","fpr","tpr","slope","r", "ru","R"}};
tabCONC1=TableForm[matCONC1,TableHeadings->head];
tabCONC2=TableForm[matCONC2,TableHeadings->head];
Return[{tabCONC1,tabCONC2,skipvec1s,skipvec2s}]]

SkipSet[vec_]:=SkipOne[#]& /@ vec;

SkipOne[vec_]:=
Module[{string,stringvec},
stringvec=StringJoin[ToString[#]," "]&  /@ Reverse[vec];
(*remove final blank*)
string=StringJoin@stringvec;
Return[string]]



roundz[x_]:=Round[10000 x]/10000//N;

(*---------------------------DATA------------------------------------------------*)
  
    TableData[dataF_]:=
    Module[{xmat,ymat,riskscore1,riskscore2,riskscorename1,riskscorename2,modelname1,modelname2,
       	    markername,datasetname,datatype,namex},
    
     {xmat,ymat,riskscore1,riskscore2,riskscorename1,riskscorename2,modelname1,modelname2,
       	    markername,datasetname,datatype}=dataF;  
      If[IntegerQ[xmat[[1,1]]],  
         namex=" count data ",
         namex=" rounded data"];
       Print["WITH EVENT ",namex];
       PrintTabWithMargin[xmat,datatype];
       Print["WITHOUT EVENT ",namex];
       PrintTabWithMargin[ymat,datatype];
    Return[Null]];
    
    
    PrintTabWithMargin[xmat_,datatype_]:=
    Module[{xmatr,row,col,xmatall,max,xmatallr,lenr,lenc,rowname,colname,rownameX,colnameX,tab},
      row=Apply[Plus,xmat];
      col=Apply[Plus,Transpose[xmat]] ~Join~ {Apply[Plus,row]};
      xmatrow=Append[xmat,row];
      xmatall= Transpose@Append[Transpose[xmatrow],col];
      {lenr,lenc}=Dimensions[xmat];
      rowname=ToString[#]& /@ Range[lenr];
      colname=ToString[#]& /@ Range[lenc];
      rownameX=Join[rowname,{"total"}];
      colnameX=Join[colname,{"total"}];
       max=Max@Flatten[xmatall];
      If[max>100,
       xmatallr=Round[xmatall],
       xmatallr=Round[xmatall 1000]/1000//N];
      tab=TableForm[xmatallr,TableHeadings->{rownameX,colnameX}];
      Print[tab];
    Return[Null]]
    
  
  
End[] 
EndPackage[]

