(*Mathematica:: Verizon 7.0      *)
(*:Context:: "rufit`"        *)
(*:Title::  relative utility  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2016 Stuart G. Baker *)
  
   	      
BeginPackage["rufitrange`","rufitcore`"]  

TestTradeoff::usage="RUTableFitKey[dataF core0,corex]"
ImputeMaxRU::usage="ImputeMaxRU"


Clear[TestTradeoff,ImputeMaxRU]
					
Begin["Private`"]	  
    


 
 TestTradeoff[dataM_,P_,format_,riskvecPLOT_,datatype_,showmap_:False]:=
  Module[{rM1,x1,n1,rM2,x2,n2,riskvec,modelname1,modelname2,namefit,
               R1,P1,roc1,ru1,skipvec1,r1,slope1,slopemat1,
               R2,P2,roc2,ru2,skipvec2,r2,slope2,slopemat2,
               P1data,P2data,
                  RTarget1,RTarget2,RTarget,maxr,Pmin,int,maxru1,maxru2,maxru,fracRU0},
               
               
             
               
               
     {RTarget1L,RTarget1R,RTarget2L,RTarget2R,P0,fracRU0} =riskvecPLOT;
  rL=Min[RTarget2L, RTarget1L];
 rR=Max[RTarget2R,RTarget2L];              
     
         
     (*input*)
       {rM1,x1,n1,rM2,x2,n2,modelname1,modelname2,namefit}=dataM;
   (*compute risk vec*)
     {R1,P1,roc1,ru1z,skipvec1,r1z,slope1,slopemat1}=RUConcave[rM1,n1,P];
     {R2,P2,roc2,ru2z,skipvec2,r2z,slope2,slopemat2}=RUConcave[rM2,n2,P];


 {r1,ru1}=ImputeMaxRU[R1,ru1z,P];
    {r2,ru2}=ImputeMaxRU[R2,ru2z,P];

    maxru1=Max[ru1];
      maxru2=Max[ru2];
      maxru=Min[maxru1,maxru2];
   
     If[showmap, 
     Print["fraction RU target ",fracRU0]];
     If[showmap, Print[" "]; Print["MODEL OLD"]];
     range={0,1,2,3,4,5}/5//N;
     range=Join[{0},Range[50]]/50//N;
     rangeL=rL+ (P2-rL) range;
     rangeR= P2+ (rR-P2) range;

     If[showmap,
      Print[" "];
      Print["Model 1 Left"];
      Print["rangeL ",rangeL]];
      RUTargetList1L=InterpolateQ[r1,ru1,#,"left",P1,showmap]& /@ rangeL;
     
     If[showmap,
      Print[" "];
      Print["Model 1 Right"];
      Print["rangeR ",rangeR]];
     
     RUTargetList1R=InterpolateQ[r1,ru1,#,"right",P1,showmap]& /@ rangeR;   
     
     If[showmap, Print["  "];  Print["MODEL NEW"]];
     If[showmap,
     Print[" "];
      Print["Model 2 Left"];
      Print["rangeL ",rangeL]];
        RUTargetList2L=InterpolateQ[r2,ru2,#,"left",P2,showmap]& /@ rangeL;
     
     If[showmap,
     Print[" "];
     Print["Model 2 Right"];
      Print["rangeR ",rangeR]];
     
     RUTargetList2R=InterpolateQ[r2,ru2,#,"right",P2,showmap]& /@ rangeR;
 
  plotruE=PlotRU[{r1,r2},{ru1,ru2},{rL,rR}];
   {plotruTT, plotRUdif,plotTTx,minTT} =PlotSet[{rangeL,rangeR},{RUTargetList1L,RUTargetList1R},{RUTargetList2L,RUTargetList2R}, P2,showmap];
   plotmat=GraphicsGrid[{{plotruE,plotruINT},{plotRUdif,plotTTx}}];
 plotall=Show[plotmat,ImageSize->Large];

  plotpairRU=GraphicsRow[{plotruE,plotruTT}];
 plotpairRUx=Show[plotpairRU,ImageSize->Large];
 
 plotpair=GraphicsRow[{plotRUdif,plotTTx}];
 plotpairx=Show[plotpair,ImageSize->Large];
 Return[{plotpairRUx,plotpairx,minTT}]]
    
    

  
  
  
  
   ImputeMaxRU[rvec_,ruvec_,P_]:=
       Module[{rvecL,rvecR,num,ruvecL,ruvecR, len,
                xLA,xLB,yLA,yLB,slopeL,rumaxL,
                xRA,xRB,yRA,yRB,slopeR,rumaxR,rumax,
                 rvecNEW,ruvecNEW},
       len=Length[rvec];          
              rvecL=Select[rvec,(#<P)&];
              rvecR=Select[rvec,(#>=P)&];
          num=Length[rvecL];
      
     If[num>1 && num < len-1,
     Print["interpolation maxRU using slopes on both sides"];
          rvecNEW=Join[rvecL,{P},rvecR];
         ruvecL=Take[ruvec,num];
        ruvecR=Drop[ruvec,num];
           (*left side*)
           xLA=rvecL[[-2]];
        xLB=rvecL[[-1]];
         yLA=ruvecL[[-2]];
        yLB=ruvecL[[-1]];
         slopeL=(yLB-yLA)/(xLB-xLA);
        rumaxL=yLB+ slopeL (P-xLB);
      (*right side*)
        xRA=rvecR[[2]];
         xRB=rvecR[[1]];
         yRA=ruvecR[[2]];
         yRB=ruvecR[[1]];
          slopeR=(yRB-yRA)/(xRB-xRA);
         rumaxR=yRB- slopeR (xRB-P);
          rumax=(rumaxR+rumaxL)/2;
          ruvecL=Take[ruvec,num];
           ruvecR=Drop[ruvec,num];
          ruvecNEW=Join[ruvecL,{rumax},ruvecR]]; 
          
        If[num==0,
          rvecNEW=Join[{P},rvecR];
          Print["interpolation max RU for num=0"];
           ruvecNEW=Join[{rumax},ruvec]]; 
            
         If[num==1,
           Print["interpolation max RU for num=1 so slope on right"];
            rvecNEW=Join[rvecL,{P},rvecR];
            ruvecL=Take[ruvec,num];
            ruvecR=Drop[ruvec,num];
         (*right side*)
              xRA=rvecR[[2]];
               xRB=rvecR[[1]];
               yRA=ruvecR[[2]];
               yRB=ruvecR[[1]];
                slopeR=(yRB-yRA)/(xRB-xRA);
             rumaxR=yRB- slopeR (xRB-P);
               ruvecL=Take[ruvec,num];
             ruvecR=Drop[ruvec,num];
               ruvecNEW=Join[ruvecL,{rumaxR},ruvecR]]; 
         
        
        If[num==len-1,
           Print["interpolation maxRU for num= length-1 so slope on left"];
             rvecNEW=Join[rvecL,{P},rvecR];
               ruvecL=Take[ruvec,num];
              ruvecR=Drop[ruvec,num];
                  (*left side*)
   	            xLA=rvecL[[-2]];
   	         xLB=rvecL[[-1]];
   	          yLA=ruvecL[[-2]];
   	         yLB=ruvecL[[-1]];
   	          slopeL=(yLB-yLA)/(xLB-xLA);
        rumaxL=yLB+ slopeL (P-xLB);
              ruvecNEW=Join[ruvecL,{rumaxL},ruvecR]];
         
           If[num==len,
                Print["interpolation max RU for num=0"];
                rvecNEW=Join[rvecL,{P}];
                 rumax=Max[ruvec];
              ruvecNEW=Join[ruvec,{rumax}]]; 
         
     
  Return[{rvecNEW,ruvecNEW}]]
  
  
  
   
        PlotRU[{r1_,r2_},{ru1_,ru2_},{rL_,rR_}]:=
        Module[{RUTargetList1, RUTargetList2, range,pair1,pair2,plot1,plot2,maxru,color1,color2,
        dash1,k1,k2,name1,name2,linename1,linename2,
        RUdifvec,plotRUdif,pairRUdif,plotRUdifx,
        TTvec,pairTT,plotTT,plotTTx,plotruE},
        
    
       pairru1=Transpose[{r1,ru1}];
         pairru2=Transpose[{r2,ru2}];
         pair1=Select[pairru1,(#[[1]]>=rL && #[[1]]<=rR)&];
     pair2=Select[pairru2,(#[[1]]>=rL && #[[1]]<=rR)&];
         color1=Red;
            color2=Blue;
            dash1=Dashing[{.03,.03}];
           maxru=Max@Join[ru1,ru2];
       prange={Automatic,{-.1,maxru}};
          plot1=ListPlot[pair1,Joined->True, PlotStyle->{color1,dash1},PlotRange->prange];
          plot2=ListPlot[pair2,Joined->True, PlotStyle->color2, PlotRange->prange];
   
         k2=maxru .4;
         k1=maxru .3;
         z=rR-rL;
         name1=Graphics@Text["Model 1",{.1 z,k1},{1,0}];
         name2=Graphics@Text["Model 2",{.2 z,k2},{1,0}];
         linename1=Graphics@{color1, dash1, Line[{{.2 z , k1},{.3z,k1}}]};
        linename2=Graphics@{color2,  Line[{{.2 z, k2},{.3 z,k2}}]};
        plotruE=Show[plot1,plot2,name1,name2,linename1,linename2, 
        Frame->True,AspectRatio->1,
                  FrameLabel->{"risk threshold", "relative utility"}];
        Return[plotruE]] 
     
    
    
    
    
    PlotSet[{rangeL_,rangeR_},{RUTargetList1L_,RUTargetList1R_},{RUTargetList2L_,RUTargetList2R_}, P2_,showmap0_]:=
    Module[{RUTargetList1, RUTargetList2, range,pair1,pair2,plot1,plot2,maxru,color1,color2,
    dash1,k1,k2,name1,name2,linename1,linename2,
    RUdifvec,plotRUdif,pairRUdif,plotRUdifx,
    TTvec,pairTT,plotTT,plotTTx},
    showmap=False;
        
    If[showmap,
       Print["  "];
         Print["RU target left model 1 ",RUTargetList1L];
         Print["RU target right model 1 ",RUTargetList1R];
       Print["RU target left model 2 ",RUTargetList2L];
       Print["RU target right model 2 ",RUTargetList2R]];

      RUTargetList1=Join[RUTargetList1L,RUTargetList1R];
      RUTargetList2=Join[RUTargetList2L,RUTargetList2R];
     range=Join[rangeL,rangeR];
        maxru=Max@Join[RUTargetList1,RUTargetList2];
      pair1= Transpose[{range,RUTargetList1}];
      pair2= Transpose[{range,RUTargetList2}];
     color1=Red;
        color2=Blue;
        dash1=Dashing[{.03,.03}];
   
   prange={Automatic,{-.1,maxru}};
   plot1=ListPlot[pair1,Joined->True, PlotStyle->{color1,dash1},PlotRange->prange];
            plot2=ListPlot[pair2,Joined->True, PlotStyle->color2, PlotRange->prange];
   
   
     k2=maxru .4;
     k1=maxru .3;
     name1=Graphics@Text["Model 1",{.1 z,k1},{1,0}];
     name2=Graphics@Text["Model 2",{.2 z,k2},{1,0}];
     linename1=Graphics@{color1, dash1, Line[{{.2, k1},{.3,k1}}]};
    linename2=Graphics@{color2,  Line[{{.2z, k2},{.3z,k2}}]};
    plotru=Show[plot1,plot2,name1,name2,linename1,linename2, Frame->True,
    AspectRatio->1,
              FrameLabel->{"risk threshold", "relative utility"}];
     
     
    (*RU DIF*)      
        RUdifvec= (RUTargetList2-RUTargetList1);
          pairRUdif=Transpose[{range,RUdifvec}];          
          plotRUdif=ListPlot[pairRUdif,Joined->True,PlotRange->All];
          plotRUdifx=Show[plotRUdif,Frame->True,AspectRatio->1,
          FrameLabel->{"risk threshold ", "difference in RU", "Differences in Relative Utilities"}];
     
     (*TEST Tradeoff*)
        RUdifTarget= .1 maxru;
        RUdifL= (RUTargetList2L-RUTargetList1L);
        pairRUdifL0=Transpose[{rangeL,RUdifL}];
        pairTTL=CompTT[#,P2,RUdifTarget]& /@ pairRUdifL0;
  
         RUdifR= (RUTargetList2R-RUTargetList1R);
          pairRUdifR0=Transpose[{rangeR,RUdifR}];
          
          
          pairTTR=CompTT[#,P2,RUdifTarget]& /@ pairRUdifR0;
          
          
     pairTT0=Join[pairTTL,pairTTR];
     pairTT=Select[pairTT0,( (#[[2]] >0) && (#[[2]] < 1/ (P RUdifTarget)) )&];
     lenTT=Length[pairTT];
     If[lenTT>0,
     {riskvec,ttvec}=Transpose[pairTT];
     minTT=Min[ttvec],
     Print["All test tradeoffs are negative"];
     minTT=0];
  RUdifTargets=ToString@Round[1/(P RUdifTarget)];
  plotname=StringJoin["Test Tradeoff Curves  upper bound = ",RUdifTargets];
  plotname="Test Tradeoff Curves";
     
    
     plotTT=ListPlot[pairTT,Joined->True,PlotRange->All];
     plotTTx=Show[plotTT,Frame->True ,AspectRatio->1,FrameLabel->{"risk threshold ", "test tradeoff", plotname}];
     plotTTz=Show[plotTTx,ImageSize->Large];
   
     Return[{plotru, plotRUdifx,plotTTx,minTT}]]


CompTT[{r_,RUdif_}, P_,RUdifTarget_]:=
Module[{TT},
  If[RUdif >= RUdifTarget && RUdif >0,   TT=1/(P RUdif)];
  If[RUdif < RUdifTarget  && RUdif >0 , TT=1/ (P RUdifTarget)];
  If[RUdif <=0, TT=0];  
Return[{r,TT}]]


PrintPairQ[rvec_,ruvec_,riskvalue_,relreg_,P_,showmap_:False]:=
Module[{pair1,pair1x,pair2,pair2x,ru1i,ru2i,dru,hvec,hvecx,pair,show,res,nett},
      pair=Transpose[{rvec,ruvec}];
      If[showmap,     Print["REGION ",relreg]];
      If[relreg=="left", 
         pairvecL0={{0.0,0.0}} ~Join~  Select[pair,(#[[1]]<P)&];
         pairvecL=RemoveRepeatsL[pairvecL0,showmap];
         If[showmap,Print[pairvecL]]];
      If[relreg=="right",
           pairvecR0=Select[pair,(#[[1]]>=P)&] ~Join~ {{1.0,0.0}};
          pairvecR=RemoveRepeatsR[pairvecR0,showmap];
           If[showmap,Print[pairvecR]]];
  Return[Null]]

    

InterpolateQ[rvec_,ruvec_,riskvalue_,relreg_,P_,showmap_:False]:=
Module[{pair1,pair1x,pair2,pair2x,ru1i,ru2i,dru,hvec,hvecx,pair,show,res,nett},

      pair=Transpose[{rvec,ruvec}];
      If[showmap,     Print["REGION ",relreg, "   risk target ",riskvalue]];
      If[relreg=="left", 
        num=Length@Select[pair,(#[[1]]<P)&];
        pairadd=pair[[num+1]];
      pairvecL0={{0.0,0.0}} ~Join~  Select[pair,(#[[1]]<P)&] ~Join~ {pairadd};
         pairvecL=RemoveRepeatsL[pairvecL0,showmap];
         If[showmap,Print["pairvecL ",pairvecL]];
        rutarget= intoneQL[pairvecL,riskvalue,showmap]];
      If[relreg=="right",
      num=Length@Select[pair,(#[[1]]<P)&];
      pairadd=pair[[num-1]]; 
      If[num==1,  pairadd=pair[[num]]];
        pairvecR0={pairadd}~Join~ Select[pair,(#[[1]]>=P)&] ~Join~ {{1.0,0.0}} ;
          pairvecR=RemoveRepeatsR[pairvecR0,showmap];
           If[showmap,Print["pairvecR ",pairvecR]];
           rutarget= intoneQR[pairvecR,riskvalue,showmap]];
  Return[rutarget]]





RemoveRepeatsL[pairvec_,showmap_]:=
Module[{rvec,ruvec,ruvec0,len0,pairvecX},
 {rvec,ruvec}=Transpose[pairvec];
  ruvec0=Select[ruvec,(#<=.001)&];
  len0=Length[ruvec0]-1;
  If[showmap==True, Print["   remove Left ",len0]];
  pairvecX=Drop[pairvec,len0];
Return[pairvecX]]

RemoveRepeatsR[pairvec_,showmap_]:=
Module[{rvec,ruvec,ruvec0,len0,pairvecX},
 {rvec,ruvec}=Transpose[pairvec];
  ruvec0=Select[ruvec,(#<=.001)&];
  len0=Length[ruvec0]-1;
  If[showmap==True, Print["   remove Right ",len0]];
  pairvecX=Drop[pairvec,-len0];
Return[pairvecX]]



intoneQL[pairvec_,riskvalue_,showmap_:False]:=
Module[{numtot,num,xL,yL,xU,yU,rutarget,len}, 
  numtot=Length[pairvec];
  num=Length@Select[pairvec,(#[[1]]<riskvalue)&];
 If[showmap,
  Print["    numtotal= ",numtot,"   number selected= ",num]];
 (*larger to the right*)
  If[num>1 && num==numtot, 
       (*slope is previous extrapolate to right*)
        {xL,yL}=pairvec[[num-1]];
        {xU,yU}=pairvec[[num]];
        rutarget=SlopeAdjustL[{xL,yL,xU,yU},riskvalue,showmap]];
   If[num>=1 && num<numtot, 
      (*slope surrogates riskvalue for interpolation*)
       {xL,yL}=pairvec[[num]];
       {xU,yU}=pairvec[[num+1]];
       rutarget=SlopeAdjustL[{xL,yL,xU,yU},riskvalue,showmap]];
  If[num==1 && numtot==1, 
     rutarget=pairvec[[1,1]]];
 If[num==0, rutarget=0];
  If[showmap, Print["    rutarget Left ", rutarget]];
 Return[rutarget]]



intoneQR[pairvec_,riskvalue_,showmap_]:=
Module[{numtot,num,xL,yL,xU,yU,rutarget,lenshow}, 
   numtot=Length[pairvec];
   num=Length@Select[pairvec,(#[[1]]<riskvalue)&];
   If[showmap,
     Print["    numtotal= ",numtot,"   number selected= ",num]];
    (*larger to the left*)
    If[num>1 && num==numtot, 
          (*slope is previous extrapolate to left*)
           {xL,yL}=pairvec[[num-1]];
           {xU,yU}=pairvec[[num]];
          rutarget=SlopeAdjustR[{xL,yL,xU,yU},riskvalue,showmap]];
   If[num>=1 && num<numtot, 
    (*slope surrogates riskvalue for interpolation*)
     {xL,yL}=pairvec[[num]];
     {xU,yU}=pairvec[[num+1]];
     rutarget=SlopeAdjustR[{xL,yL,xU,yU},riskvalue,showmap]];
  If[num==1 && numtot==1, 
     rutarget=pairvec[[1,1]]];
    If[num==0,  rutarget=1];
   If[showmap, Print["    rutarget Right ", rutarget]];
  Return[rutarget]]



   SlopeAdjustL[{xL_,yL_,xU_,yU_},riskvalue_,showmap_:False]:=
   Module[{slope,res,rutarget},
    If[xU>xL,
       slope= (yU-yL)/(xU-xL);
       If[showmap,
       Print["   xL yL ", {xL,yL}];
       Print["   xU yU ", {xU,yU}]];
        rutarget=yL + slope (riskvalue-xL),
       Print["RU vertical line xL yL xU yU ",{xL,yL,xU,yU}];
      rutarget=yU];
        If[showmap, Print[" riskvalue ",riskvalue,"  slope ",slope,"  RUtarget ",rutarget]];
Return[rutarget]]


 SlopeAdjustR[{xL_,yL_,xU_,yU_},riskvalue_,showmap_:False]:=
   Module[{slope,res,rutarget},
    If[xU>xL,
       slope= (yU-yL)/(xU-xL);
       If[showmap,
       Print["  riskvalue ",riskvalue];
       Print["   xL yL ", {xL,yL}];
       Print["   xU yU ", {xU,yU}];
       Print["   slope ",slope]];
        rutarget=yL + slope (riskvalue-xL),
       Print["RU vertical line xL yL xU yU ",{xL,yL,xU,yU}];
      rutarget=yU];
        If[showmap, Print["   RUtarget ",rutarget]];
Return[rutarget]]




(*-----export------------------------------------------------------*)    
    
ExportPlot[figname_,datasetname_,plot0_,format_:"manu"]:=
	  Module[{plotnamejpg,plot},
	  (*
	  If[format=="talk",
	  plot=Show[plot0,ImageSize->Large], plot=plot0];
	  *)
	  plot=plot0;
	 Print[plot];
         plotnameeps=StringJoin["figrufit",datasetname,figname,".eps"];    
	 	    	       Export[plotnameeps,plot]; 
	 	              Print["    exporting ",plotnameeps];
	 	              (*
	  plotnamejpg=StringJoin["figrufit",datasetname,figname,".jpg"];    
	 	    	       Export[plotnamejpg,plot]; 
	 	              Print["    exporting ",plotnamejpg]; 	              
	 	              *)
	 Return[Null]]


  
  
  
  
  
 
  
End[] 
EndPackage[]

