  
(*Mathematica:: Version 8.0    *)
(*:Context:: "rufit`"                     *)
(*:Title::  relative utility fitting     *)
(*:Summary::                         *)
(*:References::                       *)
(*Date   2016 Stuart G. Baker *)

(*Input 
ImputeMaxRU		from rufitrange.m
RUConcave             from rufitcore.m
RUOriginal 		from rufitcore.m*)

BeginPackage["rufitplot`","rufitcore`","rufitrange`"]  

PlotROCRUConcave::usage="PlotROCRUConcave"
PlotROCRUOriginal::usage="PlotROCRUOriginal"
PlotRiskMap::usage="PlotRiskMap"
PlotDecisionRule::usage="PlotDecisionRule"


Clear[PlotROCRUConcave,PlotROCRUOriginal,PlotRiskMap,PlotDecisionRule];
 
Begin["Private`"]	  


PlotROCRUConcave[dataM_,P_,format_,riskvecPLOT_,showzone_,pointsize_,datatype_]:=
  PlotROCRUCore[dataM,P,format,riskvecPLOT,"concave",showzone,pointsize,datatype]

PlotROCRUOriginal[dataM_,P_,format_,riskvecPLOT_,showzone_,pointsize_,datatype_]:=
  PlotROCRUCore[dataM,P,format,riskvecPLOT,"original",showzone,pointsize,datatype]


     



PlotROCRUCore[dataM_,P_,format_,riskvecPLOT_,type_,showzone_,pointsize_,datatype_]:=
Module[{rM1,x1,n1,rM2,x2,n2,name1,name2,name,rocname,runame,auc1,auc2,
             r1,P1,roc1,pairru1,ru1,pairnb1,nb1,pairnx1,skipvec1,slopemat1,
             r2,P2,roc2,pairru2,ru2,pairnb2,nb2,pairnx2,skipvec2,slopemat2,res,
             plotru1,plotru2,plotroc1,plotroc2,set,
             plotru,plotroc,plotset},
    (*FITS TO ROC CURVE*)
     {rM1,x1,n1,rM2,x2,n2,name1,name2,name}=dataM;
       If[type=="concave",
           {R1,P1,roc1,ru1,skipvec1,r1,slope1,slopemat1}=RUConcave[rM1,n1,P];
          {R2,P2,roc2,ru2,skipvec2,r2,slope2,slopemat2}=RUConcave[rM2,n2,P]];
      If[type=="original",
        {R1,P1,roc1,ru1,r1,slope1}=RUOriginal[rM1,n1,P];
        {R2,P2,roc2,ru2,r2,slope2}=RUOriginal[rM2,n2,P]];
   (*Plot RU*)     
   If[type=="concave",
       {plotru,plotru1,plotru2,plotruSTT,maxru1,maxru2}=
          PlotRU[{ru1,R1,P1,name1},{ru2,R2,P2,name2},name,format,type,riskvecPLOT,pointsize,datatype,showzone]];
   (*no plot for original data*)
   If[type=="original",
          {plotru,plotru1,plotru2,plotruSTT}={0,0,0,0}];
      
   (*Plot ROC*)
      {plotroc,auc1,auc2}=PlotROC[{roc1,P1,name1},{roc2,P2,name2},name,format,type,pointsize,datatype];
    (*RESULTS*)
       plotset={plotroc,plotru};
       If[type=="concave",  res={auc1,auc2,maxru1,maxru2,plotset,R1,R2,skipvec1,skipvec2,slopemat1,slopemat2,plotroc,plotru,plotru1,plotru2,plotruSTT}];
        If[type=="original",  res={plotset,R1,R2,plotroc,plotru,plotru1,plotru2,plotruSTT}];     
   Return[res]]
     
     
  
  (*---------------------------------------RELATIVE UTLITY-----------------------------------------------------*)
  
  PlotRU[{ru1z_,R1z_,P1_,name1_},{ru2z_,R2z_,P2_,name2_},name_,format_,type_,riskvecPLOT_,pointsize_,datatype_,showzone_]:=
  Module[{maxru,pairru1,pairru2,runame,plotru1,plotru2,xmin,xmax,xdif,
           maxrux,maxru1,maxru2,STT1,STT2,hL,hR,P,Pr,rL0,rR0,rLs,rRs,
          plotpoints1, plotpoints2,
          zonevec1,zonevec2,range,
          ruplotvec,ruplotvec1,ruplotvec2,R1,ru1,R2,ru2},
       (*BOUNDARIES*)     
               {rL1,rR1,rL2,rR2,rP,fracRU}=riskvecPLOT;
	        rR=Max[rR1,rR2];
	        rL=Min[rL1,rL2];  
                   xdif=rR-rL;
                   xmax=rR;
                   xmin=rL;
                 (*adjustment for range*)
               adj=.4 (xmax-xmin);
        (*IMPUTATION*)
            {R1,ru1}=ImputeMaxRU[R1z,ru1z,P2];
          {R2,ru2}=ImputeMaxRU[R2z,ru2z,P2];
         
      (*RU for plotting *)  
        maxru=Max@Join[ru1,ru2];
         pairru1=Transpose[{R1,ru1}];
         pairru2=Transpose[{R2,ru2}];
         
     
         
       (*PLOT RU*)		
             runame="RU curves";
             {plotru1,plotrucore1}=PlotRUone[{pairru1,1,P1,name1,name2,name},{maxru,format},riskvecPLOT,adj];
             {plotru2,plotrucore2}=PlotRUone[{pairru2,2,P2,name1,name2,name},{maxru,format},riskvecPLOT,adj];	 
             
        (*summary test tradeoff*)     
             maxru1=Max[ru1];
  	     maxru2=Max[ru2];
  	   (*for label*)  
  	     maxrux=1.2 Max@Join[ru1,ru2];          
  	  (*tick label based on Model 2*)       
               {rLs,rRs}=RoundRiskPercent[rL2,rR2];
               xticks={{rL2,rLs},{rR2,rRs}};
	 (*prob event label*)
	   P=(P1+P2)/2;
	     z=100;
      	   If[P>=.01,                   Pr= z Round[P   1000]/1000//N;                    Ps=PaddedForm[Pr,{2,1}]];
           If[P>.001 && P<.01 ,    Pr=z Round[P  10000]/10000//N;                   Ps=PaddedForm[Pr,{2,1}]];
           If[P<.001,                   Pr=z Round[P  100000]/100000//N;                  Ps=PR];
               nameP=StringJoin["P= pr(event) =",ToString[Ps],"%"];
                xmid=(xmin+xmax)/2;
	       	                 If[P>xmid, hL0=.05, hL0=.97];
	       	                  hR0=hL0+.06;
	       	                  hR=xmin+ hR0 xdif;
                                  hL=xmin+hL0 xdif;
               hP=xmin-adj+.05 xdif;
               textP=Graphics@TextX[nameP,{hP,.88 maxrux},{-1,0},format];
           (*points*)    
                plotpoints1=ListPlot[pairru1,PlotStyle -> {Red,PointSize[pointsize]}];
               plotpoints2=ListPlot[pairru2,PlotStyle -> {Blue,PointSize[pointsize]}];
          (*treat all and treat none*)     
                zonevec1=   PlotZone[riskvecPLOT,P,1,maxrux,format,adj,xmin,xmax];
                zonevec2=   PlotZone[riskvecPLOT,P,2,maxrux,format,adj,xmin,xmax];
          (*plots*)
              range={{xmin-adj,xmax+adj},Automatic};
              If[showzone==True,
              ruplotvec=Join[{plotru1,plotru2,plotpoints1,plotpoints2},zonevec2,{textP}];
  	       ruplotvec1=Join[{plotrucore1,plotpoints1},zonevec1];
  	       ruplotvec2=Join[{plotrucore2,plotpoints2},zonevec2]];
  	      If[showzone==False,
	              ruplotvec=Join[{plotru1,plotru2,plotpoints1,plotpoints2},{textP}];
	            ruplotvec1=Join[{plotrucore1,plotpoints1}];
	              ruplotvec2=Join[{plotrucore2,plotpoints2}]];
  	      If[format=="talk",fontsize=18];
              If[format=="manu",fontsize=Medium];
              (*aspect ratio*)
              If[format=="talk", ar=1];
	                    If[format=="manu",ar=1];
              plotru=Show[ruplotvec, Frame->True,PlotRange->range, BaseStyle -> {fontsize, Black,Bold,FontFamily -> "Times"},
                     FrameTicks->{xticks,Automatic,None,None}, FrameLabel->{"risk threshold T","RU",runame},
                     AspectRatio->ar];
                  plotrux1=Show[ruplotvec1, Frame->True, PlotRange->range, BaseStyle -> {fontsize, Black, Bold,FontFamily -> "Times"},
	                            FrameTicks->{xticks,Automatic,None,None},FrameLabel->{"risk threshold T","RU",runame},
	                            AspectRatio->ar];
                  plotrux2=Show[ruplotvec2, Frame->True, PlotRange->range, BaseStyle -> {fontsize, Black, Bold,FontFamily -> "Times"},
		  	   FrameTicks->{xticks,Automatic,None,None},FrameLabel->{"risk threshold T","RU",runame},
		  	   AspectRatio->ar];
		  	   
   
	     ruplotvecZ={plotru1,plotru2,plotpoints1,plotpoints2};
	     plotruSTT=Show[ruplotvecZ, Frame->True,PlotRange->range, BaseStyle -> {fontsize, Bold,FontFamily -> "Times"},
	                          FrameTicks->{xticks,Automatic,None,None}, FrameLabel->{"risk threshold T","RU",runame},AspectRatio->1];
	                     
              Return[{plotru,plotrux1,plotrux2,plotruSTT,maxru1,maxru2}]]   
            
            
            
              RoundRiskPercent[x1_,x2_]:=
              Module[{xr,z,rL0,rR0,rLs,rRs,xvec,xvecr},
              x=Max[x1,x2];
              xvec={x1,x2};
              z=100; (*percent*)
              If[x>.1,                       xvecr =z Round[xvec  100]/100 //N];
              If[x>.01 && x <.1,      xvecr =z Round[xvec   1000]/1000//N];
              If[x>.001 && x <.01,   xvecr =z Round[xvec   10000]/10000//N];
              If[x>.0001 && x <.001, xvecr =z Round[xvec 100000]/100000//N];
              If[x<.0001,                xvecr = z Round[xvec  1000000]/1000000//N];
              {rL0,rR0}=xvecr;
               rLs=StringJoin[ToString[rL0], "%"];
              rRs=StringJoin[ToString[rR0],"%"];
               Return[{rLs,rRs}]] 
              
            
          
  
 PlotRUone[{pair_,model_,P_,name1_,name2_,namep_},{maxru_,format_},riskvecPLOT_,adj_]:=
Module[{color1,color2,th, style1, style2, vmax, v2,v1, hL, hR,
           text1,text2,rect1,rect2,range,plotx,plotcorem,dash},
     (*lines*)
      {rL1,rR1,rL2,rR2,rP,fracRU}=riskvecPLOT;
     rR=Max[rR1,rR2];
                 rL=Min[rL1,rL2];
                      xdif=rR-rL;
		             xmax=rR  + .1 xdif;
            xmin=rL-.1 xdif;
     dash=Dashing[{.01,.01}];
       color1=Red;
       color2=Blue;
       If[format=="manu",th=.004, th=.008];
       style1={Thickness[th],color1,dash};
       style2={Thickness[th],color2};
      If[model==1, plotrumod=ListPlot[pair,Joined->True,PlotStyle->style1]];
      If[model==2, plotrumod=ListPlot[pair,Joined->True,PlotStyle->style2]];
   (*vertical locations of text*)
      vmax=1.2 maxru;
        v2=.8 vmax;
         v1= .7 vmax;
     (* horizontal locations*)
    xmid=(xmin+xmax)/2;
                         If[P<=xmid,
	                   hL=xmin+ adj + .98 xdif;
	    	        hR=hL + .05 xdif];
	                 If[P>xmid, 
	                    hL=xmin+.25 xdif;
	                    hR=hL + .05 xdif];
        If[format=="manu",name1x=name1; name2x=name2];
      If[format=="talk",name1x=Style[name1,Red]; name2x=Style[name2,Blue]];
      text1 =Graphics@TextX[name1x,{hL,v1},{1,0},format];  
     text2 =Graphics@TextX[name2x,{hL,v2},{1,0},format];   
    rect1=ListPlot[{{hL,v1},{hR,v1}},Joined->True,PlotStyle->style1];
     rect2=ListPlot[{{hL,v2},{hR,v2}},Joined->True,PlotStyle->style2];   
 
 (*plot*)
   range={{xmin, xmax},{0,vmax}};      
   range=Automatic;
  plotx=Show[plotrumod,text1,rect1,text2,rect2, 
        PlotRange->range,  Axes->None,Frame->True];
     plotcore=Show[plotrumod, 
        PlotRange->range,  Axes->None,Frame->True];
  Return[{plotx,plotcore}]]
 
  
     PlotZone[riskvecPLOT_,P_,model_,maxrux_,format_,adj_,xmin0_,xmax0_]:=
     Module[{rL1,rR1,rL2,rR2,rP,fracRU, colorN,colorA,xA,xN,hL,hR,nameN,lineN,textN,linetextN,nameA,lineA,textA,linetextA,zonevec},
            {rL1,rR1,rL2,rR2,rP,fracRU}=riskvecPLOT;
            rR=Max[rR1,rR2];
            rL=Min[rL1,rL2];
            xdif=rR-rL;
	    xmax=xmax0+ .1 xdif;
            xmin=xmin0 -.1 xdif;
  	 
  	    (*RECTANGLE At bottom*)
              colorN=Darker[Brown];
  	       colorA=Darker[Green];
  	       (*Based on model 2*)
  	       bot=maxrux .03;
               lineA=Graphics@{colorA,Rectangle[{xmin-adj,-bot},{rL2,fracRU}]};
               lineN=Graphics@{colorN,Rectangle[{rR2,-bot},{xmax+adj,fracRU}]};
            
            (*horizontal*) 
               xmid=(xmin+xmax)/2;
               If[P<=xmid,
               (*right side*)
            hL=xmin+ adj + .98 xdif;
	        hR=hL + .05 xdif];
             If[P>xmid, 
               (*left side*)
            hL=xmin+.25 xdif;
                hR=hL + .05 xdif];
            
            (*vertical*)  
               vA=.6 maxrux;
                vN=.5 maxrux;
                 textN=Graphics@TextX["treat none",{hL-.06 xdif, vN},{1,0},format];   
  	         textA=Graphics@TextX["treat all",{hL-.06 xdif, vA},{1,0},format];   
                 (*
                 linetextN=Graphics@{colorN, Thickness[.04],Line[{{hL,vN},{hR, vN}}]};
  	         linetextA=Graphics@{colorA,Thickness[.04],Line[{{hL,vA},{hR, vA}}]};
              *)
                 hx=(bot+fracRU)/2;
                  linetextN=Graphics@{colorN,Rectangle[{hL,vN-hx},{hR,vN+hx}]};
                  linetextA=Graphics@{colorA,Rectangle[{hL,vA-hx},{hR,vA+hx}]};
                 
                 zonevec={lineA,lineN,textA,textN,linetextA,linetextN};
                 
                        (*
            (*TEXT*)
            If[format=="manu", ytext=fracRU];
            If[format=="talk", ytext=fracRU + maxrux .1];
                textAX=Graphics@TextX["treat\nall",{xmin-adj/2, ytext},{-1,0},format];   
	      	 textNX=Graphics@TextX["treat\nnone",{xmax+adj/2, ytext},{1,0},format];   
	         zonevec={textNX,textAX};
	         *)
	       Return[zonevec]];
     
     
     

(*-----------------PLOT------------ROC--------------------------*)


   PlotROC[{roc1_,P1_,name1_},{roc2_,P2_,name2_},name_,format_,type_,pointsize_,datatype_]:=
     Module[{rocname,plotroc1,plotroc2,plotpoint1roc,plotpoints2roc, plotroc,fontsize,auc1,auc2,mtt},
      	 rocname=StringJoin[name,"\nROC curves"];
            	 If[type=="original",     	 rocname0="Preliminary ROC Curves"];
            	 If[type=="concave" && format=="manu",  	 rocname0="Concave ROC Curves"];
            	 If[type=="concave" && format=="talk",  	 rocname0="Concave ROC Curves"];
            	 rocname=StringJoin["marker: ",name,"     ROC curves"];
               rocname=rocname0;
           {plotroc1,auc1}=PlotROCone[roc1,1,P1,name1,name2,name,format];
            {plotroc2,auc2}=PlotROCone[roc2,2,P2,name1,name2,name,format];
              plotpoints1roc=ListPlot[roc1,PlotStyle -> {Red,PointSize[pointsize]}];
              plotpoints2roc=ListPlot[roc2,PlotStyle -> {Blue,PointSize[pointsize]}];
                 If[format=="talk",fontsize=18];
              If[format=="manu",fontsize=Medium];
             plotroc=Show[plotroc1,plotroc2, plotpoints1roc,plotpoints2roc,
                        BaseStyle -> {fontsize, Black, Bold,FontFamily -> "Times"},
                         FrameTicks->{Automatic,Automatic,None,None},
                         Frame->True,FrameLabel->{"FPR","TPR", rocname},
                    AspectRatio->1];
       Return[{plotroc,auc1,auc2}]]
     


PlotROCone[roc_,model_,P_,name1_,name2_,namep_,format_]:=
Module[{plot1,plot2,range,plotx,slopevec,post,rocpos,arrow,fpr0,tpr0,vert,plot0,
         a,b,z1,z2,z3,z4,e,text1,text2,rect1,rect2,vertname,ex,rv, ar,  trix,rescore,
         color1,color2,style0,style1,style2,
        res1,fpr,tpr,name,res2,tri,textset,auc,aucr,aucname,textauc},
  (*vertical positions for text*)
      z1=.1;
      z2=.2;	    
  (*horizontal positions for for model name text*)
  If[format=="manu",   a=.55];
      b=.65;
      e=.01;
   If[format=="talk", a=.90; b=.99; z1=.2; z2=.3];   
  (*AUC*)
      auc=AUC[roc];
      aucr=Round[auc 100]/100//N;
      aucname=StringJoin["    AUC= ",ToString[aucr]];
    If[format=="manu",
       If[model==1, textauc =Graphics@TextX[aucname,{b,z1},{-1,0},format]];   
       If[model==2, textauc =Graphics@TextX[aucname,{b,z2},{-1,0},format]]];  
 If[format=="talk",
 bQ=.01;
 z1Q=.8;
 z2Q=.9;
 aucname1=Style[aucname,Red];
 aucname2=Style[aucname,Blue];
      If[model==1, textauc =Graphics@TextX[aucname1,{bQ,z1Q},{-1,0},format]];   
      If[model==2, textauc =Graphics@TextX[aucname2,{bQ,z2Q},{-1,0},format]]];  
 (*model names*)
         If[format=="manu",th=.005];
         If[format=="talk",th=.011];
          color1=Red; 
          color2=Blue; 
           style0={GrayLevel[.5] ,Dashing[{.01,.01}]};
           style1={Thickness[th],color1,Dashing[{.02,.02}]};
          style2={Thickness[th], color2};
      If[format=="manu",name1x=name1; name2x=name2];
      If[format=="talk",name1x=Style[name1,Red]; name2x=Style[name2,Blue]];
      text1 =Graphics@TextX[name1x,{a-e,z1},{1,0},format];   
     rect1=ListPlot[{{a+.01,z1},{b,z1}},Joined->True,PlotStyle->style1];
     text2 =Graphics@TextX[name2x,{a-e,z2},{1,0},format];   
     rect2=ListPlot[{{a+.01,z2},{b,z2}},Joined->True,PlotStyle->style2];
  (*CREATE ROC CURVE*)
     plot0=ListPlot[{{0,0},{1,1}},Joined->True,PlotStyle->style0];
     If[model==1, plot2=ListPlot[roc,Joined->True,PlotRange->{{0,1},{0,1}},PlotStyle->style1]];
     If[model==2, plot2=ListPlot[roc,Joined->True,PlotRange->{{0,1},{0,1}},PlotStyle->style2]];
   (*OBSERVED ESTIMATE add points*)
      plot1=ListPlot[roc,PlotStyle -> {RGBColor[0,0,0],PointSize[.02]}];
     res1={plot0,plot1,plot2,text1,text2,rect1,rect2,textauc};
 (*final plot*)
       range={{-.01,1.01},{-.01,1.01}}; 
    If[format=="manu",
         plotx=Show[res1, PlotRange->range,Axes->None,Frame->True]];
      If[format=="talk",
         plotx=Show[res1, PlotRange->range,Axes->None,FrameTicks->None,Frame->True,
             BaseStyle->{Large,Bold},FrameLabel->{"FPR","TPR",None,None}]];       
Return[{plotx,auc}]]



AUC[roc_]:=
Module[{fprvec,trpvec,tmvec,auc},
     (*fpr and tpr*)
     {fprvec,tprvec}=Transpose[roc];
    (*sum dif fpr x mean tpr*)
     wvec=dif[#]& /@ Partition[fprvec,2,1];
     tmvec=Mean[#]& /@ Partition[tprvec,2,1];
     auc=Apply[Plus, wvec tmvec]; 
 Return[auc]]


  dif[{a_,b_}]:= b-a



  
   

(*----------------------------------PlotRiskMap--------------------------*)




PlotRiskMap[dataM_,P_,riskvecPLOT_,format_,riskscorevec1_,riskscorevec2_,{rCONCvec1_,skipvec1_,modelname1_},
                          {rCONCvec2_,skipvec2_,modelname2_},datasetname_,showmap_]:=
Module[{plotmap1,plotmap2,plotmap,points1,points2},
{plotmap1,points1}=PlotRiskMapCore[dataM,P,Red,riskvecPLOT,format,riskscorevec1,rCONCvec1,skipvec1,modelname1,datasetname,1,showmap];
{plotmap2,points2}=PlotRiskMapCore[dataM,P,Blue,riskvecPLOT,format,riskscorevec2,rCONCvec2,skipvec2,modelname2,datasetname,2,showmap];
plotmap={plotmap1,plotmap2,points1,points2};
Return[plotmap]]


PlotRiskMapCore[dataM_,P_,color_,riskvecPLOT_,format_,riskscorevec_,rCONCvec_,skipvec_,modelname_,datasetname_,model_,showmap_]:=
Module[{mat,res,plotmap,plotset,plotvec,topname,riskscorevecSKIP,min,max,fracRU,  xP,x,  xmin,xmax,xdif,  
   rM1,x1,n1,rM2,x2,n2,name1,name2,name,R1,P1,roc1,ru1,skipvec1,r1,slope1,slopemat1},
(*riskvec*)
     {rM1,x1,n1,rM2,x2,n2,name1,name2,name}=dataM;
     {R1,P1,roc1,ru1,skipvec1,r1,slope1,slopemat1}=RUConcave[rM1,n1,P];
  (*for vertical line*)
  riskscorevecSKIP=AdjustRisk[riskscorevec,#]& /@ skipvec;
    points=Transpose[{riskscorevecSKIP,rCONCvec}];
   min=Min@Flatten[points];
   max=Max@Flatten[points];
    pointset=GenPoint[#]& /@ points;
 (*LINES for BOUNDS ON ESTIMATED RISK*)
  yTOP=Max[rCONCvec];
  yBOT=Min[rCONCvec];  
  xTOP=Max[riskscorevecSKIP];
  xBOT=Min[riskscorevecSKIP];
    xdif=xTOP-xBOT;
  xmin=xBOT-.1 xdif;
  xmax=xTOP+ .1 xdif;
    ydif=yTOP-yBOT;
    ymin=yBOT- ydif;
    ymax=yTOP+ ydif;
    dash=Dashing[{.01,.01}];
  range={{xmin,xmax},{ymin,ymax}};  
(*PLOT*) 
    If[format=="talk",fontsize=18];
     If[format=="manu",fontsize=Medium];
     plotvec=ListPlot[points,Joined->True,PlotStyle-> {Black,Thickness[.01]}];
     topname=StringJoin["Risk-From-Score Plot: ",modelname];
     If[format=="manu", res={plotvec,pointset}];
     If[format=="talk", res={plotvec,pointset,diag}];     
   plotmap=Show[res,AspectRatio->1,Frame->True,
       Axes->None,  PlotRange->range,
     BaseStyle -> {fontsize, Black, Bold, FontFamily -> "Times"},
     FrameLabel->{"score","estimated risk",topname,None}];
 Return[{plotmap,points}]]




GenPoint[pair_]:=Graphics@{PointSize[Medium],Point[pair]}

AdjustRisk[riskscorevec_,skip_]:=
Module[{riskscore},
riskscore=Mean@riskscorevec[[skip]];
Return[riskscore]]



(*--------------------------------------Plot Decision Rule-------------------------------------------*)



PlotDecisionRule[riskvecPLOT_,format_,rCONCvec1_,rCONCvec2_]:=
Module[{plot1,plot2},
plot1=PlotDecisionRuleOne[riskvecPLOT,1,format,rCONCvec1];
plot2=PlotDecisionRuleOne[riskvecPLOT,2,format,rCONCvec2];
Return[{plot1,plot2}]]


PlotDecisionRuleOne[riskvecPLOT_,model_,format_,rCONCvec_]:=
Module[{riskA1,riskN1,riskA2,riskN2,riskP,fracRU,yA,yN,yTOP,yBOT,colorA,colorN, label,plot,plotx,v,e,pN,pA,pNX,pAX},
(*risks*)
 {riskA1,riskN1,riskA2,riskN2,riskP,fracRU}=riskvecPLOT;
  {rL1,rR1,rL2,rR2,rP,fracRU}=riskvecPLOT;
     rR=Max[rR1,rR2];
           rL=Min[rL1,rL2];
        xdif=rR-rL;
         xmax=rR  + .1 xdif;
         xmin=rL-.1 xdif;
If[model==1, yA=riskA1; yN=riskN1;modname="Model 1"];
 If[model==2, yA=riskA2; yN=riskN2;modname="Model 2"];
   vA=Graphics@Line[{{yA,xmin},{yA, yA}}];
   vN=Graphics@Line[{{yN,yN},{yN,xmax}}];
   diag=Graphics@Line[{{yA,yA},{yN,yN}}];
  yTOP=Max[rCONCvec];
  yBOT=Min[rCONCvec];
  dash=Dashing[{.01,.01}];
  hTOP=Graphics@{Black,dash,Line[{{0,yTOP},{1,yTOP}}]};
  hP=Graphics@{Black,Line[{{xmin,P},{P,P}}]};
  vP=Graphics@{Black,Line[{{P,xmin},{P,P}}]};
    hBOT=Graphics@{Black,dash,Line[{{0,yBOT},{1,yBOT}}]};
  (*Position label*) 
    xmid=(xmax+xmin)/2;
  v=xmid;
  hA= xmin+ xdif .2;
  hN= xmin+ xdif .85;
  (*text*)
       textN=Graphics@TextX["treat\nnone",{hN, v},{0,0},format];   
       textA=Graphics@TextX["treat\nall",   {hA, v},{0,0},format];   
 (*polygon*)
  e=.01 (xmax-xmin);
   pA=Polygon[{{xmin,xmin},{xmin, xmax},{yN-e, xmax},{yN-e,yN}, {yA-e,yA},{yA-e,xmin},{xmin,xmin}}];
   pN=Polygon[{{yA+3e,xmin},{yA+3e,yA},{yN+3e,yN}, {yN+3e,xmax},{xmax,xmax},{xmax,xmin}}];
   colorA=Lighter[Green];
   colorN=Lighter[Brown];
   pAX=Graphics[{EdgeForm[Directive[Thickness[.05], colorA]], White, pA}];
   pNX=Graphics[{EdgeForm[Directive[Thickness[.05], Dashed,colorN]], White, pN}];
 (*plot*)   
    If[format=="talk",fontsize=18];
       If[format=="manu",fontsize=Medium];
   label=StringJoin["Decision Rule: ",modname];
   plot=ListPlot[{{yA,yA},{yN,yN}},PlotRange->{{xmin,xmax},{xmin,xmax}}];
   plotx=Show[plot,vA,vN,diag,plot,pAX,pNX,textA,textN,(*hP,vP*)
     AspectRatio->1,Frame->True,
       BaseStyle -> {fontsize,Black,Bold,FontFamily -> "Times"},
   FrameLabel->{"risk threshold T" ,"estimated risk",label,None}];
   Return[plotx]]
   
   
     
    
     
     
     
  (*General Suppport*)


TextX[name_,pos_,offset_,format_:"manu"]:=
Module[{res},
If[format=="manu",res=Text[Style[name,Medium],pos,offset]];
If[format=="talk",res=Text[Style[name,15],pos,offset]];
Return[res]]


RoundX[x_]:=
Module[{res},
If[x>=1, res=Round[x]];
If[x<1, res= Round[x 10]/10//N];
Return[res]]


  
  
End[] 
EndPackage[]


	 