(*Mathematica:: Verizon 7.0      *)
(*:Context:: "rufit`"        *)
(*:Title::  relative utility  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2016 Stuart G. Baker *)
  (*Input functions: 
  	      RUConcave    			 rufitcore.m
              GenMargin	 		      rufitcore.m
              ROCCheck			       rufitcore.m
              PlotRiskMap		          rufitplot.m
   	      PlotROCRUOriginal 		 rufitplot.m 
   	      PlotROCRUConcave         rufitplot.m 
   	      TestTradeoff		rufitrange.m
   	      TableData			rufitreport.m
   	      TableEstimate		rufitreport.m*)
   	      
BeginPackage["rufitkey`", "rufitdata`","rufitcore`", "rufitplot`","rufitreport`","rufitrange`"]  

RUTableFitKey::usage="RUTableFitKey[dataF core0,corex]"



Clear[RUTableFitKey]
					
Begin["Private`"]	  
    
 RUTableFitKey[dataF_,core0_,corex_,plotpdf_]:=
 Module[{ xmat,ymat,rmat,nmat,riskscore,riskscorename,
     modelname1,modelname2,markername,datasetname,corenew,showcalibration,format,
        r1,n1,r2,n2,i,type,core,pointsize,
        nri, w2,P,Pr},
 

 (*Data report*) 
      {xmat,ymat,riskscorevec1,riskscorevec2,riskscorename1,riskscorename2,modelname1,modelname2,
        markername,datasetname,datatype}=dataF;    
  (*Margin*)
      {r1,x1,n1,r2,x2,n2}=GenMargin[xmat,ymat];
 (*USER OPTIONS*)
      {P0,format,showplot}=core0;
 (*PREVALENCE in population: use Model 2 if not automatic!!*)
       If[P0===Automatic, 
        w2=n2/Apply[Plus,n2]//N; 
        P=Apply[Plus,r2 w2],
        (*else*)
          P=P0];    
   (*NON-USER OPTIONS*)
         {showdataQ,showestQ,pointsize,showzone,showmap,fracmaxRU}=corex;
   (*UPDATE OPTIONS*)    
       core={P,showdataQ,showestQ,fracmaxRU,showzone,pointsize,format,showmap};
  
  
  (*PRINT*)
     Pr=Round[P 1000]/1000//N;
     Print["  P=pr(event) = ",Pr];
   
   (*
   (*OVERLAP PLOT*)
     If[datatype=="list" && showplot=="All",
       Print["Overlap of distributions"];
        Print[plotpdf]];
   *)
   
(*SHOW DATA*)
   If[showdataQ,TableData[dataF]];
   
   
   
(*MARGINAL DATA*)
  dataM={r1,x1,n1,r2,x2,n2,modelname1,modelname2,markername};
(*Plot if valid ROC*)
 {auc1,auc2,plotroc}=ROCCheck[dataM,P,showestQ];
  If[auc1>=.5 && auc2 >=.5,
   RUTableFitCore[dataM,datatype,modelname1,modelname2,riskscorename1,riskscorename2,datasetname,core,showplot],
   Print["Warning: ROC curve below diagonal "];
   Print[plotroc]];
Return[Null]]



RUTableFitCore[dataM_,datatype_,modelname1_,modelname2_,
         riskscorename1_,riskscorename2_,datasetname_,core_,showplot_]:=
 Module[{ druCONCAVEvec,ruCONCAVEvec1,plotCONCAVEpair,
          rCONCAVEvec1,rCONCAVEvec2,   slopemat1,slopemat2, skipvec1,skipvec2, plotORIGroc,
          skipvec1s,skipvec2s,nametab1,nametab2,
              plotTTdiff,plotMHdif,plotTTchance,plotMHchance,
              plotTTpair,plotTT,plotMHpair,plotMH,plotALL},
   
   (*OPTIONS*)  
     {P,showdataQ,showestQ,fracmaxRU,showzone,pointsize,format,showmap}=core;           
     
(*RISK THRESHOLD RANGE*)	
      riskvecPLOT=GenTargetRiskVecPlot[dataM,P,format,fracmaxRU,showmap];
  
  
  (*PRELIMINARY ROC CURVE*)
     {plotORIGpair,rORIGvec1,rORIGvec2, plotORIGroc,plotORIGru,plotORIGru1,plotORIGru2,plotORIGruAUCmtt}= 
          PlotROCRUOriginal[dataM,P,format,riskvecPLOT,showzone,pointsize,datatype];         
          
  (*CONCAVE ROC CURVE*)
       {auc1,auc2,maxru1,maxru2,plotCONCAVEpair, rCONCAVEvec1,rCONCAVEvec2,skipvec1,skipvec2,slopemat1,slopemat2,
        plotCONCAVEroc,plotCONCAVEru,plotCONCAVEru1,plotCONCAVEru2,plotCONCAVEruAUCmtt}=
          PlotROCRUConcave[dataM,P,format,riskvecPLOT,showzone,pointsize,datatype];
       skipvec1s=Sort[#]& /@ skipvec1;
       skipvec2s=Sort[#]& /@ skipvec2;
       If[showestQ,
       Print["FINAL NUMBER OF INTERVALS IN  MODEL 1  =  ",Length[skipvec1]];
       Print["FINAL NUMBER OF INTERVALS IN  MODEL 2  = ",Length[skipvec2]]];
       
     
       
      (*PLOT PRELIMINARY AND CONCAVE ROC CURVES*) 
        If[showplot=="All" || showplot=="Talk",
           plotROCvec={plotORIGpair[[1]],plotCONCAVEpair[[1]]};
          plotpairROC= Show[GraphicsRow[plotROCvec],ImageSize->Large];
          Print["Preliminary and concave ROC curves"];
       	ExportPlot["figROCBOTH",datasetname,plotpairROC,format]];  
       
       (*PLOT CURVE ROC NEXT TO RU CURVE*)
         If[showplot=="All" || showplot=="Standard" || showplot=="Basic" || showplot=="Talk",
         If[datatype=="table",  Print["ROC and RU curves"]];
          If[datatype=="list",     Print["ROC and RU curves (with imputed maximum RU)"]];
          plotpairROCRU=Show[GraphicsRow[plotCONCAVEpair],ImageSize->Large];
         ExportPlot["figROCRU",datasetname,plotpairROCRU,format]];
       
     
       
    (*
  (*PLOT ROC and RU SEPARATELY FOR TALK*)
   If[showplot=="Talk",  
        ExportPlot["figROCconc",datasetname,plotCONCAVEroc,format]; 
      ExportPlot["figRU",datasetname,plotCONCAVEru,format]];
*)
 
  

  (*PLOT DECISION RULE*)
      If[datatype=="list" && showplot=="All",
       {plotDR1,plotDR2}=PlotDecisionRule[riskvecPLOT,format,rCONCAVEvec1,rCONCAVEvec2];
      plotDR=Show[GraphicsRow[{plotDR1, plotDR2}],ImageSize->Large];
           Print[" Decision-Making Plots"];
      ExportPlot["figset2",datasetname,plotDR,format]];
	 
	
      (*PLOT RISK SCORE*)
          If[datatype=="list" && showplot=="All",
          {plotMAP1,plotMAP2,points1,points2}=PlotRiskMap[dataM,P,riskvecPLOT, format,riskscorevec1,riskscorevec2,{rCONCAVEvec1,skipvec1,modelname1},
                                     {rCONCAVEvec2,skipvec2,modelname2},datasetname,showmap];
             plotMAP=Show[GraphicsRow[{plotMAP1, plotMAP2}],ImageSize->Large];
           Print["Risk-Score Plots"];
           ExportPlot["figset1",datasetname,plotMAP,format];
           RiskScoreFitX[points1,"Model 1"];
	RiskScoreFitX[points2,"Model 2"]];
  
    (*PLOT TEST TRADEOFF*)
         If[(showplot=="All" || showplot=="Standard"),
     {plotpairRU,plotpairTT,minTT}=TestTradeoff[dataM,P,format,riskvecPLOT,datatype,showmap];
       	 Print["RU Difference and Test Tradeoff for difference  (truncated at upper bound)"];
       	 Print["Caution: Test tradeoff may not be valid for crossing ROC curves"];
       	 ReportMTT[auc1,auc2,minTT,maxru1,maxru2,P];
     	 ReportNetBenefit[auc1,auc2,minTT,maxru1,maxru2,P];
       ExportPlot["figTTpair",datasetname,plotpairTT,format]];
  
  
    (*ESTIMATION TABLE*)
           If[showestQ,
           Print[" Intervals (right to left): concave ROC curve Model 1 ",skipvec1s];
           Print[" Intervals (right to left): concave ROC curve Model 2  ",skipvec2s];
       TableEstimate[dataM,P,slopemat1,slopemat2,riskscorevec1,riskscorevec2,riskscorename1,riskscorename2]];
       
Return[Null]]


 ReportMTT[auc1_,auc2_,minTT_,maxru1_,maxru2_,P_]:=
  Module[{mtt1,mtt2,mtt12,AUCmtt1,AUCmtt2,AUCmtt12,P1,P2}, 
      AUCmtt1=Round[1/ (P hAUC[auc1])];
      AUCmtt2=Round[1/ (P hAUC[auc2])];
      AUCmtt12=Round[1/ (P( hAUC[auc2]-hAUC[auc1]))];
      mtt12=Round[1/ (P (maxru2-maxru1))];
      mtt1=Round[1/ (P maxru1)];
      mtt2=Round[1/ (P maxru2)];
      Print["AUC appproximation = 1/(P h(AUC)  and 1 /(P (h(AUC2)-h(AUC1))"];
      Print["  Minimum test tradeoff: Model 1 versus Chance  (exact,  AUC approximation) = ",{mtt1,AUCmtt1}];
      Print["  Minimum test tradeoff:  Model 2 versus Chance  (exact, AUC approximation) = ",{mtt2,AUCmtt2}];
       Print["  Minimum test tradeoff:  Model 2 versus Model 1 (exact, AUC approximation) =  ",{mtt12,AUCmtt12}]; 
Return[Null]]



 ReportNetBenefit[auc1_,auc2_,minTT_,maxru1_,maxru2_,P_]:=
  Module[{nb1,nb2,nb12,AUCnb1,AUCnb2,AUCnb12,P1,P2}, 
      AUCnb1=RoundX[(P hAUC[auc1])];
      AUCnb2=RoundX[ (P hAUC[auc2])];
      AUCnb12=RoundX[(P( hAUC[auc2]-hAUC[auc1]))];
      nb12=RoundX[(P (maxru2-maxru1))];
      nb1=RoundX[(P maxru1)];
      nb2=RoundX[(P maxru2)];
      Print["AUC1 ",auc1];
      Print["AUC2 ", auc2];
      Print["  1/MTT:  Model 1 versus Chance  (exact,  AUC approximation) = ",{nb1,AUCnb1}];
      Print["  1/MTT:  Model 2 versus Chance  (exact, AUC approximation) = ",{nb2,AUCnb2}];
       Print[" 1/MTT:  Model 2 versus Model 1 (exact, AUC approximation) =  ",{nb12,AUCnb12}]; 
Return[Null]]

RoundX[x_]:=Round[x 1000]/1000//N
   
  hAUC[AUC_]:=AUC- Sqrt[(1-AUC)/2];
    
RiskScoreFitX[points_,modelname_]:=
Module[{line,a,as,b,bs,x},
  line = Fit[points, {1, x}, x];
   a=line[[1]];
   as=ToString[a];
   b=line[[2,1]];
   bs=ToString[b];
 Print @StringJoin["  Risk-From-Score Fit for ",modelname,":  ",as," + ",bs," score"];
Return[Null]]

       
 (*-----Generate Lower and Upper  Risk Thresholds Based on Target RU----------*)

GenTargetRiskVecPlot[dataM_,P_,format_,fracmaxRU_,showmap_:False]:=
  Module[{rM1,x1,n1,rM2,x2,n2,riskvec,modelname1,modelname2,namefit,
               R1,P1,roc1,ru1,skipvec1,r1,slope1,slopemat1,
               R2,P2,roc2,ru2,skipvec2,r2,slope2,slopemat2,
               P1data,P2data,
               RTarget1,RTarget2,RTarget,maxr,Pmin,int,maxru1,maxru2,maxru,fracRU0},
     (*input*)
       {rM1,x1,n1,rM2,x2,n2,modelname1,modelname2,namefit}=dataM;
   (*compute risk vec*)
     {R1,P1,roc1,ru1,skipvec1,r1,slope1,slopemat1}=RUConcave[rM1,n1,P];
     {R2,P2,roc2,ru2,skipvec2,r2,slope2,slopemat2}=RUConcave[rM2,n2,P];
     maxru1=Max[ru1];
      maxru2=Max[ru2];
      maxru=Min[maxru1,maxru2];
      fracRU0=fracmaxRU maxru;
     If[showmap, 
     Print["fraction RU target ",fracRU0]];
     If[showmap, Print[" "]; Print["MODEL OLD"]];
      RTarget1L=InterpolateZ[R1,ru1,fracRU0,"left",P1,showmap];
      RTarget1R=InterpolateZ[R1,ru1,fracRU0,"right",P1,showmap];   
     If[showmap, Print["  "];  Print["MODEL NEW"]];
        RTarget2L=InterpolateZ[R2,ru2,fracRU0,"left",P2,showmap];
         RTarget2R=InterpolateZ[R2,ru2,fracRU0,"right",P2,showmap];
     If[showmap, Print["  "]];
      res={RTarget1L,RTarget1R,RTarget2L,RTarget2R,P,fracRU0};
         Return[res]]
    



InterpolateZ[rvec_,ruvec_,rutarget_,relreg_,P_,showmap_:False]:=
Module[{pair1,pair1x,pair2,pair2x,ru1i,ru2i,dru,hvec,hvecx,pair,show,res,nett},
      pair=Transpose[{rvec,ruvec}];
      If[showmap,     Print["REGION ",relreg]];
        If[showmap,     Print["   RU target ",rutarget]];
      If[relreg=="left", 
         pairvecL0={{0.0,0.0}} ~Join~  Select[pair,(#[[1]]<P)&];
         pairvecL=RemoveRepeatsL[pairvecL0,showmap];
        rtarget= intoneXL[pairvecL,rutarget,showmap]];
      If[relreg=="right",
           pairvecR0=Select[pair,(#[[1]]>=P)&] ~Join~ {{1.0,0.0}};
          pairvecR=RemoveRepeatsR[pairvecR0,showmap];
           rtarget= intoneXR[pairvecR,rutarget,showmap]];
  Return[rtarget]]

RemoveRepeatsL[pairvec_,showmap_]:=
Module[{rvec,ruvec,ruvec0,len0,pairvecX},
 {rvec,ruvec}=Transpose[pairvec];
  ruvec0=Select[ruvec,(#<=.001)&];
  len0=Length[ruvec0]-1;
  If[showmap==True, Print["   remove Left ",len0]];
  pairvecX=Drop[pairvec,len0];
Return[pairvecX]]

RemoveRepeatsR[pairvec_,showmap_]:=
Module[{rvec,ruvec,ruvec0,len0,pairvecX},
 {rvec,ruvec}=Transpose[pairvec];
  ruvec0=Select[ruvec,(#<=.001)&];
  len0=Length[ruvec0]-1;
  If[showmap==True, Print["   remove Right ",len0]];
  pairvecX=Drop[pairvec,-len0];
Return[pairvecX]]



intoneXL[pairvec_,rutarget_,showmap_:False]:=
Module[{numtot,num,xL,yL,xU,yU,rtarget,len}, 
  numtot=Length[pairvec];
  num=Length@Select[pairvec,(#[[2]]<rutarget)&];
 If[showmap,
  lenshow=Min[Length[pairvec],2];
  Print["    pairvec left side ",Take[pairvec,lenshow]];
  Print["    numtotal= ",numtot];
  Print["    number selected= ",num]];
 (*larger to the right*)
  If[num>1 && num==numtot, 
       (*slope is previous extrapolate to right*)
        {xL,yL}=pairvec[[num-1]];
        {xU,yU}=pairvec[[num]];
        rtarget=SlopeAdjust[{xL,yL,xU,yU},rutarget,showmap]];
   If[num>=1 && num<numtot, 
      (*slope surrogates rutarget for interpolation*)
       {xL,yL}=pairvec[[num]];
       {xU,yU}=pairvec[[num+1]];
       rtarget=SlopeAdjust[{xL,yL,xU,yU},rutarget,showmap]];
  If[num==1 && numtot==1, 
     rtarget=pairvec[[1,1]]];
 If[num==0, rtarget=0];
  If[showmap, Print["    rtarget Left ", rtarget]];
 Return[rtarget]]



intoneXR[pairvec_,rutarget_,showmap_]:=
Module[{numtot,num,xL,yL,xU,yU,rtarget,lenshow}, 
   numtot=Length[pairvec];
   num=Length@Select[pairvec,(#[[2]]>rutarget)&];
   If[showmap,
    lenshow=Min[Length[pairvec],2];
     Print["    pairvec right side ",Take[pairvec,-lenshow]];
     Print["    numtotal= ",numtot];
    Print["    number selected= ",num]];
    (*larger to the left*)
    If[num>1 && num==numtot, 
          (*slope is previous extrapolate to left*)
           {xL,yL}=pairvec[[2]];
           {xU,yU}=pairvec[[1]];
          rtarget=SlopeAdjust[{xL,yL,xU,yU},rutarget,showmap]];
   If[num>=1 && num<numtot, 
    (*slope surrogates rutarget for interpolation*)
     {xL,yL}=pairvec[[num+1]];
     {xU,yU}=pairvec[[num]];
     rtarget=SlopeAdjust[{xL,yL,xU,yU},rutarget,showmap]];
  If[num==1 && numtot==1, 
     rtarget=pairvec[[1,1]]];
    If[num==0,  rtarget=1];
   If[showmap, Print["    rtarget Right ", rtarget]];
  Return[rtarget]]



   SlopeAdjust[{xL_,yL_,xU_,yU_},rutarget_,showmap_:False]:=
   Module[{slope,res},
    If[yU>yL,
       slope= ((xU-xL)/(yU-yL));
       If[showmap,
       Print["   xL yL ", {xL,yL}];
       Print["   xU yU ", {xU,yU}]];
        rtarget=xL + slope (rutarget-yL),
       Print["RU vertical line"];
      rtarget=xU];
Return[rtarget]]





(*-----export------------------------------------------------------*)    
    
ExportPlot[figname_,datasetname_,plot0_,format_:"manu"]:=
	  Module[{plotnamejpg,plot},
	  If[format=="talk",
	  plot=Show[plot0,ImageSize->Large], plot=plot0];
	 
	
         plotnameeps=StringJoin["figrufit",datasetname,figname,".eps"];    
	 	    	       Export[plotnameeps,plot]; 
	 	               Print["    exporting ",plotnameeps];
	 	                Print[plot];
	 	              (*
	  plotnamejpg=StringJoin["figrufit",datasetname,figname,".jpg"];    
	 	    	       Export[plotnamejpg,plot]; 
	 	              Print["    exporting ",plotnamejpg]; 	              
	 	              *)
	 Return[Null]]


  
End[] 
EndPackage[]

