(*Mathematica:: Verizon 7.0      *)
(*:Context:: "rufit`"        *)
(*:Title::  relative utility fits  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2013 Stuart G. Baker *)

BeginPackage["rufitcore`"]  

RUConcave::usage="RUConcave[r,n,P,show]"
RUOriginal::usage="RUCOriginalr,n,P,show]"
AUCFromROC::usage="AUCFromROC[roc]"
NRI::usage="NRI[xmat,ymat]"
GenMargin::usage="GenMargin[xmat,ymat]"
GenROCFromRW::usage="GenROCFromRW[r,w]"
ROCCheck::usage="ROCCheck[dataM,P]"

Clear[RUConcave,RUOriginal,AUCFromROC,NRI,GenMargin,GenROCFromRW,ROCCheck];
					
Begin["Private`"]	  

 RUOriginal[r_,n_,P_,show_:False]:=
   Module[{w,p,roc,roc0,skipvec0,R,fpr,tpr,fprx0,tprx0,res,pairru},
         w=n/Apply[Plus,n]//N; 
          p= Apply[Plus,r w];
         roc=GenROCFromRW[r,w];
	 R= r (P / p) / (r P / p + (1-r) (1-P)/(1-p));
         {slope,ru}= RUfromROC[roc,r,p];
         res={R,P,roc,ru,r,slope};
      Return[res]]
  
  
  RUConcave[r_,n_,P_,show_:False]:=
 Module[{w,p,roc,rocCONC,skipvec, rCONC,RCONC,ruCONC,pairruCONC, 
       fprCONC,tprCONC,slopeCONC,res},
          (*preliminaries*)
              w=n/Apply[Plus,n]//N; 
             p= Apply[Plus,r w];
             roc=GenROCFromRW[r,w];
         (*create concave roc curve*)
            {rocCONC,skipvec,rCONC,ruCONC,slopeCONC,slopematCONC}=ConcaveROC[roc,p,show];
         (*adjust for popluation values of prevalence*) 
            RCONC= rCONC (P / p) / (rCONC P / p + (1-rCONC) (1-P)/(1-p));
            {fprCONC,tprCONC}=Transpose[rocCONC];
       res={RCONC,P,rocCONC,ruCONC,skipvec,rCONC,slopeCONC,slopematCONC};
      Return[res]]
  
    
  
  
  GenROCFromRW[r_,w_]:=
  Module[{tprnnum,tprden,tprx,fprnum,fprden,fprx,tprz,fprz,roc},
       (*TPR: reversal:   tpr1 = r3 w3 / p and tpr2=  (r2 w2 + r3 w3)/p *) 
             tprnum=Drop[FoldList[Plus,0,Reverse[r w]],1];
              tprden=Apply[Plus,r w];
              tprx=tprnum/tprden;
       (*FPR*)
             fprnum=Drop[FoldList[Plus,0,Reverse[(1-r)w]],1];
             fprden=Apply[Plus,(1-r) w];
             fprx=fprnum/fprden;
      (*ROC*)
      	  tprz=Join[{0},tprx];
    	  fprz=Join[{0},fprx];
            roc=Transpose[{fprz,tprz}];
  Return[roc]];
  
(*CHECK ORIGINAL ROC*)

ROCCheck[dataM_,P_,showestQ_]:=
Module[{rM1,x1,n1,rM2,x2,n2,name1,name2,name,rocname,runame,
             r1,P1,roc1,pairru1,ru1,pairnb1,nb1,pairnx1,skipvec1,slopemat1,
             r2,P2,roc2,pairru2,ru2,pairnb2,nb2,pairnx2,skipvec2,slopemat2,res,
             roclist1,roclist2,
             plotpoints1,plotpoints2},
   (*input*)
     {rM1,x1,n1,rM2,x2,n2,name1,name2,name}=dataM;
       {R1,P1,roc1,ru1,r1,slope1}=RUOriginal[rM1,n1,P];
        {R2,P2,roc2,ru2,r2,slope2}=RUOriginal[rM2,n2,P];
       plotroc1=ListPlot[roc1,Joined->True];
       plotroc2=ListPlot[roc2,Joined->True];
       plotroc=Show[plotroc1,plotroc2,Frame->True,AspectRatio->1];
      auc1=AUCFromROC[roc1];
       auc2=AUCFromROC[roc2];
       res={auc1,auc2,plotroc};
    (*Length check after union*)   
       roclist1=Union@round[Join[{{0,0}},roc1,{{1,1}}]];
       roclist2=Union@round[Join[{{0,0}},roc2,{{1,1}}]];
       If[showestQ,
       Print["ROC CURVE"];
       Print[" after joining ROC points that are identrical or almost identical"];
       Print[" preliminary ROC curve Model 1: number of intervals ", Length[roclist1]-1];
       Print[" preliminary ROC curve Model 2: number of intervals: ", Length[roclist2]-1]];         
   Return[res]];


(*------------------------CONCAVE ROC------------------------------------------*)

ConcaveROC[roclist0_,p_,show_]:= 
Module[{set,listnew,listnew1,roc,roctemp,pair,test,slope,roc1,test1,len,range,
roclistST,posST,skipvecST,riskCONCST,slopevecST,slopematST,lenST,i,
             skipvec,skipvec0,posvec,uniqueslope,ruvec0,ruvecCONC,slopevec0,slopevecCONC},
  (*no ties in ROC curve*)
       roclist=Union@round[Join[{{0,0}},roclist0,{{1,1}}]];
  (*starting values*)     
        roclistST={{0,0}};
        posST=1;
        skipvecST={0};
        riskCONCST={0};
        ruvecST={0};
        slopevecST={0};
        lenST=Length[roclist]-1;
        slopematST={Table[" ",{i,1,lenST}]};
        vecST={roclistST,posST,skipvecST,riskCONCST,ruvecST,slopevecST,slopematST};  
  (*continue selecting points with highest slope until the penultimate point*)
         {roclistCONC,posMAX,skipvec0,riskvecCONC0,ruvec0,slopevec0,slopemat0}=
           NestWhile[PickNextSlope[roclist,p, #] &, vecST, (#[[2]] < Length[roclist]) &] ;
           
       
       
  (*Drop initial values: then reverse so lowest to highest risk--then change ordering*)
         skipvec=Length[roclist] - (Reverse@Drop[skipvec0,1]);
    (*Drop (0,0) and reverse order because number is reversed*)
        riskvecCONC=Reverse@Drop[riskvecCONC0,1];
        ruvecCONC=Reverse[Flatten@Drop[ruvec0,1]];
           slopevecCONC=Reverse[Flatten@Drop[slopevec0,1]];
       slopematCONC=Reverse@Drop[slopemat0,1];
  Return[{roclistCONC,skipvec,riskvecCONC,ruvecCONC,slopevecCONC,slopematCONC}]]

round[x_]:=Round[x 10000]/10000//N

PickNextSlope[roclist_,p_,{roclistsofar_,possofar_,skipold_,riskCONC_,ruvecold_,slopevecold_,slopematold_}]:=
Module[{fprST,tprST, remlist,fprREM,tprREM,slopepairlist,  slopeREM,range,posREM,setREM,maxsetREM,
           slopenew,posnew,fprnew,tprnew,q,
           skipnew,posset,skipvecnew,x,risknew,riskCONCnew,
           slopeREMr, len,i, addzero,slopeREMadd,slopematnew,
           roclistnew},
 (*starting point on roc list*)
	 {fprST,tprST}=roclist[[possofar]];
 (*remainder of the roc list*)
         {fprREM,tprREM}=Transpose@Drop[roclist,possofar];
  (*compute pair from starting value of remainder of roc list*)
     	 slopepairlist=Transpose[{(tprREM-tprST),(fprREM-fprST)}];  
  (*compute slope from starting value of pairs from roc list*)
  	 slopeREM=calcslope[slopepairlist];
  (*compute remaining points*)
         range=Range@Length[roclist];
         posREM=Drop[range,possofar];
  (*find new point with maximum slope*)      
         setREM=Transpose[{slopeREM,posREM,fprREM,tprREM}];
         maxsetREM=(Sort[setREM])[[-1]];
         {slopenew,posnew,fprnew,tprnew}=maxsetREM;   
  (*UPDATE SKIPVEC*)
         skipnew=Position[slopeREM,slopenew][[1,1]];
         posset=Range[skipnew]+(Flatten[skipold])[[-1]];
         skipvecnew =Join[skipold, {posset} ];
   (*UPDATE CONCAVE RISK*)
         q=slopenew p /(1-p);
         risknew= q/(1+q);
         riskCONCnew=Join[riskCONC,{risknew}];
     (*UPDATE ROC CURVE*)    
          roclistnew=Append[roclistsofar,{fprnew,tprnew}];
     (*UPDATE RU*)
        If[risknew>=p, 
        runew=tprnew-slopenew fprnew,
        (*ADJUST FOR ZERO SLOPE*)
        runew=(1-fprnew)- (1-tprnew)/Max[slopenew,.001]];
      ruvecnew=Append[ruvecold,{runew}];
      (*UPDATE SLOPE*)
          slopeCONCnew=Append[slopevecold,slopenew];
      (*UPDATE SLOPE MAT for remainder*)
          len=Length[roclist];
          addzero=Table[" ",{i,1,len-Length[slopeREM]-1}];
          slopeREMr=Round[slopeREM 100]/100//N;
          slopeREMadd=slopeREMr ~Join~ addzero;
          slopematnew=Append[slopematold,slopeREMadd];
    Return[{roclistnew,posnew,skipvecnew,riskCONCnew,ruvecnew,slopeCONCnew,slopematnew}]]


calcslope[list_]:=calcslopei[#]& /@ list			
calcslopei[{num_,den_}]:= If[den==0,1000, num/den]; 


ZeroSign[x_]:=1-Abs[Sign[x]]
ReplaceZero[x_,new_:1]:=   x + ZeroSign[x] new   


RUfromROC[roc_,R0_,P_]:=
Module[{fpr0,tpr0,fprx,tprx,fpr,tpr,Rtemp, slope, ru,pairru},
    (*reverse order from ROC because risk is reversed*)
        (*FPR and TPR after first in reverse order*)
        {fpr0,tpr0}=Transpose[roc];
          fprx=Drop[fpr0,1];
           tprx=Drop[tpr0,1];
            fpr=Reverse[fprx];
   	    tpr=Reverse[tprx];   
   	(*Compute slope*)    
           Rtemp=Min[#,.9999]& /@ R0;
           R=Max[#,.0001]& /@ Rtemp;
	   slope =((1-P)/P)(R /(1-R));
	   lenL=Length@Select[R, (#<P)&];
	   lenR=Length@Select[R, (#>=P)&];
	   tprR=Take[tpr,-lenR];
	   fprR=Take[fpr,-lenR];
          slopeR=Take[slope,-lenR];
           tprL=Drop[tpr,-lenR];
	   fprL=Drop[fpr,-lenR];
          slopeL=Drop[slope,-lenR];
        (*relative utility*)
        If[lenR >0,        ruR=tprR- slopeR fprR, ruR={}];
        If[lenL>0,          ruL=(1-fprL) -(1-tprL)/slopeL,ruL={}];
        ru=Join[ruL,ruR];
       Return[{slope,ru}]]


 (*------------------------------------AUC---------------------------------*)
 
 AUCFromROC[roc_]:=
 Module[{rocvec,areavec,area},
 rocvec=Partition[roc,2,1];
 areavec=AUCx[#]& /@ rocvec;
 area=Plus@@areavec;
 Return[area]]
 
 AUCx[{{fpr0_,tpr0_},{fpr1_,tpr1_}}]:=(fpr1-fpr0)(tpr0 + tpr1)/2

(*--------------------------------------------NRI---------------------------------------------*)

NRI[mat0_,mat1_]:=
Module[{low0,upp0,low1,upp1,nri},
 upp0=SelectUpperDiagonalSum@mat0;
 low0=SelectUpperDiagonalSum@Transpose[mat0];
 upp1=SelectUpperDiagonalSum@mat1;
 low1=SelectUpperDiagonalSum@Transpose[mat1];
 nri=(upp1-low1)+ (low0-upp0);
Return[nri]]


SelectUpperDiagonalSum[matrix_List?MatrixQ]:=
  Module[{indices,list,mat,n},
   indices = Range @ Length[matrix];
   list=Flatten @ MapThread[Drop[#1,#2]&,{matrix,indices}]; 
   n=Apply[Plus,Flatten[matrix]];
    res=Apply[Plus,list]/n//N;
   Return[res]]

(*---------------------------GenMargin-----------------------------*)

GenMargin[xmat_,ymat_]:=
     Module[{nmat, r1,n1,r2,n2,n1x,n2x,res,x,r,w,n},
        (* total per cell*)
            nmat=xmat+ymat;
        (*sum of columns*)
              x1=Apply[Plus,Transpose[xmat]];
	      n1=Apply[Plus,Transpose[nmat]];
	      n1x=ReplaceZero[n1,.0001];
	      r1=x1/n1x//N;
	(*sum of rows*)
	      x2=Apply[Plus,xmat];
              n2=Apply[Plus,nmat];
              n2x=ReplaceZero[n2,.0001];
	      r2=x2/n2x//N;
        (*output*)
             res={r1,x1,n1,r2,x2,n2};
         Return[res]]         
    

ZeroSign[x_]:=1-Abs[Sign[x]]

ReplaceZero[x_,new_:1]:=   x + ZeroSign[x] new   




End[] 
EndPackage[]



