(*Mathematica:: Verizon 7.0      *)
(*:Context:: "rufit`"        *)
(*:Title::  relative utility  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2016 Stuart G. Baker *)

   	      
BeginPackage["rufitapprox`"]

ProofMTT::usage="Proof[MTT,x] proof plot"
DeriveMTT::usage="DeriveMTT[x]"
PlotMTT::usage="PlotMTT[x] compare with actual numbers"
CompMTT::usage="CompMTT[AUCold, AUCnew,P]"
BoundMTT::usage="BoundMTT"

CheckROC::usage="CheckROC"

Clear[PlotMTT,CompMTT, ProofMTT, DeriveMTT,BoundMTT,CheckROC]
					
Begin["Private`"]	  
  
  
  

CompMTT[P_,{AUCold_, AUCnew_}]:=
 Module[{res1,res2,res}, 
 name1="Model 1";
 name2="Model 2";
 name12="Model 12";
  CompMTTcore[P,{.5, AUCold},name1];
  CompMTTcore[P,{.5, AUCnew},name2];
  CompMTTcore[P,{AUCold,AUCnew},name12];
  Return[Null]]
  
  
  
CompMTTcore[P_,{AUCold_, AUCnew_},name_]:=
Module[{RUold,RUnew,MTT,RUoldr,RUnewr,MTTr,mtt,upper},
    RUold=Comph[AUCold];
    RUnew=Comph[AUCnew];
    MTT=1 /(P (RUnew-RUold));
    If[MTT>10000,     mtt=Round[MTT   /1000]   1000//N];
    If[MTT>1000 && MTT<=10000,     mtt=Round[MTT /100] 100//N];
    If[MTT>100 && MTT<=100,             mtt=Round[MTT   /10]10//N];
    If[MTT >10 && MTT<=100,             mtt=Round[MTT   /10]10//N];
    If[MTT <10,       mtt=Round[MTT ]];
      mttr=Round[mtt];
      Print[name,"  MTT= ",mttr];
 Return[Null]]

Comph[AUC_]:=AUC -  Sqrt[(1- AUC)/2];




(*--------------Plot MTT-------------------------*)

PlotMTT[x_,p_:.1]:=
Module[{set,avec,bvec,rocvec,namevec,len,range,drange},
  avec={1.1,2, 32,128};
  bvec={2, 64};
  vec=Outer[List,avec,bvec];
    vec1=Partition[Flatten[vec],2];
Print["probablity of event ", p];
set=CompMaxRU[#,x,p]& /@ vec1;
{rocvec,namevec}=Transpose[set];
len=Length[namevec];
range=Range[len];
drange=.004 range;
drangepair=Transpose[{drange,drange}];
dashvec=Dashing[#]& /@ drangepair;
colorvec=Take[{Red,Black,Green,Blue,Purple,Brown,Orange,Darker[Green], Darker[Red]},len];
pair=Transpose[{namevec,range}];
labelset=TextX[#,len]& /@ pair;
pairline=Transpose[{colorvec,range}];
lineset=LineX[#,len]& /@ pairline;
stylevec=Transpose[{colorvec,dashvec}];
plot=Plot[rocvec,{x,0,1}, PlotRange->{Automatic,{0,1}},PlotStyle->stylevec];
diag=Graphics@Line[{{0,0},{1,1}}];
nametop=Graphics@Text["exact approx", {.82,  .4},{1,0}];
plotx=plot=Show[plot,diag,labelset, lineset,nametop,
AspectRatio->1,AxesOrigin->{0,0},Axes->True, 
FrameTicks->{Automatic, Automatic, None, None},
PlotRange->{{0,1},{0,1}},Frame->True, FrameLabel->{"false positive rate","true positive rate"}];
ExportPlotX["Fig4",plotx];
Return[Null]]



TextX[{name_,pos_},len_]:=Graphics@Text[name,{.8, pos .35/len},{1,0}];

LineX[{color_,pos_},len_]:=
Module[{d,dash,res},
d= .004 pos;
dash=Dashing[{d,d}];
res=Graphics@{color,dash,Line[{{.84, .35 pos/len}, {.97, .35 pos/len}}]};
Return[res]]



CompMaxRU[{a_,b_},x_,p_:.1]:=
Module[{roc,ROCslope, ROCplot,AUC,pair,pairs,slopedif,c,maxRU,ratio,pairvec,parivecs,slicevec,w,plot0,vert,diag,plot},
(*ROC*)
   roc=ROC[x,a,b];
   ROCslope=D[roc,x];
(*AUC*)
   w=.01;
   slicevec=Table[roc w + ROCslope w^2 .5,{x,.02,.98,w}];
   AUC=Total[slicevec];
(*maxRU exact*)
   pairvec=Table[{Abs[ROCslope-1],x},{x,.02,.98,w}];
   pairvecs=Sort[pairvec, #1[[1]] < #2[[1]] &];
   {slopedif,c}=pairvecs[[1]];
  maxRUeqn=(roc-x)/.x->c;
(*maxRU approx*)
  maxRUmax= 2 AUC-1;
  maxRUmin= 1 - Sqrt[2] Sqrt[1-AUC];
 maxRUauc=(maxRUmax+maxRUmin)/2;
 maxRUauc0=AUC -  Sqrt[(1- AUC)/2];
 (*
 Print["check ",{maxRUauc,maxRUauc0, maxRUauc-maxRUauc0}];
*)
plot0=Plot[roc,{x,0,1},PlotRange->{{0,1},{0,1}}];
AUCs=ToString@N[Round[AUC 100]/100];
maxRUeqns=ToString@N[Round[maxRUeqn 100]/100];
maxRUaucs=ToString@N[Round[maxRUauc0 100]/100];
label=StringJoin["(",maxRUeqns," ",maxRUaucs,")"];
label=StringJoin["maxRU   ",maxRUeqns," , ",maxRUaucs];
Return[{roc,label}]]




(*---------------------Proof--------*)

ProofMTT[x_,format_:"manu"]:=
Module[{roc,ROCplot,AUC,ROCslope,pair,pairs,slopedif,c,h,maxRU,ratio,pairvec,parivecs,slicevec,w,plot0,vert,diag,plot},
color1=Darker[Green];
color2=Red;
color3=Blue;
th=Thickness[.01];
If[format=="manu",font=Medium];
If[format=="talk",font=Large];
(*ROC CURVE*)
roc=ROC[x,3,5];
ROCslope=D[roc,x];w=.01;
slicevec=Table[roc w + ROCslope w^2 .5,{x,.02,.98,w}];
AUC=Total[slicevec];
pairvec=Table[{Abs[ROCslope-1],x},{x,.02,.98,w}];
pairvecs=Sort[pairvec, #1[[1]] < #2[[1]] &];
{slopedif,c}=pairvecs[[1]];
maxRU=(roc-x)/.x->c;
 maxRUmax= 2 AUC-1;
 maxRUmin= 1 - Sqrt[2] Sqrt[1-AUC];
maxRUavg=(maxRUmax+maxRUmin)/2;
plot0=Plot[roc,{x,0,1},PlotStyle->{th,color2},PlotRange->{{0,1},{0,1}},Ticks->None, Axes->None];
h=maxRU;
diag=Graphics@Line[{{0,0},{1,1}}];
rocvec={plot0,diag};
(*POINTS*)
e=.04;
nameA=Graphics@TextZ["D",{0+e/2,1-e},{0,0}];
nameB=Graphics@TextZ["B",{1-h,1-e},{0,0}];
nameC=Graphics@TextZ["C",{1,1-e },{0,0}];
nameD=Graphics@TextZ["A",{c+e,h+c-e},{0,0}];
nameE=Graphics@TextZ["E",{c+e,c},{0,0}];
nameF=Graphics@TextZ["F",{1.5 e,e/2},{0,0}];
nameG=Graphics@TextZ["G",{e,h},{0,0}];
namevec={nameA,nameB,nameC,nameD,nameE,nameF,nameG};
r=.03;
pointA=Graphics@{PointSize[r],Point[{0,1}]};
pointB=Graphics@{PointSize[r],Point[{1-h,1}]};
pointC=Graphics@{PointSize[r],Point[{1,1}]};
pointD=Graphics@{PointSize[r],Point[{c,h+c}]};
pointE=Graphics@{PointSize[r],Point[{c,c}]};
pointF=Graphics@{PointSize[r],Point[{0,0}]};
pointG=Graphics@{PointSize[r],Point[{0,h}]};
pointvec={pointA,pointB,pointC,pointD,pointE,pointF,pointG};
(*AXES*)
z0=Style["0",font];
z1=Style["1",font];
nameH0=Graphics@TextZ[z0,{0,-e},{0,0}];
nameH1=Graphics@TextZ[z1,{1,-e},{0,0}];
nameV0=Graphics@TextZ[z0,{-e,0},{0,0}];
nameV1=Graphics@TextZ[z1,{-e,1},{0,0}];
nameF=Style["false positive rate",font];
nameT=Style["true positive rate",font];
labC=Graphics@Text["f",{c,-e},{0,0}];
nameBOT=Graphics@TextZ[nameF,{.6,- 2e},{0,0}];
nameSIDE=Graphics@{Rotate[TextZ[nameT,{-e,.5},{0,0}], 90 Degree]};
linetop=Graphics@Line[{{0,1},{1-h,1}}];
linebot=Graphics@Line[{{0,0},{1,0}}];
lineside=Graphics@Line[{{0,0},{0,1}}];
axesvec={nameH0,nameH1,nameV0,nameV1,nameBOT,nameSIDE,linetop,linebot,lineside,labC};

(*LABEL ROC AND LOWER AND UPPER*)
v1=.3;
v2=.2;
v3=.1;
hL=.84;
hLX=.87;
hR=.98;
If[format=="manu",
name1=Style["upper bound ROC curve",font];
name2=Style["ROC curve",font];
name3=Style["lower bound ROC curve",font]];
If[format=="talk",
name1=Style["ROC upper bound",font];
name2=Style["ROC curve",font];
name3=Style["ROC lower bound",font]];
namex1=Graphics@TextZ[name1,{hL, v1},{1,0}];
namex2=Graphics@TextZ[name2,{hL,  v2},{1,0}];
namex3=Graphics@TextZ[name3,{hL, v3},{1,0}];
line1=Graphics@{color1,th,dash1,Line[{{hLX,v1},{hR,v1}}]};
line2=Graphics@{color2,th,Line[{{hLX,v2},{hR,v2}}]};
line3=Graphics@{color3,th,dash3,Line[{{hLX,v3},{hR,v3}}]};
labelvec={namex1,namex2,namex3,line1,line2,line3};
(*H ARROW*)
verthU=Graphics@Arrow[{{c,c+h/2+.05},{c,maxRU+c}}];
verthD=Graphics@Arrow[{{c,c+h/2-.05},{c,c}}];
If[format=="manu",nameh=Graphics@Text["h",{c,c+h/2},{0,0}]];
If[format=="talk",nameh=Graphics@Text[Style["maxRU",Large,Bold],{c,c+h/2},{0,0}]];
harrowvec={verthU,verthD,nameh};
(*C ARROW*)
vertcU=Graphics@Arrow[{{c,c/2+.05},{c,c}}];
vertcD=Graphics@Arrow[{{c,c/2-.05},{c,0}}];
sopt=Subscript[s,opt];
namec=Graphics@Text[sopt,{c,c/2},{0,0}];
carrowvec={vertcU,vertcD,namec};
(*UPPER*)
dash1=Dashing[{.02,.02}];
tangent=Graphics@{th,color1,dash1,Line[{{0,h},{1-h,1}}]};
tangentL=Graphics@{th,color1,dash1,Line[{{0,0},{0,h}}]};
tangentR=Graphics@{th,color1,dash1,Line[{{1-h,1},{1,1}}]};
sideUPP=Graphics@{th,color1,dash1,Line[{{0,0},{0,h}}]};
uppervec={tangent, tangentL, tangentR,sideUPP};
(*LOWER BOUND*)
dash3=Dashing[{.04,.04}];
lineL=Graphics@{color3,th,dash3,Line[{{0,0},{c,c+h}}]};
lineR=Graphics@{color3,th,dash3,Line[{{c,c+h},{1,1}}]};
lowervec={lineL,lineR};
(*COMBINE*)
vecmanu=Join[rocvec,uppervec,lowervec,harrowvec,labelvec,axesvec  , namevec, pointvec];
vectalk=Join[rocvec,uppervec,lowervec,harrowvec,labelvec,axesvec];
If[format=="manu", plot=Show[vecmanu, AspectRatio->1,PlotRange->{{-.06,1.03},{-.13, 1.03}}]];
If[format=="talk", plot=Show[vectalk, AspectRatio->1,PlotRange->{{-.06,1.03},{-.13, 1.03}}]];
Print["format ",format];
ExportPlotX["Fig3",plot,format];
Return[Null]]


TextZ[name_,point_,loc_]:=Text[Style[name,Bold],point,loc]

(*----Derive----------------------*)

DeriveMTT[h_,A_]:=
Module[{hmax0,hmin0,hmax,hmin,hmean},
rulemax0= Flatten@Solve[A==1/2 + h/2,h];
rulemin0=Flatten@Solve[A==1-((1-h)^2)/2,h];
hmax=h/.rulemax0;
hmin= h/.rulemin0//Simplify;
hmean=(hmax+hmin)/2//Simplify;
Print["hmax ",hmax];
Print["hmin ",hmin];
Print["hmean= ",hmean];
hsim=A -  Sqrt[(1- A)/2];
Print["hsimplified = ",hsim];
Print["check ",Simplify[hsim-hmean]];
Return[Null]]









ExportPlotX[figname_,plot0_,format_:"manu"]:=
	  Module[{plotnamejpg,plot},
	  If[format=="talk",
	  plot=Show[plot0,ImageSize->Large], plot=plot0];
	 Print[plot];
         plotnameeps=StringJoin["figrufit",figname,".eps"];    
	 	    	       Export[plotnameeps,plot]; 
	 	              Print["    exporting ",plotnameeps];
	  plotnamejpg=StringJoin["figrufit",figname,".jpg"];    
	 	    	       Export[plotnamejpg,plot]; 
	 	              Print["    exporting ",plotnamejpg]; 	              
	 Return[Null]]



BoundMTT[x_,format_:"manu"]:=
Module[{roc,ROCplot,AUC,ROCslope,pair,pairs,slopedif,c,h,maxRU,ratio,pairvec,parivecs,slicevec,w,plot0,vert,diag,plot},
color1=Red;
color2=Blue;
th=Thickness[.01];
If[format=="manu",font=Medium;thx=.002];
If[format=="talk",font=Large;thx=.008];
th=Thickness[thx];
h2=.4;
h1=.2;
off=0;
xL=.2 +off;
xR=.8 +off;
xR=1.2;

P=.5;
dash1=Dashing[{.03,.03}];
line1L=Graphics@{color1, th,dash1,Line[{{xL, 0},{P,h1}}]};
line1R=Graphics@{color1, th,dash1, Line[{{xR, 0},{P,h1}}]};
line2L=Graphics@{color2, th,Line[{{xL, 0},{P,h2}}]};
line2R=Graphics@{color2, th, Line[{{xR, 0},{P,h2}}]};
linebot=Graphics@{Black, th, Line[{{0, 0},{1.3,0}}]};

hnamex=Style["risk\nthreshold",font];
vnamex=Style["relative\nutility",font];
hname=Graphics@Text[hnamex,{.9,0},{-1,0}];
vname=Graphics@Text[vnamex,{0,.45},{0,0}];

hnamex=Style["risk threshold",font];
vnamex=Style["relative utility",font];
hname=Graphics@Text[hnamex,{.5,-.1},{0,0}];
vname=Graphics@Rotate[Text[vnamex,{-.05,.2},{0,0}], 90 Degree];




lineside=Graphics@{Black, Line[{{0, 0},{0,.41}}]};
slope1=h1/(P-xL);
y1= h1- slope1 .8 (P-xL);
slope2=h2/(P-xL);
y2= h2- slope2 .8 (P-xL);

slope2=h2/(P-xR);
y2= h2- slope2 .8 (P-xR);


Print["maxRU ",h2-h1];
Print["RUdif at 80% ",y2-y1];
lenL=.5-xL;
lenR=xR-.5;
zL=xL + .2 .3;
zR=xR -.2 .3;
zR=xR -.2 lenR;
colorP=Purple;
lineZP=Graphics@{colorP, th, Line[{{P, h1},{P,h2}}]};


colorZ=Darker[Green];
lineZL=Graphics@{colorZ, th, Line[{{zL, y1},{zL,y2}}]};
lineZR=Graphics@{colorZ, th, Line[{{zR, y1},{zR,y2}}]};

k2=h2;
k1=h2-.05;
name1x=Style["Model 1",font];
name2x=Style["Model 2",font];
q1=.3;
q2=.4;
name1=Graphics@Text[name1x,{q1,k1},{1,0}];
name2=Graphics@Text[name2x,{q1,k2},{1,0}];
linename1=Graphics@{color1, th, dash1, Line[{{q1, k1},{q2,k1}}]};
linename2=Graphics@{color2,  th, Line[{{q1, k2},{q2,k2}}]};
f=.05;
g=.05;
arrowbotL=Graphics@{colorZ, th,Arrow[{{P-f, -g},{zL,-g}}]};
arrowbotR=Graphics@{colorZ, th, Arrow[{{P+f, -g},{zR,-g}}]};
namebotx=Style["80%",font];
namebotR=Graphics@Text[namebotx,{P,-g},{0,0}];

hmid=(h1+h2)/2;
posmax=P+.3;
arrowmax=Graphics@{colorP, th,Arrow[{{posmax, hmid},{P,hmid}}]};
namemaxx=Style["difference in\nmax RU",font];
namemax=Graphics@Text[namemaxx,{posmax,hmid},{-1,0}];

xposZ=.15;
yposZ=.08;
If[format=="talk", yposZ=.05];
ymid=(y1+y2)/2;
arrowbound=Graphics@{colorZ, th, Arrow[{{xposZ, yposZ},{zL,ymid}}]};
nameboundx=Style["1/5 of\ndifference\n in max RU",font];

namebound=Graphics@Text[nameboundx,{xposZ,yposZ},{0,-1}];


plot0=Show[line1L,line1R,line2L,line2R,linebot,lineside,lineZP,lineZL,lineZR,
name1,name2,linename1,linename2,arrowbotL,arrowbotR,namebotR,hname,vname,
arrowmax,namemax,arrowbound,namebound];
ExportPlotX["bound0",plot0,format];

plot=Show[line1L,line1R,line2L,line2R,linebot,lineside,lineZP,lineZL,lineZR,
name1,name2,linename1,linename2,arrowbotL,arrowbotR,namebotR,hname,vname];
ExportPlotX["bound",plot,format];

Return[Null]]







  
  
  
  
  
  
  
  
CheckROC[x_,a_,b_]:=
Module[{roc,plot,ROCslope,xrule},
  roc=ROC[x,a,b];
  plot=Plot[roc,{x,0,1}];
  Print[plot];
    ROCslope=D[roc,x];
     xrule=Quiet@Solve[ROCslope==1,x];
     Print[xrule];
  Return[Null]]
  




ROC[x_,a_,b_]:= (a x /(1- x + a x)) .8 + (b x /(1- x + b x)) .2 


ROCZ[x_,a_,b_,z_]:=
Module[{roc},
If[z==1,roc= (a x /(1- x + a x)) .8 + (b x /(1- x + b x)) .2];
If[z==2, roc= Sqrt[a x + b x^2]/Sqrt[a + b]];
If[z==3, roc= (a x + b x^2)^(1/3)/  (a + b)^(1/3)];
Return[roc]]





End[] 
EndPackage[]

Print["ProofMTT[x] for Figure 3"];
Print["PlotMTT[x] for Figure 4"];


