(*:Mathematica:: V2.2 *)
(*:Context:: "pad`" *)
(*Title:: statistical package *)
(*Summary:: the following functions   *)
(*References*)
(*Keywords:  *)
(*Requirements:  None *)

(*History: 2017 Stuart G. Baker *)

(*Input
PlotPointSet               pfitplot.m
PlotStudyNameKey  pfitplot.m*)


BeginPackage["pfitreg`","pfitplot`"]


RegressSet::usage="RegressSet[d,se,t,f,xmax,resREF]"


Clear[RegressSet]


Begin["Private`"]

RegressSet[d_,se_,t_,f_,n_,k_,{name_,hname_,vname_},{miny_,maxy_}]:=
Module[{a,b,c,e,x,v,w,cons,xmat,a0,b0,c0,style,
  eFLA, aicFLA,resFLA,
  eLIN,aicLIN, resLIN,ciLIN,ciLIN1,
   eQUA,aicQUA, resQUA,ciQUA,ciQUA1,
  eSIG,aicSIG,resSIG,ciSIG,ciSIG1,lowSIG,uppSIG,aicvec,
   aicLAST,aicMIN},
(*basic*)
    fmax=1;
 (*WEIGHT BY 1/VAR*)  
     v=se^2;
     w=1/v;
    cons=Table[1,{i,1,Length[d]}];
     xmat=Transpose[{cons,f}];
   (*FLAT*)
     eFLA=d-Mean[d];
     aicFLA=AICF[eFLA,1]; 
     (*EVALUATION AT FMAX*)
   (*LINEAR*)
           dataXY=Transpose[{f,d}];
           modLIN=Quiet@NonlinearModelFit[dataXY, linf[{a,b,x}], {a, b}, x,
                     Weights->w];  
            eLIN=modLIN["FitResiduals"];
            aicLIN=AICF[eLIN,3];
           estLIN=modLIN["BestFit"];
            estLIN1=estLIN/.x -> fmax;
            ciLIN=modLIN["MeanPredictionBands",ConfidenceLevel->.95];
            ciLIN1=ciLIN/.x -> fmax;
             resLIN=Join[{estLIN1},ciLIN1];
      (*QUADRATIC*)
     dataXY=Transpose[{f,d}];
     modQUA=Quiet@NonlinearModelFit[dataXY, quaf[{a,b,c,x}], {a, b,c}, x,
               Weights->w];  
      eQUA=modQUA["FitResiduals"];
      aicQUA=AICF[eQUA,3];
     estQUA=modQUA["BestFit"];
      estQUA1=estQUA/.x -> fmax;
      ciQUA=modQUA["MeanPredictionBands",ConfidenceLevel->.95];
      ciQUA1=ciQUA/.x -> fmax;
       resQUA=Join[{estQUA1},ciQUA1];
 (*SIGMOID*)
      dataXY=Transpose[{f,d}];
       If[Length[d]>3,
         a0=Mean@Take[d,3];
         b0=Mean@Take[d,-3]];
       If[Length[d]==3,
         a0=Mean@Take[d,1];
         b0=Mean@Take[d,-1]];         
           c0=0;
        modSIG=Quiet@NonlinearModelFit[dataXY, sigf[{a,b,c,x}], {{a,a0},{b,b0},{c,c0}}, x,
                    Weights->w];  
        eSIG=modSIG["FitResiduals"];
          aicSIG=AICF[eSIG,4]//N;   
          estSIG=modSIG["BestFit"];
           estSIG1=estSIG/.x -> fmax;
           ciSIG=modSIG["MeanPredictionBands",ConfidenceLevel->.95];
           ciSIG1=ciSIG/.x -> fmax;
           {lowSIG,uppSIG}=ciSIG1;
           resSIG=Join[{estSIG1},ciSIG1];
   (*PLOT*)
   style={Dashing[{.01,.01}],Black};
   plotpoints=PlotPointSet[d,f,se,n,k,{hname,vname},{miny,maxy}];
 hline=Graphics@{Dashing[{.01,.01}],Line[{{0,0},{1,0}}]};
addtop=.16;
   range={{0,1.6},{miny,maxy+addtop}};
  {keyname,keyline,keyname1,keyline1,keylinetop,keylinebot}=PlotLabCIReg[{miny,maxy},addtop];
 labvec=PlotStudyNameKey[f,d,se,name,{miny,maxy},addtop];
 (*LINEAR*)
      ciLIN=modLIN["MeanPredictionBands",ConfidenceLevel->.95];
       plotLINbounds=Plot[ciLIN,{x,0,1},PlotStyle->{style,style}];
       plotLINest=Plot[estLIN,{x,0,1},PlotStyle->Black];     
       plotLIN=Show[plotpoints,plotLINest,plotLINbounds,keyname,keyline, keyname1,keyline1,keylinetop,keylinebot,labvec,
       Axes->{False,False},
          FrameTicks->{{0,.2,.4,.6,.8,1},Automatic,None,None},
                      PlotRange->range,Frame->True, FrameLabel->{hname,vname,"Linear",Null},LabelStyle->Medium];
   (*QUADRATIC*)
      ciQUA=modQUA["MeanPredictionBands",ConfidenceLevel->.95];
      plotQUAbounds=Plot[ciQUA,{x,0,1},PlotStyle->{style,style}];
      plotQUAest=Plot[estQUA,{x,0,1},PlotStyle->Black];     
      plotQUA=Show[plotpoints,plotQUAest,plotQUAbounds, keyname,keyline, keyname1,keyline1,keylinetop,keylinebot,labvec,
      Axes->{False,False},
            PlotRange->range,
   FrameTicks->{{0,.2,.4,.6,.8,1},Automatic,None,None},
                      Frame->True,FrameLabel->{hname,vname,"Quadratic",Null},LabelStyle->Medium];
   (*SIGMOID*)
     ciSIG=modSIG["MeanPredictionBands",ConfidenceLevel->.95];
      plotSIGbounds=Plot[ciSIG,{x,0,1},PlotStyle->{style,style}];
      plotSIGest=Plot[estSIG,{x,0,1},PlotStyle->Black];     
      plotSIG=Show[plotpoints,plotSIGest,plotSIGbounds,keyname,keyline, keyname1,keyline1,keylinetop,keylinebot,labvec,
            Axes->{False,False},
            PlotRange->range,
   FrameTicks->{{0,.2,.4,.6,.8,1},Automatic,None,None},
                      Frame->True,FrameLabel->{hname,vname,"Sigmoid",Null},LabelStyle->Medium];
    resvec={resLIN,resQUA,resSIG};
    plotvec={plotLIN,plotQUA,plotSIG};
     aicvec={aicLIN,aicQUA,aicSIG};
Return[{resvec,plotvec,aicvec}]]



PlotLabCIReg[{miny_,maxy_},addtop_]:=
 Module[{x0,y0,keyname,keyline},
 y0=miny + 1.2 (maxy-miny);
 x0=.5;
  keyname=Graphics@Text["95% CI for regression model ", {x0,y0},{1,0}];
  keyline=Graphics@{Dashing[{.01,.01}],Black,Line[{{x0,y0},{x0+.1,y0}}]};
x1=.5;
y1=miny + 1.1 (maxy-miny);
  keyname1=Graphics@Text["95% CI for study ", {x1,y1},{1,0}];
  keyline1=Graphics@{Black,Line[{{x1+.02,y1-.03},{x1+.02,y1+.03}}]};
  keylinetop=Graphics@{Black,Line[{{x1,y1+.03},{x1+.04,y1+.03}}]};
  keylinebot=Graphics@{Black,Line[{{x1,y1-.03},{x1+.04,y1-.03}}]};  
Return[{keyname,keyline,keyname1,keyline1,keylinetop,keylinebot}]]






(*----SUPPPORT------------------*)

AICF[e_,k0_]:=
Module[{k,n,rss,aic,rss0,meanBOUND,varBOUND,rssBOUND},
 k=k0+1; (*add 1 for sigma2*)
 rss=Mean[e^2];
 n=Length[e];
 aic=2 k + n Log[rss] + 2 k (k+1)/(n-k-1);
 Return[aic]]
 
  cubf[{a_,b_,c_,d_,x_}]:= a + b x  + c x^2 +d x^3
 linf[{a_,b_,x_}]:= a + b x  
 quaf[{a_,b_,c_,x_}]:= a + b x  + c x^2 
sigf3[{a_,b_,c_,x_}]:=  a + b Expit[x-c ]

sigf[{a_,b_,c_,x_}]:=  a + (b-a) Expit[(x-Expit[c])]
sigf0[{a0_,b0_},{c_,x_}]:=  a0 + (b0-a0) Expit[(x-Expit[c]) ]

Expit[x_]:= Exp[x]/(1+Exp[x])






End[]
EndPackage[]



