 (*:Mathematica:: V2.2 *)
(*:Context:: "pad`" *)
(*Title:: statistical package *)
(*Summary:: the following functions   *)
(*References*)
(*Keywords:  *)
(*Requirements:  None *)

(*History: 2011 Stuart G. Baker *)

                                      


BeginPackage["pfitplot`"]

PlotPointSet::usage="PlotPoints[data]"
PlotStudyNameKey::usage="PlotPoints[data]"


Clear[PlotPointSet,PlotStudyNameKey]



Begin["Private`"]

PlotPointSet[d_,f_,se_,n_,k_,{hname_,vname_},{miny_,maxy_}]:=
Module[{plotpoints0,plotpoints,plot},
      plotpoints0=GenCI[d,f,se,n,k]; 
     plotpoints=Show[plotpoints0, Frame->True,FrameLabel->{hname,
          vname,   "Data Points",None}];
    Return[plotpoints]]


GenCI[d_,f_,se_,n_,k_]:=
Module[{tri,plotdot, plotline},
    tri=Transpose[{d, f, se,n}];
    plotdot=GenDot[#,k]& /@ tri;
    plotline=GenLine[#]& /@ tri;
    plotlinetop=GenLineTop[#]& /@ tri;
    plotlinebot=GenLineBot[#]& /@ tri;
   res=Join[plotdot, plotline,plotlinetop,plotlinebot];
  Return[res]]

  
GenLine[{d_,f_,se_,n_}]:= Graphics@{Line[{{f,d-1.96 se},{f, d+1.96 se}}]};
GenLineTop[{d_,f_,se_,n_}]:= Graphics@{Line[{{f-.02,d+1.96 se},{f+.02, d+1.96 se}}]};
GenLineBot[{d_,f_,se_,n_}]:= Graphics@{Line[{{f-.02,d-1.96 se},{f+.02, d-1.96 se}}]};

GenDot[{d_,f_,se_,n_},k_]:= Graphics@{PointSize[k Sqrt[n]], Point[{f,d}]}




PlotStudyNameKey[f_,d_,se_,name_,{miny_,maxy_},addtop_]:=
Module[{len,upp,pair,fs,names,upps,range,pairs,labmat,labvec},
len=Length[f];
upp=d+ 1.96 se;
pair=Sort@Transpose[{f,name,upp}];
{fs,names,upps}=Transpose[pair];
range=Range[len];
pairs=Transpose[{fs,range,names,upps}];
labmat=PlotStudyNameOne[#,len,{miny,maxy},addtop]& /@ pairs;
labvec=Flatten[labmat];
Return[labvec]]


PlotStudyNameOne[{f_,i_,name_,upp_},len_,{miny_,maxy_},addtop_]:=
Module[{is,pointlab,names,key,y0},
is=ToString[i];
pointlab=Graphics@Text[is,{f,upp+.03},{0,0}];
names=StringJoin[is," = ",name];
y0=miny+addtop+ (maxy -miny) (len-i)/ (len+1); 
key=Graphics@Text[names,{1.20, y0},{-1,0}];
Return[{pointlab,key}]]





End[]
EndPackage[]