(*:Mathematica:: V2.2 *)
(*:Context:: "pad`" *)
(*Title:: statistical package *)
(*Summary:: the following functions   *)
(*References*)
(*Keywords:  *)
(*Requirements:  None *)
(*History: 2017 Stuart G. Baker *)
(*Input
PlotPointSet               pfitplot.m
PlotStudyNameKey  pfitplot.m*)

BeginPackage["pfitmeta`","pfitplot`"]

MetaAnalysis::usage="MetaAnalysis[d,se,t,f]"


Clear[MetaAnalysis]

Begin["Private`"]


                  
MetaAnalysis[d_,se_,t_,f_,n_,k_,{name_,hname_,vname_},{miny_,maxy_}]:=
 Module[{v,w,h,dw,sumw,sumw2,Q,k0,sigma2,vRAN,setFIX,setRAN,
    wFIX,resFIX,wFIXADJ,resFIXADJ,
    wRAN,resRAN,wRANADJ,resRANADJ,
    vec,mat,res,plotavg},
 (*Basics*)
 	v=se^2;
 	w=1/v;
 	h=w/Apply[Plus,w];
	dw= Apply[Plus, d h];
         sumw=Apply[Plus,w];
    	sumw2=Apply[Plus,w^2];
    	Q= Apply[Plus, w (d-dw)^2];  
    	k0=Length[d];
   	 sigma2=Max[0,(Q-(k0-1))/(sumw-sumw2/sumw)];
   	 vRAN=(v+sigma2);
         setFIX={d,v,t};
         setRAN={d,vRAN,t};
                (*FIX*)
  	resFIX=GenEstCI[setFIX,1/v];
   	aicFIX=AICX[d,resFIX];
  (*FIX ADJUSTED *)
    	resFIXADJ=GenEstCI[setFIX,f/v];
   	aicFIXADJ=AICX[d,resFIXADJ];
   (*RANDOM EFFECTS ORIGINAL*)
   	resRAN=GenEstCI[setRAN,1/vRAN];
   	aicRAN=AICX[d,resRAN];
 (*RANDOM EFFECTS ADJUSTED by fraction*)  
   	resRANADJ=GenEstCI[setRAN,f/vRAN];  
   	aicRANADJ=AICX[d,resRANADJ];
 (*RANDOM EFFECTS ADJUSTED by fraction squared*)  
  resRANADJ2=GenEstCI[setRAN,f^2/vRAN];  
    	aicRANADJ2=AICX[d,resRANADJ2];  
  (*output*)
      resvec={resFIX,resFIXADJ,resRAN,resRANADJ,resRANADJ2};
      plotRAN=PlotAvg["Random Effects Model",resRAN,{f,d,se,n,k},{name,hname,vname},{miny,maxy}];
    plotRANADJ=PlotAvg["Random Effects Model  Weighted by Fraction",resRANADJ,{f,d,se,n,k},{name,hname,vname},{miny,maxy}];
      plotRANADJ2=PlotAvg["Random Effects Model Weighted by Fraction Squared",resRANADJ2,{f,d,se,n,k},{name,hname,vname},{miny,maxy}];
    aicvec={aicFIX,aicFIXADJ,aicRAN,aicRANADJ,aicRANADJ2};
  Return[{resvec,plotRAN,plotRANADJ,plotRANADJ2,aicvec}]] 


  GenEstCI[{d_,v_,t_},w0_]:=
  Module[{h0,d0,v0,se0,low0,upp0,res0},    
       h0=w0/Apply[Plus,w0];
       d0= Apply[Plus, d h0];
    	v0=Apply[Plus, v h0^2];
        se0=Sqrt[v0];
        low0=d0- t se0;
        upp0=d0 +t se0;
    	res0={d0,low0,upp0};
    Return[res0]]



AICX[d_,res_]:=
Module[{mean,eFLA,aicFLA},
  mean=res[[1]];
  eFLA=d-mean;
  aicFLA=AICF[eFLA,1]; 
Return[aicFLA]]


AICF[e_,k0_]:=
Module[{k,n,rss,aic,rss0,meanBOUND,varBOUND,rssBOUND},
 k=k0+1; (*add 1 for sigma2*)
 rss=Mean[e^2];
 n=Length[e];
 aic=2 k + n Log[rss] + 2 k (k+1)/(n-k-1);
 Return[aic]]



ZeroSign[x_]:=1-Abs[Sign[x]]
        

ReplaceZero[x_,new_:1]:=
   x + ZeroSign[x] new   

PlotAvg[plotname_,{est_,low_,upp_},{f_,d_,se_,n_,k_},{name_, hname_,vname_},{miny_,maxy_}]:=
Module[{linest,linlow,linupp,tri,plotpoints,range,plot,style,labvec},
  (*lines*)
      xe=1.06;
      linest=Graphics@{Black, Line[{{xe,low},{xe,upp}}]};
      lintop=Graphics@{Black, Line[{{xe-.02,upp},{xe+.02,upp}}]};
      linbot=Graphics@{Black, Line[{{xe-.02,low},{xe+.02,low}}]};
     nameM=Graphics@Text["M",{xe,upp+.03},{0,0}];
     yM=miny+ .15(maxy-miny);
     keyM=Graphics@Text["M = meta-analysis",{1.20,yM},{-1,0}];
     (*points*)
    plotpoints=PlotPointSet[d,f,se,n,k,{hname,vname},{miny,maxy}];
  (*labels*)
    addtop=.26;
    {keyname1,keyline1,keylinetop,keylinebot,keypoint}=PlotLabCIMeta[{miny,maxy},addtop];
    range={{0,1.6},{miny,maxy+addtop}};
    labvec=PlotStudyNameKey[f,d,se,name,{miny,maxy},addtop];
    hline=Graphics@{Dashing[{.01,.01}],Black,Line[{{0,0},{1,0}}]};
 
 plot=Show[hline,plotpoints,linest,lintop,linbot,keyname1,keyline1,keylinetop,keylinebot,labvec,hline,nameM,keyM,keypoint,
    Axes->{False,False},   PlotRange->range,
            FrameTicks->{{0,.2,.4,.6,.8,1},Automatic,None,None},
             Frame->True,FrameLabel->{hname,vname,None,None},LabelStyle->Medium];
Return[plot]]

PlotLabCIMeta[{miny_,maxy_},addtop_]:=
 Module[{x0,y0,keyname,keyline},
 y0=miny + (maxy-miny);
 x1=.9;
y0=miny + 1.25 (maxy-miny);
y1=miny + 1.15 (maxy-miny);

  keypoint=Graphics@Text["Point size proportional to sample size ", {x1,y0},{1,0}];
  
  keyname1=Graphics@Text["95% confidence interval ", {x1,y1},{1,0}];
  keyline1=Graphics@{Black,Line[{{x1+.02,y1-.03},{x1+.02,y1+.03}}]};
  keylinetop=Graphics@{Black,Line[{{x1,y1+.03},{x1+.04,y1+.03}}]};
  keylinebot=Graphics@{Black,Line[{{x1,y1-.03},{x1+.04,y1-.03}}]};  
Return[{keyname1,keyline1,keylinetop,keylinebot,keypoint}]]



End[]
EndPackage[]



