(*:Mathematica:: V2.2.1 *)
(*:Context: "cdxnlr`" *)
(*:Version  1.1 *)
(*:Title:: PAD *)
(*:Summary::    *)
(*References::  *)
(*Keywords:: *)
(*Requirements:: *)(*History:  2018 Stuart G. Baker *)

         

BeginPackage["pfitdata`"]

GenDataPad::usage="GenDataPad"
GenDataPad::usage="GenDataRCT"
Dailey2000::usage="Dailey2000"

Clear[GenDataPad,GenDataRCT]

Begin["Private`"] 

GenDataPad[show_:False]:=
Module[{datapad,namepad,hname,vname,dataset,colname},
datapad0={{1298,0,-1,-1,117,1084,520,-1,-1,89},
{4785,876,-1,-1,699,4087,2752,-1,-1,501},
{781,91,-1,-1,90,781,547,-1,-1,90},
{5436,2324,-1,-1,1318,12590,8189,-1,-1,3453},
{116,82,-1,-1,20,103,28,-1,-1,19},
{373,49,-1,-1,41,421,247,-1,-1,42},
{3195,38,-1,-1,291,3733,1098,-1,-1,362},
{4778,38,-1,-1,926,4859,2848,-1,-1,924},
{1000,99,-1,-1,38,2000,1026,-1,-1,90},
{277,0,-1,-1,9,1284,1284,-1,-1,156},
{507,1,-1,-1,73,581,488,-1,-1,70},
{7821,774,-1,-1,2065,13537,2274,-1,-1,3046}};
namepad0={"Gribble_1991","Larson_1992","Mancuso_1993","Newman_1995","Johnson_1995",
 "Lyon_1997","Fogel_1998","Yancey_1990","Impey_2000","Traynor_2000","Zhang_2001","Wassen_2011"};
 (*Drop Traynor*)

   datapad=Drop[datapad0,{-3}]~ Join~ Dailey2000[];
    namepad=Drop[namepad0,{-3}] ~Join~ {"Dailey_2000"};
    
 colname={"n0", "e0", "c00","c01","c0", "n1", "e1", "c10","c11","c1"};
If[show,
Print@TableForm[datapad,TableHeadings->{namepad,colname}]];
 hname="absolute change in fraction receiving epidural analgesia";   
  vname= "change in rate of C-section" ;
  dataset={datapad,namepad,"ecspad", hname,vname};
  Return[dataset]]
  
  
  
 Dailey2000[]:=                            
  Module[{nvec,evec,cvec,n0,e0,c0,n1,e1,c1,res,set,res1,res2,res3,res4,res5,
     i,zvec,tvec,namevec},
    nvec={2175,2239,2115,2226,2404,2476,2450,2334,2320,2289};
    evec={.18,.27,.35,.43,.40,.467,.49,.521,.483,.535};
    cvec0={451,441,493,479,474,517,521,484,458,498};
    cvec=cvec0/nvec;
    (*Select large difference in epidural rate in shortest time*)
    (*1989 and 1994*)
    n0=nvec[[1]];
    e0=Round[evec[[1]] n0];
    c0=Round[cvec[[1]] n0];
     n1=nvec[[6]];
     e1=Round[evec[[6]] n1];
     c1=Round[ cvec[[6]] n1];
     c00=-1;
     c01=-1;
     c10=-1;
     c11=-1;
     res={{n0,e0,c00,c01,c0,n1,e1,c10,c11,c1}};
  Return[res]] 
  
  
  
  
  
GenDataRCT[show_:False]:=
Module[{datapad,namerct,hname,vname,dataset,colname},
datarct0={{54,0,-1,-1,6,57,57,-1,-1,10},
{45,1,-1,-1,1,48,47,-1,-1,12},
{666,103,-1,-1,17,664,432,-1,-1,39},
{22,11,-1,-1,2,28,28,-1,-1,3},
{357,5,14,2,16,358,243,1,12,13},
{51,12,2,1,3,49,47,0,5,5},
{10,4,-1,-1,0,10,10,-1,-1,0},
{162,84,8,14,22,156,147,1,14,15},
{607,159,-1,-1,34,616,400,-1,-1,39},
{88,0,-1,-1,9,97,97,-1,-1,11},
{310,175,-1,-1,40,304,257,-1,-1,36},
{185,52,-1,-1,16,184,123,-1,-1,13},
{366,5,-1,-1,62,372,321,-1,-1,63},
{499,306,-1,-1,71,493,356,-1,-1,85},
{233,14,-1,-1,20,226,214,-1,-1,16},
{60,1,7,0,7,56,53,0,10,10},
{83,0,11,0,11,45,43,2,7,9},
{118,51,5,7,12,124,124,0,12,12},
{198,0,19,0,19,197,197,0,24,24},
{24,0,1,0,1,25,25,0,1,1},
{44,0,-1,-1,4,148,148,-1,-1,19},
{15,0,-1,-1,3,15,15,-1,-1,4}};
namerct0={"Philipsen_1989","Thorp_1993","Ramin_1995","Muir_1996", "Sharma_1997",
       "Bofill_1997","Nikkola_1997","Clark_1998",   "Gambling_1998","Muir_2000",
       "Loughnan_2000","Howell_2001",   "Lucas_2001","Dickinson_2002","Sharma_2002",
       "Head_2002",   "Jain_2003","Halpern_2004","Nafisi_2006","Volmanen_2008",
   "Evron_2008","El-Kerdawy_2010"};
   (*drop study Nikkola as no C sections and only 10 persons in each group*)
   datarct=Drop[datarct0,{7}];
   namerct=Drop[namerct0,{7}];
    
 colname={"n0", "e0", "c00","c01","c0", "n1", "e1", "c10","c11","c1"};
If[show,
Print@TableForm[datarct,TableHeadings->{namerct,colname}]];
 hname="absolute change in fraction receiving epidural analgesia";   
  vname= "change in rate of C-section" ;
  dataset={datarct,namerct,"ecsrct", hname,vname};
  Return[dataset]]

       
End[] 
EndPackage[]
  
  show=False;
datapad=GenDataPad[show];
datarct=GenDataRCT[show];
Print["datapad datarct"];
