(*:Mathematica:: V11 *)
(*:Context:: "pad`" *)
(*Title:: statistical package for paired availablity design *)
(*Summary:: the following functions   *)
(*References*)
(*Keywords:  *)
(*Requirements:  None *)
(*History: 2017 Stuart G. Baker *)

(*Input
MetaAnalysis  pfitmeta.m                  
RegressSet   pfitreg.m*)



ShowMarker::usage="MarkerNumberList or MarkerNumber"




(*REQUIRES AT LEAST 3 STUDIES*)

BeginPackage["pfit`","pfitmeta`", "pfitreg`","pfitplot`","pfitdata`"]

PFit::usage="PFit[dataset,showpoints]"


Options[PFit]= {ShowTables->False, ShowExtrapolation->False};


ShowTables::usage="True or False"
ShowExtrapolation::usage="True or False"


Clear[PFit]

Begin["Private`"]

PFit[dataset_,options___Rule]:=
Module[{ch,showtab,showextrap},
   ch=CheckInput[dataset];
   If[ch==True,
      {showtab,showextrap}={ShowTables,ShowExtrapolation}/.{options}/.Options[PFit];   
     PFitCore[dataset,showtab,showextrap]];
   Return[Null]]


PFitCore[dataset_,showtab_,showextrap_]:=
Module[{name,n0,e0,c0,n1,e1,c1, c01,c00,c10,c11, 
            dr,ser,fr,studyname0,data0,data,
           d,f,v,se,n,res,rowname,colname,hname,vname,dataname,
           resmatA,resmatR,aicvecA,aicvecR,resmat,aicvec,mat,len,
           df0,t0,t, resFE,resFEF,resRE,resREF,resLIN,resMOD},
  (*DATA*) 
  {data0,studyname0, dataname,hname,vname}=dataset;       
  len=Length[data0];

  If[showtab,
  Print["Table of Data"];
   Print["number of studies ",len];
   Print["n0 = number in control group"];
    Print["e0 = number receiving treatment in control group"];
    Print["c00 = number with outcome who received old treatment in control group"];
    Print["c01 = number with outcome who received new treatment in control group"];
    Print["c0 = number with outcome in control group"];
     Print["n1 = number in study group"];
     Print["e1 = number receiving treatment in study group"];
     Print["c10 = number with outcome who received old treatment in study group"];
     Print["c11 = number with outcome who received new treatment in study group"];
     Print["c1 = number with outcome in study group"];
    Print["DATA KEY: -1 is missing"];
    colnamex={"n0", "e0", "c00","c01","c0", "n1", "e1", "c10","c11","c1"};  
     tab=TableForm[data0,TableHeadings->{studyname0,colnamex}];
    Print[tab]];
    
  (*Select only those that satisfy assumptions*)
    {datax,studyname}=ModifyData[data0,studyname0];   
     {n0,e0,c00,c01,c0,n1,e1,c10,c11,c1}=Transpose@datax;
     data=Transpose[{n0,e0,c0,n1,e1,c1}];
    
     
(*BASIC PARAMETERS*)
   {n0,e0,c0,n1,e1,c1}=Transpose[data];
   (*TABLE OF ESTIMATES*)
   d=(c1/n1-c0/n0)//N;
    f=Abs@(e1/n1-e0/n0)//N;
     v=(c0/n0 (1-c0/n0)/n0 +  c1/n1 (1-c1/n1 )/n1)/f^2;
    se=Sqrt[v];
    n=n0+n1;
   dr=Round[d 1000]/1000//N;
   ser=Round[se 1000]/1000//N;
   fr=Round[f 1000]/1000//N;
   mat=Transpose[{studyname,n,dr,ser,fr}];
   colname={"study","total sample\nsize",  "difference in\n probabitly\nof outcome\nin compliers", "se of\ndifference\nof prob outcome\nin compliers",
   "difference in\nfraction\n treated"};


   If[showtab,
    Print["Table of estimates"];
     Print@TableForm[mat, TableHeadings->{None, colname}]];

(*PLOT BASIC*)
  mind=Min[d-1.96 se];
  maxd=Max[d+1.96 se];
  miny=Min@{-.2,mind-.02};
   maxy=Max@{.3, maxd +.02};

(*Print["Point size proportional to sample size"];
Print["Vertical lines are 95% confidence intervals\n(which depend on sample size and fraction receiving treatment)"];
*)
(*point size constant*)
   n=n0+n1;
k=.02/Max[Sqrt[n]];
  
(*CI T-Stat*)
(*use for standard random effects*)
   df0=Length[d]-1;
   t0=TStat025[df0];
   

 (*META ANALYSIS*)
    {resmatA,plotRAN,plotRANADJ,plotRANADJ2,aicvecA}=MetaAnalysis[d,se,t0,f,n,k,{studyname, hname,vname},{miny,maxy}];   
    {resFE,resFEF,resRE,resREF,resREF2}=resmatA;
      ExportPlot[dataname,"RAN",plotRAN];
      If[showextrap,
            ExportPlot[dataname,"RANADJ",plotRANADJ];
            ExportPlot[dataname,"RANADJ2",plotRANADJ2]];
      rownameA={"FLAT: fixed effect", "FLAT: fixed effect f", "FLAT: random effect", "FLAT: random effect f", "FLAT: random effect f^2"}; 
      TableFit[resmatA,aicvecA,rownameA];

 (*EXTRAPOLATION*) 
   If[showextrap,  
     {resmatR,plotvecR,aicvecR}=RegressSet[d,se,t0,f,n,k,{studyname,hname,vname},{miny,maxy}];
      {resLIN,resQUA,resSIG}=resmatR;
      {plotLIN,plotQUA,plotSIG}=plotvecR;
      {aicLIN,aicQUA,aicSIG}=aicvecR;
     ExportPlot[dataname,"LIN",plotLIN];
      ExportPlot[dataname,"QUA",plotQUA];
      ExportPlot[dataname,"SIG",plotSIG];
       rownameR={"LINEAR","QUADRATIC","SIGMOID"};
      TableFit[resmatR,aicvecR,rownameR]];

      
  Return[Null]]


TableFit[resmat_,aicvec_,rowname_]:=
Module[{resmatr,aicvecr,matx,colname},
      resmatr=Round[resmat 1000]/1000//N;
       aicvecr=Round[aicvec 10]/10//N;
       matx=HJoin[resmatr,Transpose[{aicvecr}]];
         colname={"est", "low","upp", "AIC"};
      Print[" "];
      Print["Estimated treatment effect in compliers\nwhen fraction receiving treatment =1"];
      Print@TableForm[matx,TableHeadings->{rowname,colname}];
Return[Null]]


ModifyData[data_,name_]:=
Module[{len,indevec0,indexgood,indexvad,databad,namebad,datagood,namegood},
len=Length[data];
indexvec0=Table[PosData[data,name,i],{i,1,len}];
indexgood=Select[indexvec0,(#>0)&];
datagood=data[[indexgood]];
namegood=name[[indexgood]];
indexbad=Complement[Range[len],indexgood];
If[Length[indexbad]>0,
 databad=data[[indexbad]];
 namebad=name[[indexbad]];
   Print["ASSUMPTIONS NOT HOLD FOR THESE STUDIES"];
  Print[namebad]];
Return[{datagood,namegood}]]



PosData[data_,name_,i_]:=
Module[{n0,e0,c0,n1,e1,c1, index,ch},
   {n0,e0,c00,c01,c0,n1,e1,c10,c11,c1}=data[[i]];
   (*indicator of other data*)
   ch=c00+c01+c10+c11;
  index=i;
  (*
   Print[name[[i]], "  outcome counts 00 01 10 11  ",{c00,c01,c10,c11}];
  *)
  If[ch=!=-4, f01=c01/n0;
                  f10=c10/n1;
                 f11=c11/n1;
                 f00=c00/n0;
                 b0=f00-f10//N;
                 b1=f11-f01//N;
                 Print["   full data ", name[[i]],"    b0 b1 ",{b0,b1}];
                 If[b0 >=0 || b1>=0,index=i, index=0]];
        Return[index]]


TStat025[df_]:=
Module[{tlist,tstat},
tlist={12.706, 4.303, 3.182, 2.776, 2.571,
       2.447, 2.365,    2.306, 2.262, 2.228,
       2.201,  2.179,  2.160, 2.145, 2.131,
       2.120,2.110,2.101,2.093,2.086,
       2.080,2.074,2.069,2.064,2.060};
 tstat=tlist[[df]];
Return[tstat]] 


HJoin[xA_,xB_]:=Transpose@Join[Transpose[xA],Transpose[xB]]

CheckInput[dataset_]:=
Module[{ch1,ch2,data0},
   ch1=CheckInput1[dataset];
   If[ch1==True,
      data0=dataset[[1]];
      ch2=CheckInput2[data0],
      ch1=False];
If[ch1 ==True || ch2==True, 
    ch=True,
    (*else*)
    Print["incorrect data format"];
     ch=False];  
 If[ch1==False,ch=False];    
  Return[ch]]
  

CheckInput1[dataset_]:=
Module[{ch1,len},
len=Length[dataset];
If[len==5,
   ch1=True,
   (*else*)
   Print["Invalid data format: not 5 components"];
   ch1=False];       
  Return[ch1]]
  

  CheckInput2[data0_]:=
  Module[{len0,ch2,nr,nc},
     {nr,nc}=Dimensions[data0];
     If[nc==10,
      ch2=CheckNumStudies[data0],
     (*else*)   
      Print["improper data format"];
       ch2=False];
  Return[ch2]]

  
  CheckNumStudies[data0_]:=
  Module[{name,ind,n0,e0,c00,c01,c0,n1,e1,c10,c11,c1,num,ch2},
       num=Length[data0];
        If[num>2, ch2==True, Print["less than 3 studies"]; ch2=False];
   Return[ch2]]
 
 
    ExportPlot[dataname_,name_,plot0_]:=
    Module[{plotmatname},
    plot=Show[plot0,ImageSize->Large];
      plotmatname=StringJoin["pfit",dataname,name,".jpg"];
    Print[plotmatname];
    Export[plotmatname,plot];
      Print@Show[plot,ImageSize->Large];
  Print["exporting ",plotmatname];
  Return[Null]]
 
  
End[]
EndPackage[]



Print["PFit[data]  requires at least three studies"]