(*:Mathematica:: Version 8 *)
(*:Stopext:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input*)


BeginPackage["overdiagstop`","overdiagformula`"]

GenSOFStop::usage="GenSOFStop[y,{mean, power, a, b,z}, ymax]"
GenSIOFStop::usage="GenSIOFStop[y,{mean, power, a, b,z}, ymax]"

Clear[GenSOFStop,GenSIOFStop]

Begin["Private`"]




GenSOFStop[y_,{mean0_,power0_,a0_,b0_,z0_},ymax_]:=
Module[{FC1, FS1,FD1,SOF1,
               FC2, FS2,FD2,SOF2,
               SOFvec,
               FC, FS,FD,SOF},
  {FC1, FS1,FD1,SOF1}=GenSOFStop1[{mean0,power0,a0,b0,z0}];
   {FCY, FSY,FDY,SOFY}=GenSOFStopY[y,{mean0,power0,a0,b0,z0}];
   SOF={SOF1} ~ Join~ Table[SOFY,{y,2, ymax}]//N;
  FC={FC1} ~Join~ Table[FCY,{y,2, ymax}]//N;
  FS={FS1} ~Join~ Table[FSY,{y,2, ymax}]//N;
  FD={FD1} ~Join~ Table[FDY,{y,2, ymax}]//N;
Return[{FC, FS,FD,SOF}]]


GenSOFStop1[{mean0_,power0_,a0_,b0_,z0_}]:=
Module[{h0,k0,set,fcontrol,fscreen1,finterva1l,FC,FS,FD,SOF,FCx,FSx,FDx},
  h0=1/mean0;
  set={power0,h0};
   fscreen1=    Screen[set,{0,a0},a0];
   finterval1=b0  IntervalC[set,{a0,a0+z0}]   + (1-b0) DelayedC[set,{0, a0},a0+z0];
  FC=ControlC[set,{0, a0},a0+z0];
  FS= fscreen1 + finterval1;
  FD=fscreen1;
 SOF= (FS-FC)/FD;
   k0=.001/(50^power0);
   FCx=k0 FC;
   FSx=k0 FS;
   FDx=k0 FD;
 Return[{FCx,FSx, FDx ,SOF}]]



GenSOFStopY[y_,{mean0_,power0_,a0_,b0_,z0_}]:=
Module[{h0,k0,set,Fcontrol,fscreen1,finterval1,fscreen2,finterval2,ffollow,FC,FS,FD,SOF,FCx,FSx,FDx},
    h0=1/mean0;
    set={power0,h0};
    fscreen1=b0  Screen[set,{0,a0},a0];
     fscreen2= b0   Screen[set,{a0,a0+z0},a0+z0] +    (1-b0)  Screen[set,{0,a0},a0+z0]//N;          
     finterval1=      IntervalC[set,{a0,a0+z0}]   +            (1-b0) DelayedC[set,{0, a0},a0+z0]//N;
     ffollow=          IntervalC[set,{a0+ z0, a0+y z0}] +      (1-b0) DelayedC[set,{a0, a0+z0}, a0 +y z0]//N;   
      FC= ControlC[set,{0, a0},a0+y z0];  
     FS= fscreen1 + finterval1+fscreen2+ffollow;
     FD=fscreen1+fscreen2;
      SOF= (FS-FC)/FD;
       k0=.001/(50^power0);
       FCx=k0 FC;
       FSx=k0 FS;
        FDx=k0 FD;  
     Return[{FCx,FSx, FDx,SOF}]]



(*------------------------------------------------------*)

GenSIOFStop[y_,{mean0_,power0_,a0_,b0_,z0_},ymax_]:=
Module[{FC1, FS1,FD1,SOF1,
               FC2, FS2,FD2,SOF2,
               SOFvec,
               FC, FS,FD,SOF},
  {FC1, FS1,FD1,SIOF1}=GenSIOFStop1[{mean0,power0,a0,b0,z0}];
   {FCY, FSY,FDY,SIOFY}=GenSIOFStopY[y,{mean0,power0,a0,b0,z0}];
   SIOF={SIOF1} ~ Join~ Table[SIOFY,{y,2, ymax}]//N;
  FC={FC1} ~Join~ Table[FCY,{y,2, ymax}]//N;
  FS={FS1} ~Join~ Table[FSY,{y,2, ymax}]//N;
  FD={FD1} ~Join~ Table[FDY,{y,2, ymax}]//N;
Return[{FC, FS,FD,SIOF}]]


GenSIOFStop1[{mean0_,power0_,a0_,b0_,z0_}]:=
Module[{h0,k0,set,fcontrol,fscreen1,finterva1l,FC,FS,FD,SOF,FCx,FSx,FDx,SIOF},
  h0=1/mean0;
  set={power0,h0};
   fscreen1=    Screen[set,{0,a0},a0];
   finterval1=b0  IntervalC[set,{a0,a0+z0}]   + (1-b0) DelayedC[set,{0, a0},a0+z0];
  FC=ControlC[set,{0, a0},a0+z0];
  FS= fscreen1 + finterval1;
  FD=fscreen1;
 SIOF= (FS-FC)/FS;
   k0=.001/(50^power0);
   FCx=k0 FC;
   FSx=k0 FS;
   FDx=k0 FD;
 Return[{FCx,FSx, FDx ,SIOF}]]



GenSIOFStopY[y_,{mean0_,power0_,a0_,b0_,z0_}]:=
Module[{h0,k0,set,Fcontrol,fscreen1,finterval1,fscreen2,finterval2,ffollow,FC,FS,FD,SOF,FCx,FSx,FDx},
    h0=1/mean0;
    set={power0,h0};
    fscreen1=b0  Screen[set,{0,a0},a0];
     fscreen2= b0   Screen[set,{a0,a0+z0},a0+z0] +    (1-b0)  Screen[set,{0,a0},a0+z0]//N;          
     finterval1=      IntervalC[set,{a0,a0+z0}]   +            (1-b0) DelayedC[set,{0, a0},a0+z0]//N;
     ffollow=          IntervalC[set,{a0+ z0, a0+y z0}] +      (1-b0) DelayedC[set,{a0, a0+z0}, a0 +y z0]//N;   
      FC= ControlC[set,{0, a0},a0+y z0];  
     FS= fscreen1 + finterval1+fscreen2+ffollow;
     FD=fscreen1+fscreen2;
      SIOF= (FS-FC)/FS;
       k0=.001/(50^power0);
       FCx=k0 FC;
       FSx=k0 FS;
        FDx=k0 FD;  
     Return[{FCx,FSx, FDx,SIOF}]]


End[] 
EndPackage[]

