(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input
GenSOFStop            overdiagstop.m
GenSOFCont  	  overdiagcont.m*)


BeginPackage["overdiagsoftimeplotcore`"]


PlotSOFTime::usage="OverDiagSim"

Clear[PlotSOFTime]

Begin["Private`"]






PlotSOFTime[resmat_,meanmat0_,power0_,a0_,b0_,ymax_,type_,scenario_]:=
Module[{len,ploSOFvec,vmax,key,pos0,mean0,topname,sidena,ticks,plotSOF,plotSOFx,modvec1,i},
  len=Length[meanmat0];
  plotSOFvec=Table[PlotSOF[resmat[[i]],meanmat0[[i]],ymax,type],{i,1, len}];
  (*for key*)
    vmax=.3;
  key=GenKey[meanmat0,ymax,vmax];
   modvec1=meanmat0[[1]];
  {pos0,mean0}=modvec1;
  powers=ToString[power0];
  bs=ToString[b0];
  as=ToString[a0];
  If[scenario==1,   topname=StringJoin["Power = ",powers,"   Sensitivity= ",bs]];
  If[scenario==2,   topname=StringJoin["Age =", as, "   Power = ",powers,"   Sensitivity= ",bs]];

  sidename=" ";
  If[type=="stop",numscreens=2];
   If[type=="cont",numscreens=ymax];

  ticks=GenFrameTicksSOF[numscreens,ymax];
  plotSOF=Show[Join[plotSOFvec,key], Frame->True, 
   LabelStyle->Directive[Black,Bold,Medium],
   PlotRange->{{1,ymax},{0 vmax,vmax}},
      FrameStyle->{Black, Bold}, FrameTicks->ticks,
      FrameLabel->{"Time since randomization", sidename, topname,None}];
   plotSOFx=Show[plotSOF, ImageSize->Large];
Return[plotSOFx]]



PlotSOF[{Fcontrol_,Fstudy_,Fdetect_,SOF_},{j_,mean0_},ymax_,type_]:=
Module[{style, plotSOF},
     style=GenStyle[j];
     vmax=Max[SOF];
         plotSOF=ListPlot[SOF,Joined->True, PlotRange->{{1,ymax},{-.15 vmax,vmax}},PlotStyle->style];
     Return[plotSOF]]
    



GenKey[modvec_,ymax_,vmax_]:= 
Flatten@(GenKeyOne[#,ymax,vmax]& /@ modvec)


GenKeyOne[{j_,mean0_},ymax_,vmax_]:=
Module[{name, text,line,vec},
j0=  vmax (.6+ j /10);
name=StringJoin["Mean lead time = ",ToString[mean0]];
style=GenStyle[j];
v0=.9 ymax;
v1=.98 ymax;
text=Graphics@{Text[name,{v0,   j0 },{1,0}]};
vec=style~ Join~ {Line[{{v0, j0 }, {v1, j0 }}]};

line=Graphics@vec; 
 Return[{text,line}]]
 

GenStyle[j_]:=
Module[{mod1,mod2,mod3,mod4,mean1,mean2,mean3,dash1,dash2,dash3},
dash1=Dashing[1];
dash2=Dashing[.02];
dash3=Dashing[.01];
If[j==1, style={Blue}];
If[j==2, style={Red,dash2}];
If[j==3, style={Green,dash3}];
Return[style]]


GenFrameTicksPair[numscreens_,ymax_]:=
Module[{tickS,ticksL,ticksbot,ticks},
          ticksS=GenTickS[#]& /@ Range[numscreens];
          ticksL=GenTickL[#]& /@  Drop[Range[ymax],numscreens];
          ticksbot=Join[ticksS,ticksL];
          ticksside={{0,"0%"},{.1,"10%"},{.2,"20%"},{.3,"30%"}};
          ticks={{None,None},{ticksbot,None}};          
      Return[ticks]]


GenFrameTicksSOF[numscreens_,ymax_]:=
Module[{tickS,ticksL,ticksbot,ticks},
          ticksS=GenTickS[#]& /@ Range[numscreens];
          ticksL=GenTickL[#]& /@  Drop[Range[ymax],numscreens];
          ticksbot=Join[ticksS,ticksL];
          ticksside={{0,"0%"},{.1,"10%"},{.2,"20%"},{.3,"30%"}};
          ticks={{ticksside,None},{ticksbot,None}};          
      Return[ticks]]
      
      
GenTickS[j_]:=
Module[{res,name,sred},
sred=Style["S",Red];
res={j,sred};
Return[res]]

GenTickL[j_]:=
Module[{res,name},
name=ToString[j];
res={j,name};
Return[res]]









End[] 
EndPackage[]

