(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input
PlotSOFTime                overdiagbiasplotcore.m
GenSOFStop            overdiagstop.m
GenSOFCont  	  overdiagcont.m*)


BeginPackage["overdiagsoftimeplot`","overdiagsoftimeplotcore`", 
"overdiagstop`","overdiagcont`", "overdiagpop`", "overdiagformula`"]

SOFTimePlotStop::usage="SOFTimePlotStop"
SOFTimePlotCont::usage="SOFTimePlotCont"
SIOFTimePlotPop::usage="SOFTimePlotPop"



Clear[SOFTimePlotStop,SOFTimePlotCont,SIOFTimePlotPop]




Begin["Private`"]


SOFTimePlotStop[y_,{a0_,z0_},show_]:=
Module[{ymax,k,modmat,plot}, 
  ymax=8;
 scenario=1;
  Print["age 50"];
   plotsofvec=SOFTimePlotKey[y,{ymax,50,z0},"stop",show,scenario];
   plotsofmat=Partition[plotsofvec,2];
   plotsof=Show[GraphicsGrid[plotsofmat],ImageSize->Large];  
Return[plotsof]]


SOFTimePlotCont[y_,{a0_,z0_},show_]:=
Module[{ymax,k,modmat,plot}, 
  ymax=6;
  scenario=1;
  Print["age 50"];
   plotsofvec=SOFTimePlotKey[y,{ymax,50,z0},"cont",show,scenario];
   plotsofmat=Partition[plotsofvec,2];
   plotsof=Show[GraphicsGrid[plotsofmat],ImageSize->Large];  
Return[plotsof]]



SIOFTimePlotPop[y_,{a0_,z0_},show_]:=
Module[{ymax,k,modmat,plot}, 
  ymax=6;
  scenario=1;
  Print["age 50"];
   plotsofvec=SOFTimePlotKey[y,{ymax,50,z0},"pop",show,scenario];
   plotsofmat=Partition[plotsofvec,2];
   plotsof=Show[GraphicsGrid[plotsofmat],ImageSize->Large];  
Return[plotsof]]



SOFTimePlotKey[y_,{ymax_,a0_,z0_},type_,show_,scenario_]:=
Module[{meanvec,bvec,paramat,parvec,plotset,plotpair1,plotpair2,plotpair3,plotsofvec, plotsofmat,plosof},
   powervec0={3,5};
   bvec0={.7, 1};
   parmat0=Outer[List,powervec0,bvec0];
   parvec0=Partition[Flatten[parmat0],2];
  plotsofvec= SOFTimePlotKeyOne[{y,ymax,a0,z0,type},#,scenario]& /@ parvec0;
  Return[plotsofvec]]





SOFTimePlotKeyOne[{y_,ymax_,a0_,z0_,type_},{power0_,b0_},scenario_]:=
Module[{meanmat,plotpair,plotsof},
 meanmat0=GenMeanVec[];
   If[type=="stop",  resmat=SOFTimePlotStopOne[#,y,ymax,{a0,power0,b0,z0}]& /@ meanmat0];
   If[type=="cont",  resmat=SOFTimePlotContOne[#,y,ymax,{a0,power0,b0,z0}]& /@ meanmat0];
    If[type=="pop",  resmat=SIOFTimePlotPopOne[#,y,ymax,{a0,power0,b0,z0}]& /@ meanmat0];
    plotsof=PlotSOFTime[resmat,meanmat0,power0,a0, b0,ymax,type,scenario];
 Return[plotsof]]


(*-------------------------------------------------------------------------------------------------------------*)

SOFTimePlotStopOne[{j_,mean0_},y_,ymax_,{a0_,power0_,b0_,z0_}]:=
Module[{resvec},
     resvec =GenSOFStop[y,{mean0,power0,a0,b0,z0},ymax];
  Return[resvec]]

SOFTimePlotContOne[{j_,mean0_},y_,ymax_,{a0_,power0_,b0_,z0_}]:=
Module[{resvec},
     resvec =GenSOFCont[y,{mean0,power0,a0,b0,z0},ymax];
 Return[resvec]]
   
SIOFTimePlotPopOne[{j_,mean0_},y_,ymax_,{a0_,power0_,b0_,z0_}]:=
Module[{resvec},
     resvec =GenSIOFPop[y,{mean0,power0,a0,b0,z0},ymax];
 Return[resvec]]


GenMeanVec[]:=
Module[{mod1,mod2,mod3,mod4,mean1,mean2,mean3,dash1,dash2,dash3},
mean1=.5;
mean2=1;
mean3=2;
mod1={1,mean1};
mod2={2,mean2};
mod3={3,mean3};
modmat={mod2,mod3};
Return[modmat]]


End[] 
EndPackage[]

