(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input
GenSOFStop 	           overdiagstop.m
GenSOFCont  	           overdiagcont.m
GenSIOFPop 	 	  overdiagcont.m*)


BeginPackage["overdiagsoftable`","overdiagstop`","overdiagcont`","overdiagformula`", "overdiagpop`"]

SOFModelTable::usage="SOFModelTable[y]"



Clear[SOFModelTable]




Begin["Private`"]


SOFModelTable[y_,interval_]:=
Module[{ymax,k,modmat,plot}, 
  ymax=8;
  (*last number is interval length*)
  If[interval ==1, time1=4; time2=6];
  If[interval ==2, time1=2; time2=3];
  
   mat1=OverDiagKeyTableOne[y,ymax,"stop",time1,interval];
   mat2=OverDiagKeyTableOne[y,ymax,"stop",time2,interval];
   mat3=OverDiagKeyTableOne[y,ymax,"cont",3,interval];
   mat4=OverDiagKeyTableOne[y,ymax,"pop",3,interval];
   mat=Join[mat1,mat2,mat3,mat4];
    name={"type","time", "age", "power", "sensitivity", "mean=.5", "mean=1", "mean=2"};
     headings={None,name};
     Print["interval length ",interval];
      tab=TableForm[mat,TableHeadings->headings];
  Print[tab];   
Return[Null]]




OverDiagKeyTableOne[y_,ymax_,type_,time_,z0_]:=
Module[{powervec0, bvec0,avec0, parmat0,parvec0,mat,name,headings,tab},
   avec0={45,55};
   powervec0={2,4};
   bvec0={.6, 1};
   parmat0=Outer[List,avec0, powervec0,bvec0];
  parvec0=Partition[Flatten[parmat0],3];
    mat= OverDiagKeyOne[{y,ymax,type},#,z0,time]& /@ parvec0;
  Return[mat]]





OverDiagKeyOne[{y_,ymax_,type_},{a0_,power0_,b0_},z0_,time_]:=
Module[{meanvec,res,SOFvecr,SOFvecs},
 meanvec={.5,1,2};
   If[type=="stop",  SOFvec=OverDiagStopOne[#,y,ymax,{a0,power0,b0},z0,time]& /@ meanvec];
   If[type=="cont",   SOFvec=OverDiagContOne[#,y,ymax,{a0,power0,b0},z0,time]& /@ meanvec];
    If[type=="pop",   SOFvec=OverDiagPopOne[#,y,ymax,{a0,power0,b0},z0,time]& /@ meanvec];
    types=StringJoin[type," ",ToString[z0]];
   SOFvecr=PaddedForm[#,2]& /@ (Round[SOFvec 100]);
   SOFvecs=StringJoin[ToString[#],"%"]& /@ SOFvecr;
   res=Join[{types,time, a0,power0,b0},SOFvecs];
  Return[ res]]


RoundX[x_]:=Round[x 1000]/10//N;


OverDiagStopOne[mean0_,y_,ymax_,{a0_,power0_,b0_},z0_,time_]:=
Module[{resvec,SOF},
   resvec =GenSOFStop[y,{mean0,power0,a0,b0,z0},ymax];
      SOFvec=resvec[[-1]]; 
 SOF=SOFvec[[time]];
 Return[SOF]]
  
OverDiagContOne[mean0_,y_,ymax_,{a0_,power0_,b0_},z0_,time_]:=
Module[{resvec,SOF},
     resvec =GenSOFCont[y,{mean0,power0,a0,b0,z0},ymax];
     SOFvec=resvec[[-1]]; 
 SOF=SOFvec[[time]];
 Return[SOF]]
   
OverDiagPopOne[mean0_,y_,ymax_,{a0_,power0_,b0_},z0_,time_]:=
Module[{resvec,SIOF},
     resvec =GenSIOFPop[y,{mean0,power0,a0,b0,z0},ymax];
     SIOFvec=resvec[[-1]]; 
 SIOF=SIOFvec[[time]];
 Return[SIOF]]
   



End[] 
EndPackage[]