(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input
GenSOFStop            overdiagstop.m
GenSOFCont  	        overdiagcont.m
GenSIOFPop		overdiagpop.m*)


BeginPackage["overdiagsofmodelplot`","overdiagstop`","overdiagcont`", "overdiagpop`", "overdiagformula`"]


SOFModelStop::usage="SOFModelStop"
SOFModelCont::usage="SOFModelStop"
SIOFModelPop::usage="SOFModelStop"
SIOFModelCross::usage="SIOFModelCross"

SOFModelSet::usage="SOFModelSet"

Clear[SOFModelStop,SOFModelCont,SIOFModelPop,SIOFModelCross,SOFModelSet]




Begin["Private`"]



SOFModelStop[y_,z0_:1]:=
Module[{plot4,plot6,plot},
If[z0==1, Print["ANNUAL SCREENS"]];
If[z0==2, Print["BIENNIAL SCREENS"]];
plot4=ModelPlotKey[{"stop4",z0},y,1];
plot6=ModelPlotKey[{"stop6",z0},y,1];
plot=Show[plot4,plot6,ImageSize->Large];
Return[plot]]


SIOFModelCross[y_,z0_:1]:=
Module[{plot4,plot6,plot},
If[z0==1, Print["ANNUAL SCREENS"]];
If[z0==2, Print["BIENNIAL SCREENS"]];
plot4=ModelPlotKey[{"cross4",z0},y,1];
plot6=ModelPlotKey[{"cross6",z0},y,1];
plot=Show[plot4,plot6,ImageSize->Large];
Return[plot]]




SOFModelCont[y_,z0_:1]:=
Module[{plot4,plot6,plot},
If[z0==1, Print["ANNUAL SCREENS"]];
If[z0==2, Print["BIENNIAL SCREENS"]];
plot4=ModelPlotKey[{"cont",z0},y,1];
plot=Show[plot4,ImageSize->Large];
Return[plot]]

SIOFModelPop[y_,z0_:1]:=
Module[{plot4,plot6,plot},
If[z0==1, Print["ANNUAL SCREENS"]];
If[z0==2, Print["BIENNIAL SCREENS"]];
plot4=ModelPlotKey[{"pop",z0},y,1];
plot=Show[plot4,ImageSize->Large];
Return[plot]]




ModelPlotKey[{type_,z0_},y_,scenario_,web_:0]:=
Module[{powerset,bset,aset,set,plotvec,plot,labelvec},
dash1=Dashing[{1,1}];
dash2=Dashing[{.03,.03}];
dash3=Dashing[{.08,.08}];


If[type=="stop6" || type=="stop4",
If[type=="stop4",
   If[web==0,  namevec={"Follow-up = 4 years,  Sensitivity= 0.5",  "Follow-up = 4 years,   Sensitivity= 1.0"}];
  If[web==1,  namevec={"T= 4, Sens= 0.5",  "T= 4, Sens=1.0"}];
  stylevec={{Red,dash1},{Red,dash2}}];
If[type=="stop6",
   If[web==0,namevec={"Follow-up = 6 years,   Sensitivity= 0.5","Follow-up = 6 years,   Sensitivity= 1.0"}];
   If[web==1,namevec={"T= 6, Sens= 0.5","T= 6, Sens= 1.0"}];
    stylevec={{Blue,dash1},{Blue,dash2}}];
  sidename="SOFM";
  If[scenario==1,
    avec={40};
    powervec={3}];
  If[scenario==2,
    avec={60};
    powervec={5}];
   bvec={1,.5}];
   
  
If[type=="cont" || type=="pop",
  sidename="SOF";
  If[web==0,
  ks2="Power=3,  ";
  ks4="Power=5,  ";
  namevec2=StringJoin[ks2,#]& /@ {"Age=40","Age=50","Age=60"};
  namevec4=StringJoin[ks4,#]& /@ {"Age=40","Age=50","Age=60"}];
  If[web==1,
    ks2="k=3,";
    ks4="k=5,";
    namevec2=StringJoin[ks2,#]& /@ {"a=40","a=50","a=60"};
    namevec4=StringJoin[ks4,#]& /@ {"a=40","a=50","a=60"}];  
    namevec=Join[namevec2,namevec4];
    stylevec={{dash1,Red},{dash1,Blue},{dash1, Darker[Green]},
                    {dash2,Red},{dash2,Blue},{dash2, Darker[Green]}          };
           powervec={3,5};
   If[scenario==1, bvec={.5}];
   If[scenario==2, bvec={1}]; 
   avec={60,50,40}];
  
 
  If[type=="cross6" || type=="cross4",
  If[type=="cross4",
     If[web==0,  namevec={"Follow-up = 4 years,  Sensitivity= 0.5",  "Follow-up = 4 years,   Sensitivity= 1.0"}];
    If[web==1,  namevec={"T= 4, Sens= 0.5",  "T= 4, Sens=1.0"}];
    stylevec={{Red,dash1},{Red,dash2}}];
  If[type=="cross6", 
     If[web==0,namevec={"Follow-up = 6 years,   Sensitivity= 0.5","Follow-up = 6 years,   Sensitivity= 1.0"}];
     If[web==1,namevec={"T= 6, Sens= 0.5","T= 6, Sens= 1.0"}];
      stylevec={{Blue,dash1},{Blue,dash2}}];
    sidename="SIOFM";
    If[scenario==1,
      avec={40};
      powervec={3}];
    If[scenario==2,
      avec={60};
      powervec={5}];
   bvec={1,.5}];
  

If[type=="cont",sidename="SOFM"];
If[type=="pop",sidename="SIOFM"];
If[type=="cross",sidename="SIOFM"];


(*SET OF PARAMETERS*)
set=Outer[List,powervec,bvec,avec];
mat=Partition[Flatten[set],3];
meanvec={.1,.5,1,1.5,2,2.5,3};
 sofvec=SOFModelPlotOne[meanvec,type,z0,y,#]& /@ mat;
plot=ListPlot[sofvec,Joined->True,PlotStyle->stylevec,PlotRange->{{.01, 3.1},{0,.25}}];

If[web==0,plotname=GenPlotName[type,z0]];
If[web==1,plotname=GenPlotNameWeb[type,z0,scenario]];
labelvec=GenLabelX[type,namevec,stylevec,web];
plotx=Show[plot,labelvec,Frame->True,FrameLabel->{"Mean lead time", sidename,plotname,None},LabelStyle->{Medium,Bold}];
Return[plotx]]









(*-------------------------------------------------------------------------------------------------------------*)


SOFModelPlotOne[meanvec_,type_,z0_,y_,{power0_,b0_,a0_}]:=
Module[{plotpair,plotsof},
   If[type=="stop4",  sofvec=SOFBiasPlotStop4X[#,y,6,{a0,power0,b0,z0}]& /@ meanvec];
    If[type=="stop6",  sofvec=SOFBiasPlotStop6X[#,y,8,{a0,power0,b0,z0}]& /@ meanvec];
    If[type=="cont",  sofvec=SOFBiasPlotContX[#,y,3,{a0,power0,b0,z0}]& /@ meanvec];
     If[type=="pop",  sofvec=SIOFBiasPlotPopX[#,y,3,{a0,power0,b0,z0}]& /@ meanvec];
      If[type=="pop",  sofvec=SIOFBiasPlotPopX[#,y,3,{a0,power0,b0,z0}]& /@ meanvec];
      If[type=="cross4",  sofvec=SIOFBiasPlotCross4X[#,y,6,{a0,power0,b0,z0}]& /@ meanvec];
      If[type=="cross6",  sofvec=SIOFBiasPlotCross6X[#,y,8,{a0,power0,b0,z0}]& /@ meanvec];
    
    pairvec=Transpose[{meanvec,sofvec}];
    Return[pairvec]]



SOFBiasPlotStop4X[mean_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=
          SOFBiasPlotStopOne[mean,y,ymax,{a0,power0,b0,z0}][[-1,4/z0]]   (*4/z0 is the time after randomization*)
SOFBiasPlotStop6X[mean_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=
       SOFBiasPlotStopOne[mean,y,ymax,{a0,power0,b0,z0}][[-1,6/z0]]
SOFBiasPlotContX[mean_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=SOFBiasPlotContOne[mean,y,ymax,{a0,power0,b0,z0}][[-1,3]]
SIOFBiasPlotPopX[mean_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=SIOFBiasPlotPopOne[mean,y,ymax,{a0,power0,b0,z0}][[-1,3]]
SIOFBiasPlotCross4X[mean_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=
       SIOFBiasPlotCrossOne[mean,y,ymax,{a0,power0,b0,z0}][[-1,4/z0]]
SIOFBiasPlotCross6X[mean_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=
   SIOFBiasPlotCrossOne[mean,y,ymax,{a0,power0,b0,z0}][[-1,6/z0]]



SOFBiasPlotStopOne[mean0_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=GenSOFStop[y,{mean0,power0,a0,b0,z0},ymax]
SOFBiasPlotContOne[mean0_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=GenSOFCont[y,{mean0,power0,a0,b0,z0},ymax]   
SIOFBiasPlotPopOne[mean0_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=GenSIOFPop[y,{mean0,power0,a0,b0,z0},ymax]
SIOFBiasPlotCrossOne[mean0_,y_,ymax_,{a0_,power0_,b0_,z0_}]:=GenSIOFStop[y,{mean0,power0,a0,b0,z0},ymax]



(*------------------------------------------------------------------------------------------*)

GenPlotName[type_,z0_]:=
Module[{plotname},
If[type=="cross4" || type=="cross6",plotname="Computation of SIOFM in a stop-screen analysis"];
If[type=="stop4" || type=="stop6",   plotname="Computation of SOFM in a stop-screen analysis"];
If[type=="cont",                              plotname="Computation of SOFM in a continued-screen analysis"];
If[type=="pop",                               plotname="Computation of SIOFM in a population-screen analysis"];
Return[plotname]]


GenPlotNameWeb[type_,z0_,scenario_]:=
Module[{plotname,ss,plotnamex},
If[type=="cross4" || type=="cross6",plotname="cross-section"];
If[type=="stop4" || type=="stop6",plotname="stop-screen"];
If[type=="cont",                            plotname="continued-screen"];
If[type=="pop",                             plotname="population-screen"];
ss=ToString[scenario];
plotnamex=StringJoin["Set ",ss, ": ",plotname];
Return[plotnamex]]


GenLabelX[type_,namevec_,stylevec_,web_]:=
Module[{len,range,set,resvec,res},
len=Length[namevec];
range=Range[len];
set=Transpose[{namevec,stylevec,range}];
resvec=GenLabelOneX[type,#,len,web]& /@set;
res=Flatten[resvec];
Return[res]]

GenLabelOneX[type_,{name_,style_,j_},len_,web_]:=
Module[{x0,x1,int,y,label,line,color,dash},
If[web==0, x0=.7];
If[web==1,x0=.9];
If[type=="stop4" || type=="stop6",
If[web==0, x0=1.1];
If[web==1, x0=1.3]];
If[type=="cross4" || type=="cross6",
If[web==0, x0=1.1];
If[web==1, x0=1.3]];
x1=x0+.05;
x2=x1+.3;
If[len==2, y=.24 +.02  (j-1)];
If[len==6, y=.10 + .02 (j-1)];
If[len==12,y=.04+ .01(j-1)];
If[type=="stop4", y=.18+.02(j-1)];
If[type=="stop6", y=.14+.02(j-1)];
If[type=="cross4", y=.18+.02(j-1)];
If[type=="cross6", y=.14+.02(j-1)];
{color,dash}=style;
label=Graphics@Text[name,{x0,y},{1,0}];
line=Graphics@{color,dash,Line[{{x1,y},{x2,y}}]};
Return[{label,line}]]

SOFModelSet[y_,z0_:1]:=
Module[{plot4,plot6,plot,plotmat,plotS1,plotS2,plotC1,plotC2,plotP1,plotP2},
If[z0==1, Print["ANNUAL SCREENS"]];
If[z0==2, Print["BIENNIAL SCREENS"]];
Print["Stop screen Age 40 Power 3 set =1"];
Print["Stop screen Age 60 Power 5 set =2"];
Print["Cont/Pop screen Sen=.5  set =1"];
Print["Cont/Pop screen Sens=1 set =2"];

web=1;
(*stop*)
plot41=ModelPlotKey[{"stop4",z0},y,1,web];
plot61=ModelPlotKey[{"stop6",z0},y,1,web];
plotS1=Show[plot41,plot61,ImageSize->Large];
plot42=ModelPlotKey[{"stop4",z0},y,2,web];
plot62=ModelPlotKey[{"stop6",z0},y,2,web];
plotS2=Show[plot42,plot62,ImageSize->Large];
(*cont*)
plotC1=ModelPlotKey[{"cont",z0},y,1,web];
plotC2=ModelPlotKey[{"cont",z0},y,2,web];
(*pop*)
plotP1=ModelPlotKey[{"pop",z0},y,1,web];
plotP2=ModelPlotKey[{"pop",z0},y,2,web];
plotmat={{plotS1,plotS2},{plotC1,plotC2},{plotP1,plotP2}};
plot=Show[GraphicsGrid[plotmat],ImageSize->Large];
Return[plot]]






End[] 
EndPackage[]
