(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input*)



BeginPackage["overdiagleadtimecore`","overdiagformula`"]

GenLikSym::usage="GenLikSym"
GenParameterSet::usage="GenParameterSet"



Clear[GenLikSym,GenParameterSet,GenLikSym2]

Begin["Private`"]

GenParameterSet[age0_]:=
Module[{agevec0,powervec0,bvec0,setvec,set},
agevec0={age0};
powervec0={3,5};
bvec0={.5,.8,1};
Print["power for age ", powervec0];
Print["sensitivity ",bvec0];
setvec=Outer[List,agevec0,powervec0,bvec0];
set=Partition[Flatten[setvec],3];
Return[set]]



GenLikSym[{a0_,power0_,b0_},m_,z0_,k0_,data_]:=
Module[{probvec0,probvec,liksum,lik0,m0,mL,mR,rule,ymax},
ymax=Length[data];
probvec0= GenProb[{a0,power0,b0},m,z0,k0,ymax];
probvec=probvec0/Total[probvec0];
liksym=Total[data Log[probvec]];
Return[liksym]]


GenProb[{a0_,power0_,b0_},m_,z0_,k0_,ymax_]:=
Module[{fL1, fLY, fL,y},
  fL1=GenProbF[{a0,power0,b0},m,z0,k0];
  fLY=GenProbY[{a0,power0,b0},m,z0,k0,y];
  fL={fL1} ~ Join~ Table[fLY,{y,2, ymax}];
   Return[fL]]



GenProbF[{a0_,power0_,b0_},m_,z0_,k0_]:=
Module[{h0,set,finterval},
   h0=1/m;
   set={power0,h0};
   finterval=  IntervalC[set,{a0,a0+z0}] + (1-b0) DelayedC[set,{a0-k0, a0},a0+z0];
 Return[finterval]]



GenProbY[{a0_,power0_,b0_},m_,z0_,k0_,y_]:=
Module[{h0,set,finterval},
    h0=1/m;
    set={power0,h0};
   finterval= ControlC[set,{a0, a0+(y-1) z0},  a0+y z0] +  (1-b0) LagC[set,{a0-k0, a0}, {a0+(y-1) z0 ,  a0+y z0}];
 Return[finterval]]



GenLikSymControl[{a0_,power0_,b0_},m_,z0_,k0_,data_]:=
Module[{probvec0,probvec,liksum,lik0,m0,mL,mR,rule,ymax},
ymax=Length[data];
probvec0= GenProbControl[{a0,power0,b0},m,z0,k0,ymax];
probvec=probvec0/Total[probvec0];
liksym=Total[data Log[probvec]];
Return[liksym]]


GenProbControl[{a0_,power0_,b0_},m_,z0_,k0_,ymax_]:=
Module[{fL1, fLY, fL,y},
   fLY=GenProbControlY[{a0,power0,b0},m,z0,k0,y];
  fL={fL1} ~ Join~ Table[fLY,{y,2, ymax}];
   Return[fL]]





GenProbControlY[{a0_,power0_,b0_},m_,z0_,k0_,y_]:=
Module[{h0,set,finterval},
    h0=1/m;
    set={power0,h0};
   finterval= ControlC[set,{0, a0+(y-1) z0},  a0+y z0];
 Return[finterval]]

End[] 
EndPackage[]


