(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input
GenLikSym  overdiagleadtimecore.m*)



BeginPackage["overdiagleadtimeboot`","overdiagleadtimecore`","overdiagformula`"]


MeanLeadTimeBoot::usage="MeanLeadTimeBoot"



Clear[MeanLeadTimeBoot]


Begin["Private`"]


MeanLeadTimeBoot[data_,m_,newfitQ_,maxboot_,method_]:=
Module[{data0,dataname,z0,k0,age0,parset,estvec0,mvec0,mvecr,maxboots,z0s,storednameM,matM},
  {data0,dataname,z0,k0,age0}=data;
parset=GenParameterSet[age0];
(*ESTIMATE*)
estvec0=OFit0[#,m,z0,k0,data0]& /@ parset;
(*BOOSTRAP*)
maxboots=ToString[maxboot];
z0s=ToString[z0];
age0s=ToString[age0];
k0s=ToString[k0];
storednameM=StringJoin["overX",dataname,age0s,z0s,k0s,maxboots,".m"];
   If[newfitQ==True,
      matM=OFitB[#,m,z0,k0,data0,maxboot]& /@ parset;
       Print["Export ",storednameM];
        Export[storednameM,matM]];
   If[newfitQ==False,
      Print["import stored data ", storednameM];
    matM=Quiet@Drop[ReadList[storednameM],1][[1]]];
(*RESULT COMBINES ESTIMATE AND BOOTSTRAP*)
   mat=GenBootMat[dataname,matM,parset,estvec0,method];
 Return[mat]]
 
 

OFit0[{a0_,power0_,b0_},m_,z0_,k0_,data0_]:=
Module[{probvec0,probvec,liksum,lik0,m0,mL,mR,rule,ymax},
liksym=GenLikSym[{a0,power0,b0},m,z0,k0,data0];
{lik0,rule}=Quiet@FindMaximum[liksym, {m, .1}];
m0=Replace[m,rule];
Return[m0]]




OFitB[set_,m_,z0_,k0_,data0_,maxboot_]:=
Module[{mvec,j},
mvec=Table[OFitB0[set,m,z0,k0,data0],{j,1,maxboot}];
Return[mvec]]

OFitB0[set_,m_,z0_,k0_,data0_]:=
Module[{data0R,dsum,pvec0,m0},
dsum=Total[data0];
pvec0=data0/dsum//N;
data0R=RandomVariate[MultinomialDistribution[dsum,pvec0]];
m0=OFit0[set,m,z0,k0,data0R];
Return[m0]]



GenBootMat[dataname_,matM_,parset_,estvec_,method_]:=
Module[{bootvec,mean,se,mlow03,mlow05,mupp95,mupp97,age, power, b0,len,range,mat,m70,m80,m90,m95,i},
    If[method==1, Print["simple bootstrap"];                bootvec=Boot[matM]]; 
    If[method==2, Print["bias-corrected bootstrap"];    bootvec=BootBC[matM,estvec]]; 
      {mean,se,m025,m975}=bootvec; 
    {age,power,b0}=Transpose[parset]; 
    len=Length[age];
    namevec=Table[dataname,{i,len}];
    estvecr=Round[estvec 100]/100//N;
   mat=Transpose@{namevec,age,power,b0,estvecr,m025,m975};
  Return[mat]]



BootBC[mat_,estvec_]:=
Module[{mat1,res,len},
len=Length[estvec];
mat1=Table[BootVecBC[mat[[i]],estvec[[i]]],{i,1,len}];
res=Transpose[mat1];
Return[res]]



BootVecBC[fvec_,est_]:=
Module[{f0,varf0,varg0,g0,lowf0,uppf0,sef0,resf,p1,b1,Q1,p0,b0,Q0,B,fvecs},
 f0=Mean[fvec];
  varf0=Variance[fvec];
  sef0=Sqrt[varf0];
  B=Length[fvec];
(*lower*)
vec0=Select[fvec, (#>est)&];
  p0=Length[vec0];
  b0=InvCDF[p0/B];
  Q0=(B+1) CDFNormal01[2 b0  -1.96];
  Q0R=Ceiling[Q0];
 (*upper*)
 vec1=Select[fvec, (#<est)&];
 p1=Length[vec1];
 p1=p0;
  b1=InvCDF[p1/B]//N;
 Q1=(B+1) CDFNormal01[2 b1 +1.96];
 Q1R=Floor[Q1];
(*percentiles*)
 fvecs=Sort[fvec];
lowf0=fvecs[[Q0R]];
uppf0=fvecs[[Q1R]];
resf={f0,sef0,lowf0,uppf0}//N;
 Return[resf]]

CDFNormal[mu_,sigma_,x_]:=N[(Erf[(x-mu)/(Sqrt[2] sigma)] + 1) / 2]

 CDFNormal01[x_]:=CDFNormal[0,1,x]

 pValue[x_]:= 1-CDF[Abs[x]]
 
 
 InverseNormal[mu_, sigma_, z_]:= mu + Sqrt[2] sigma InverseErf[2 z - 1]
 
 InvCDF[alpha_]:= InverseNormal[0,1,alpha]
 
 
 

 Boot[mat_]:=
 Module[{mat1,res},
 mat1=BootVec[#]& /@ mat;
 res=Transpose[mat1];
 Return[res]]
 
 
 BootVec[vec_]:=
 Module[{mean,se,mlow,mupp,m025,m80,m95,m975},
 mean=Mean[vec];
 se=Sqrt@Variance[vec];
 qvec=Quantile[vec,{0.025,.80,0.95,.975}];
 {m025, m80,m95,m975}=Round[qvec 100]/100//N;
 Return[{mean,se,m025,m975}]]

 
End[] 
EndPackage[]


