(*Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input*)
(* MeanLeadTimeBoot  overdiagleadtimeboot.m*)


BeginPackage["overdiagleadtime`","overdiagleadtimeboot`","overdiagleadtimecore`",
"overdiagformula`"]



MeanLeadTimeX::usage="MeanLeadTimeX"


Clear[MeanLeadTimeX]



Begin["Private`"]


MeanLeadTimeX[datavec_,m_,newfitQ_,maxboot_]:=
Module[{matset,mat,colname,tab},
Print["number of bootstraps = ",maxboot];
Print["naive bootstrap"];         
     matset=MeanLeadTimeCore[#,m,newfitQ,maxboot,1]& /@ {datavec};
   mat=Join[Flatten[matset,1]];
   colname={"data","age","power","sens=.5","sens=.8", "sens=1"};
    tab=TableForm[mat, TableHeadings->{None,colname}];
    Print[tab];
Print["BC bootstrap"];
     matset=MeanLeadTimeCore[#,m,newfitQ,maxboot,2]& /@ {datavec};
     mat=Join[Flatten[matset,1]];
   colname={"data","age","power","sens=.5","sens=.8", "sens=1"};
    tab=TableForm[mat, TableHeadings->{None,colname}];
    Print[tab];
Return[Null]]



  
MeanLeadTimeCore[data_,m_,newfitQ_,maxboot_,method_]:=
Module[{mat,matx},
  If[newfitQ==True, Print[data," maxboot=",maxboot]];
   mat=MeanLeadTimeBoot[data,m,newfitQ,maxboot,method];
   matx=FormatPivotMat[mat];
 Return[matx]]


(*Format output*)

FormatPivotMat[mat_]:=
Module[{res1,res2,res3,res4,res5,res6,res1x,res2x,res3x,res4x,res5x,res6x,row1,row2,matx},
{res1,res2,res3,res4,res5,res6}=FormatPivotVec[#]& /@mat;
{res1x,res2x,res3x,res4x,res5x,res6x}=FormatPivotVecName[#]& /@mat;
row1=Join[res1x,{res1,res2,res2}];
row2=Join[res4x,{res4,res5,res6}];
matx={row1,row2};
Return[matx]]


FormatPivotVec[vec_]:=
Module[{name,age,power,sens,est,upp,estr,uppr,ests,upps,res,low0,upp0},
{name,age,power,sens,est,low,upp}=vec;
estr=Round[est 100]/100//N;
lowr=Round[low 100]/100//N;
uppr=Round[upp 100]/100//N;
estr=PaddedForm[est,{3,2}];
uppr=PaddedForm[upp,{3,2}];
ests=ToString[estr];
lows=ToString[lowr];
upps=ToString[uppr];
res=StringJoin[ests," (",lows," , ", upps,")"];
Return[res]]


FormatPivotVecName[vec_]:=
Module[{name,age,power,sens,est,upp,estr,uppr,ests,upps,res},
{name,age,power,sens,est,low,upp}=vec;
res={name,age,power};
Return[res]]






End[] 
EndPackage[]





