(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2019*)
(*Input*)


BeginPackage["overdiagformula`"]

IntervalC::usage="Interval"
DelayedC::usage="DelayedC"
ControlC::usage="ControlC"
Screen::usage="Screen"
LagC::usage="LagC"

Clear[IntervalC,ControlC, DelayedC,LagC,Screen]

Begin["Private`"]



w[x_,power_]:= x^power
Q[t_,h_]:= Exp[-h t]

(*
ControlC[{x_,power0_,h0_},{alow_,aupp_},afinal_]:=
   Integrate[w[x,power0] (1-Q[afinal-x,h0]), {x,alow, afinal}] - Integrate[w[x,power0] (1-Q[aupp-x,h0]), {x, alow, aupp}];  
   
  
  DelayedC[{x_,power0_,h0_},{alow_,aupp_},afinal_]:=
     Integrate[w[x,power0] (1-Q[afinal-x,h0]), {x,alow, aupp}] - Integrate[w[x,power0] (1-Q[aupp-x,h0]), {x, alow, aupp}];  
   
   
  IntervalC[{x_,power0_,h0_},{alow_,aupp_}]:=
   Integrate[w[x,power0] (1-Q[aupp-x,h0]), {x,alow, aupp}]    

Screen[{x_,power0_,h0_},{alow_,aupp_},afinal_]:=
   Integrate[w[x,power0]    Q[afinal-x,h0],            {x, alow, aupp}];

LagC[{x_,power0_,h0_},{alow_,aupp_},{afin1_,afin2_}]:=
   Integrate[w[x,power0] (1-Q[afin2-x,h0]), {x,alow, aupp}] - Integrate[w[x,power0] (1-Q[afin1-x,h0]), {x, alow, aupp}];  
   *)


DelayedC[{power0_,h0_},{alow_,aupp_},afinal_]:=
Module[{res},
   If[power0==2,
   res=(alow^3 - aupp^3 + (3*(2 + aupp*h0*(-2 + aupp*h0) - E^((alow - aupp)*h0)*(2 + alow*h0*(-2 + alow*h0))))/h0^3)/3 + 
 (-alow^3 + aupp^3 - (3*(-(E^((-afinal + alow)*h0)*(2 + alow*h0*(-2 + alow*h0))) + 
      E^((-afinal + aupp)*h0)*(2 + aupp*h0*(-2 + aupp*h0))))/h0^3)/3];
   If[power0==3,
   res=(alow^4 - aupp^4 + (4*(-6 + aupp*h0*(6 + aupp*h0*(-3 + aupp*h0)) + E^((alow - aupp)*h0)*
       (6 - alow*h0*(6 + alow*h0*(-3 + alow*h0)))))/h0^4)/4 + 
 (-alow^4 + aupp^4 - (4*(E^((-afinal + alow)*h0)*(6 - alow*h0*(6 + alow*h0*(-3 + alow*h0))) + 
      E^((-afinal + aupp)*h0)*(-6 + aupp*h0*(6 + aupp*h0*(-3 + aupp*h0)))))/h0^4)/4];
    If[power0==4,
    res=(alow^5 - aupp^5 + (5*(24 + aupp*h0*(-24 + aupp*h0*(12 + aupp*h0*(-4 + aupp*h0))) - 
      E^((alow - aupp)*h0)*(24 + alow*h0*(-24 + alow*h0*(12 + alow*h0*(-4 + alow*h0))))))/h0^5)/5 + 
 (-alow^5 + aupp^5 - (5*(-(E^((-afinal + alow)*h0)*(24 + alow*h0*(-24 + alow*h0*(12 + alow*h0*(-4 + alow*h0))))) + 
      E^((-afinal + aupp)*h0)*(24 + aupp*h0*(-24 + aupp*h0*(12 + aupp*h0*(-4 + aupp*h0))))))/h0^5)/5];
   If[power0==5,
 res=  (alow^6 - aupp^6 + (6*(-120 + aupp*h0*(120 + aupp*h0*(-60 + aupp*h0*(20 + aupp*h0*(-5 + aupp*h0)))) + 
         E^((alow - aupp)*h0)*(120 - alow*h0*(120 + alow*h0*(-60 + alow*h0*(20 + alow*h0*(-5 + alow*h0)))))))/h0^6)/6 + 
    (-alow^6 + aupp^6 - 
      (6*(E^((-afinal + alow)*h0)*(120 - alow*h0*(120 + alow*h0*(-60 + alow*h0*(20 + alow*h0*(-5 + alow*h0))))) + 
      E^((-afinal + aupp)*h0)*(-120 + aupp*h0*(120 + aupp*h0*(-60 + aupp*h0*(20 + aupp*h0*(-5 + aupp*h0)))))))/h0^6)/6];
 Return[res]]  
   

Screen[{power0_,h0_},{alow_,aupp_},afinal_]:=
Module[{res},

   If[power0==2,
res=  (-(E^((-afinal + alow)*h0)*
       (2 + alow*h0*(-2 + alow*h0))) + 
     E^((-afinal + aupp)*h0)*
   (2 + aupp*h0*(-2 + aupp*h0)))/h0^3];
   
If[power0==3,   
  res= (E^((-afinal + alow)*h0)*
      (6 - alow*h0*(6 + alow*h0*(-3 + alow*h0))) + 
     E^((-afinal + aupp)*h0)*
   (-6 + aupp*h0*(6 + aupp*h0*(-3 + aupp*h0))))/h0^4];

If[power0==4,
res=(-(E^((-afinal + alow)*h0)*
    (24 + alow*h0*(-24 + alow*h0*
        (12 + alow*h0*(-4 + alow*h0))))) + 
  E^((-afinal + aupp)*h0)*
   (24 + aupp*h0*(-24 + aupp*h0*
       (12 + aupp*h0*(-4 + aupp*h0)))))/h0^5];

If[power0==5,    
  res= (E^((-afinal + alow)*h0)*
          (120 - alow*h0*(120 + alow*h0*
              (-60 + alow*h0*(20 + alow*h0*
                  (-5 + alow*h0))))) + 
         E^((-afinal + aupp)*h0)*
          (-120 + aupp*h0*(120 + aupp*h0*
              (-60 + aupp*h0*(20 + aupp*h0*
           (-5 + aupp*h0))))))/h0^6];
     Return[res]]
   

ControlC[{power0_,h0_},{alow_,aupp_},afinal_]:=
Module[{res},

If[power0==2,
res =
(afinal^3 - alow^3 - (3*(2 + afinal*h0*(-2 + afinal*h0) - E^((-afinal + alow)*h0)*(2 + alow*h0*(-2 + alow*h0))))/h0^3)/3 + 
 (alow^3 - aupp^3 + (3*(2 + aupp*h0*(-2 + aupp*h0) - E^((alow - aupp)*h0)*(2 + alow*h0*(-2 + alow*h0))))/h0^3)/3];
       
If[power0==3,
res=(afinal^4 - alow^4 - (4*(-6 + afinal*h0*(6 + afinal*h0*(-3 + afinal*h0)) + E^((-afinal + alow)*h0)*
       (6 - alow*h0*(6 + alow*h0*(-3 + alow*h0)))))/h0^4)/4 + 
 (alow^4 - aupp^4 + (4*(-6 + aupp*h0*(6 + aupp*h0*(-3 + aupp*h0)) + E^((alow - aupp)*h0)*
       (6 - alow*h0*(6 + alow*h0*(-3 + alow*h0)))))/h0^4)/4];

If[power0==4,    
res=(afinal^5 - alow^5 - (5*(24 + afinal*h0*(-24 + afinal*h0*(12 + afinal*h0*(-4 + afinal*h0))) - 
      E^((-afinal + alow)*h0)*(24 + alow*h0*(-24 + alow*h0*(12 + alow*h0*(-4 + alow*h0))))))/h0^5)/5 + 
 (alow^5 - aupp^5 + (5*(24 + aupp*h0*(-24 + aupp*h0*(12 + aupp*h0*(-4 + aupp*h0))) - 
      E^((alow - aupp)*h0)*(24 + alow*h0*(-24 + alow*h0*(12 + alow*h0*(-4 + alow*h0))))))/h0^5)/5];
           
If[power0==5,
        res=   (afinal^6 - alow^6 - (6*(-120 + afinal*h0*(120 + afinal*h0*(-60 + afinal*h0*(20 + afinal*h0*(-5 + afinal*h0)))) + 
      E^((-afinal + alow)*h0)*(120 - alow*h0*(120 + alow*h0*(-60 + alow*h0*(20 + alow*h0*(-5 + alow*h0)))))))/h0^6)/6 + 
 (alow^6 - aupp^6 + (6*(-120 + aupp*h0*(120 + aupp*h0*(-60 + aupp*h0*(20 + aupp*h0*(-5 + aupp*h0)))) + 
      E^((alow - aupp)*h0)*(120 - alow*h0*(120 + alow*h0*(-60 + alow*h0*(20 + alow*h0*(-5 + alow*h0)))))))/h0^6)/6];
     Return[ res]]
     


IntervalC[{power0_,h0_},{alow_,aupp_}]:=
Module[{res},

If[power0==2,
res= (-alow^3 + aupp^3 - (3*(2 + aupp*h0*(-2 + aupp*h0) - E^((alow - aupp)*h0)*(2 + alow*h0*(-2 + alow*h0))))/h0^3)/3];

If[power0==3,
res=(-alow^4 + aupp^4 - (4*(-6 + aupp*h0*(6 + aupp*h0*(-3 + aupp*h0)) + E^((alow - aupp)*h0)*
      (6 - alow*h0*(6 + alow*h0*(-3 + alow*h0)))))/h0^4)/4];

If[power0==4,
  res=(-alow^5 + aupp^5 - (5*(24 + aupp*h0*(-24 + aupp*h0*(12 + aupp*h0*(-4 + aupp*h0))) - 
     E^((alow - aupp)*h0)*(24 + alow*h0*(-24 + alow*h0*(12 + alow*h0*(-4 + alow*h0))))))/h0^5)/5];

 If[power0==5,
res=(-alow^6 + aupp^6 - (6*(-120 + aupp*h0*(120 + aupp*h0*(-60 + aupp*h0*(20 + aupp*h0*(-5 + aupp*h0)))) + 
     E^((alow - aupp)*h0)*(120 - alow*h0*(120 + alow*h0*(-60 + alow*h0*(20 + alow*h0*(-5 + alow*h0)))))))/h0^6)/6];

Return[res]]
     
     
  
     LagC[{power0_,h0_},{alow_,aupp_},{afin1_,afin2_}]:=
     Module[{res},

        If[power0==2,
    res=(alow^3 - aupp^3 + 
   (3*(-(E^((-afin1 + alow)*h0)*
        (2 + alow*h0*(-2 + alow*h0))) + 
      E^((-afin1 + aupp)*h0)*
       (2 + aupp*h0*(-2 + aupp*h0))))/h0^3)/3 + 
 (-alow^3 + aupp^3 - 
   (3*(-(E^((-afin2 + alow)*h0)*
        (2 + alow*h0*(-2 + alow*h0))) + 
      E^((-afin2 + aupp)*h0)*
       (2 + aupp*h0*(-2 + aupp*h0))))/h0^3)/3];
       
        If[power0==3,
        res=(alow^4 - aupp^4 + 
   (4*(E^((-afin1 + alow)*h0)*
       (6 - alow*h0*(6 + alow*h0*(-3 + alow*h0))) + 
      E^((-afin1 + aupp)*h0)*
       (-6 + aupp*h0*(6 + aupp*h0*(-3 + aupp*h0)))))/
    h0^4)/4 + (-alow^4 + aupp^4 - 
   (4*(E^((-afin2 + alow)*h0)*
       (6 - alow*h0*(6 + alow*h0*(-3 + alow*h0))) + 
      E^((-afin2 + aupp)*h0)*
       (-6 + aupp*h0*(6 + aupp*h0*(-3 + aupp*h0)))))/
    h0^4)/4];
    
    
      If[power0==4,
          res= (alow^5 - aupp^5 + 
   (5*(-(E^((-afin1 + alow)*h0)*
        (24 + alow*h0*(-24 + alow*h0*(12 + 
             alow*h0*(-4 + alow*h0))))) + 
      E^((-afin1 + aupp)*h0)*
       (24 + aupp*h0*(-24 + aupp*h0*
           (12 + aupp*h0*(-4 + aupp*h0))))))/h0^5)/5 + 
 (-alow^5 + aupp^5 - 
   (5*(-(E^((-afin2 + alow)*h0)*
        (24 + alow*h0*(-24 + alow*h0*(12 + 
             alow*h0*(-4 + alow*h0))))) + 
      E^((-afin2 + aupp)*h0)*
       (24 + aupp*h0*(-24 + aupp*h0*
           (12 + aupp*h0*(-4 + aupp*h0))))))/h0^5)/5];
           
     
        If[power0==5,
      res=  (alow^6 - aupp^6 + 
   (6*(E^((-afin1 + alow)*h0)*(120 - 
        alow*h0*(120 + alow*h0*(-60 + alow*h0*
             (20 + alow*h0*(-5 + alow*h0))))) + 
      E^((-afin1 + aupp)*h0)*(-120 + 
        aupp*h0*(120 + aupp*h0*(-60 + aupp*h0*
             (20 + aupp*h0*(-5 + aupp*h0)))))))/h0^6)/
  6 + (-alow^6 + aupp^6 - 
   (6*(E^((-afin2 + alow)*h0)*(120 - 
        alow*h0*(120 + alow*h0*(-60 + alow*h0*
             (20 + alow*h0*(-5 + alow*h0))))) + 
      E^((-afin2 + aupp)*h0)*(-120 + 
        aupp*h0*(120 + aupp*h0*(-60 + aupp*h0*
             (20 + aupp*h0*(-5 + aupp*h0)))))))/h0^6)/6];
      Return[res]]  

     
     
     
End[] 
EndPackage[]

