(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2018*)
(*Input*)


BeginPackage["overdiagcont`","overdiagformula`"]

GenSOFCont::usage="GenSOFCont"


Clear[GenSOFCont]

Begin["Private`"]




GenSOFCont[y_,{mean0_,power0_,a0_,b0_,z0_},ymax_]:=
Module[{fC1, fS1,fD1,SOF1,
               fC2, fS2,fD2,SOF2,
               SOFvec,
               fC, fS,fD,SOF},
  {fC1, fS1,fD1,SOF1}=GenSOFCont1[{mean0,power0,a0,b0,z0}];
  {fC2, fS2,fD2,SOF2}=GenSOFCont2[{mean0,power0,a0,b0,z0}];
  {fCY, fSY,fDY,SOFY}=GenSOFContY[y,{mean0,power0,a0,b0,z0}];
  SOF={SOF1,SOF2} ~ Join~ Table[SOFY,{y,3, ymax}]//N;
  fC={fC1,fC2} ~Join~ Table[fCY,{y,3, ymax}]//N;
  fS={fS1,fS2} ~Join~ Table[fSY,{y,3, ymax}]//N;
  fD={fD1,fD2} ~Join~ Table[fDY,{y,3, ymax}]//N;
 Return[{fC, fS,fD,SOF}]]


GenSOFCont1[{mean0_,power0_,a0_,b0_,z0_}]:=
Module[{h0,k0,set,fcontrol,fscreen,finterval,fC,fS,fD,SOF,fSx,fCx,fDx},
   h0=1/mean0;
   set={power0,h0};
   fscreen=b0  Screen[set,{0,a0},a0];
   finterval=  IntervalC[set,{a0,a0+z0}] + (1-b0) DelayedC[set,{0, a0},a0+z0];
   fC= ControlC[set,{0, a0},a0+z0];              
   fS= fscreen + finterval;
   fD=fscreen;
   SOF= (fS-fC)/fD;
   k0=.001/(50^power0);
   fCx=k0 fC;
   fSx=k0 fS;
    fDx=k0 fD;
 Return[{fCx,fSx, fDx,SOF}]]

GenSOFCont2[{mean0_,power0_,a0_,b0_,z0_}]:=
Module[{h0,k0,set,fcontrol,fscreen,finterval,fC,fS,fD,SOF,fSx,fCx,fDx},
   h0=1/mean0;
   set={power0,h0};
   fscreen= b0  Screen[set,{a0,a0+z0},a0+z0] +    (1-b0) Screen[set,{0,a0},a0+z0];               
   finterval=   IntervalC[set,{a0+z0,a0+2 z0}] +   (1-b0) DelayedC[set,{a0,a0+z0},a0+ 2 z0];
   fC=ControlC[set,{0, a0+z0},a0+2 z0];  
   fS= fscreen + finterval;
   fD=fscreen;
   SOF= (fS-fC)/fD;
   k0=.001/(50^power0);
   fCx=k0 fC;
   fSx=k0 fS;
   fDx=k0 fD;
 Return[{fCx,fSx, fDx,SOF}]]



GenSOFContY[y_,{mean0_,power0_,a0_,b0_,z0_}]:=
Module[{h0,k0,set,fcontrol,fscreen,finterval,fC,fS,fD,SOF,fSx,fCx},
    h0=1/mean0;
    set={power0,h0};
    fscreen=b0 Screen[set,{a0+ (y-2) z0 ,a0+(y-1) z0},  a0+ (y-1) z0] + (1-b0) Screen[set,{a0+(y-3) z0,  a0+(y-2) z0 },   a0+ (y-1) z0];               
   finterval=  IntervalC[set,{a0+(y-1) z0,  a0+y z0}] +                               (1-b0) DelayedC[set,{a0+(y-2) z0 ,  a0+ (y-1) z0},  a0+y z0];
   fC=ControlC[set,{0, a0+(y-1) z0},a0+y z0];  
   fS= fscreen + finterval;
   fD=fscreen;
   SOF= (fS-fC)/fD;
   k0=.001/(50^power0);
   fCx=k0 fC;
   fSx=k0 fS;
 Return[{fCx,fSx, fD,SOF}]]




End[] 
EndPackage[]

