(*:Mathematica:: Version 8 *)
(*:Context:: "overdiag`" *)
(*Twin Version:: 1 *)
(*:Title:: overdiagnosis and cancer screening *)  
(*Date 2019*)
(*Input*)
(*overdiag.m
overdiagsof.m                  	      SOFNorway[]      SOFCNBSS[]  
overdiagleadtime.m          	      MeanLeadTime[]    
overdiagleadtimeboot.m          	      MeanLeadTimeKey[]
overdiagleadtimecore.m                key formulas for lead time 
overdiagsoftimeplot.m    		      SOFTimePlotStop[]  and SOFTimePlotCont[]
overdiagsoftimeplotcore.m            PlotSOFTime[]
overdiagsofmodelplot		     SOFModelPlot1[]      SOFModelPlot2[]
overdiagsoftable.m      	             SOFModelTable1[]    SOFModelTable2[]
overdiagstop.m           		     GenSOFStop[y,parvec,ymax]  
overdiagcont.m           		     GenSOFCont[y,parvec,ymax] 
overdiagpop.m                             GenSIOFPop[y,parvec,ymax]
overdiagformula.m     		      key  probabilites under model
*)   


BeginPackage["overdiag`",
"overdiagsoftimeplot`",    "overdiagsoftimeplotcore`", 
"overdiagsofmodelplot`", 
"overdiagsofmodeltable`", 
"overdiagstop`","overdiagcont`","overdiagpop`","overdiagformula`",
"overdiagsof`",
"overdiagleadtime`","overdiagleadtimeboot`","overdiagleadtimecore`"]


OverDiag::usage="OverDiag[parset,options]"
MeanLeadTime::usage="MeanLeadTime"

Fig::usage=="Fig"
NewFitQ::usage="NewFitQ"
MaxBoot::usage="MaxBoot"

Clear[OverDiag,MeanLeadTime]


Options[OverDiag]={Fig->0,NewFitQ->True}
Options[MeanLeadTime]={NewFitQ->True,MaxBoot->1000}

Begin["Private`"]


MeanLeadTime[datavec_,m_,options___Rule]:=
Module[{matset,mat,colname,tab},
{newfitQ,maxboot}={NewFitQ,MaxBoot}/.{options}/.Options[MeanLeadTime];   
MeanLeadTimeX[datavec,m,newfitQ,maxboot];
Return[Null]]



OverDiag[{y_,m_},options___Rule]:=
Module[{ymax,age0,k,modmat,plotmat,plotfig1,plotfig2,plotfig3,plotfig4}, 
{fig,newfitQ}={Fig,NewFitQ}/.{options}/.Options[OverDiag];    
If[fig==1 || fig==0,
  Print[" "];
   Print["Fig 1. SOF Model Stop Screen: ANNUAL "];
  plotfig1=SOFModelStop[y,1];
  PlotExport["overdiagFig1",plotfig1]];
If[fig==2 || fig==0,
   Print[" "];
   Print["Fig 2. SOF Model Cont Screen: ANNUAL"];
  plotfig2=SOFModelCont[y,1];
  PlotExport["overdiagFig2",plotfig2]];
If[fig==3 || fig==0,
  Print[" "];
  Print["Fig 3. SIOF Model Pop Screen: ANNUAL"];
  plotfig3=SIOFModelPop[y,1];
  PlotExport["overdiagFig3",plotfig3]];
If[fig==4 || fig==0,
  Print[" "];
  Print["Table 1 MeanLeadTime Estimate"];
  z0=1; (*years between screens*)
  k0=1; (*years since previous screen*)
  maxboot=1000;
  v4={43,52,56,52};
  datavec4={v4, "CNBSS-1inv4",z0,k0,45};
  MeanLeadTimeX[datavec4,m,newfitQ,maxboot]];
If[fig==0,
Print[" "];
Print["-----------------SUPPORTING-----------------"]];
If[fig==7|| fig==0,
  Print[" "];
   Print[" SOF estimates CNBSS"];
   SOFCNBSS[]];
If[fig==8 || fig==0,
   Print[" "];
  Print["SOF estimates Norway"];
  SOFNorway[]];
If[fig==0,  
Print[" "];
Print["------------------------SUPPLEMENT------------------------"]];
If[fig==11 || fig==0,
   Print[" "];
   Print["Figure S1 SOF Model Stop Screen"];
   age0=50;
   z0=1;
   plotfigS1=SOFTimePlotStop[y,{age0,z0},"manu"];
   PlotExport["overdiagFigS1",plotfigS1]];
If[fig==12 || fig==0,
   Print[" "];
   Print[" Fig S2. SOF Model Continued Screen"];
   age0=50;
   z0=1;
    plotfigS2=SOFTimePlotCont[y,{age0,z0},"manu"];
   PlotExport["overdiagFigS2",plotfigS2]];
If[fig==13 || fig==0,
  Print[" "];
  Print["Figure S3. SIOF Model Pop Screen"];
  age0=50;
   z0=1;
   plotfigS3=SIOFTimePlotPop[y,{age0,z0},"manu"];
   PlotExport["overdiagFigS3",plotfigS3]];
If[fig==14 || fig==0,
   Print[" "];
   Print["Fig S4. SOF Model Stop Screen: BIENNIAL "];
   plotfigs4=SOFModelStop[y,2];
   PlotExport["overdiagFigS4",plotfigs4]];
If[fig==15 || fig==0,
  Print[" "];
   Print["Fig S5. SOF Model Cont Screen: BIENNIAL"];
   plotfigS5=SOFModelCont[y,2];
   PlotExport["overdiagFigS5",plotfigS5]];
If[fig==16 || fig==0,
   Print[" "];
   Print["Fig S6. SIOF Model Pop Screen: BIENNIAL"];
  plotfigS6=SIOFModelPop[y,2];
  PlotExport["overdiagFigS6",plotfigS6]];
If[fig==17 || fig==0,
  Print[" "];
  Print["Fig S7.  Model SET"];
  plotfigS7=SOFModelSet[y,1];
  PlotExport["overdiagFigS7",plotfigS7]];

If[fig==18 || fig==0,
   Print[" "];
   Print["Fig S8. SIOF Model  Screen: ANNUAL"];
  plotfigS8=SIOFModelCross[y,1];
  PlotExport["overdiagFigS8",plotfigS8]];

If[fig==19 || fig==0,
   Print[" "];
   Print["Fig S9. SIOF Model  Screen: ANNUAL"];
  plotfigS9=SIOFModelCross[y,2];
  PlotExport["overdiagFigS9",plotfigS9]];
  
  
Return[Null]]


PlotExport[name_,plot_]:=
Module[{name1},
Print[plot];
name1=StringJoin[name,".jpg"];
Export[name1,plot];
Print["export ",name1];
name2=StringJoin[name,".tiff"];
Export[name2,plot];
Print["export ",name2];
name3=StringJoin[name,".gif"];
Export[name3,plot];
Print["export ",name3];
Return[Null]]


SIOFVarSym[v0_,v1_,x0_,x1_,n0_,n1_]:=
Module[{v0x,v1,sof,varsof0,varsof},
 v1x=x1/n1;
 v0x=x0/n0;
 sof=(v1x-v0x)/v1x;
 varsof0 = D[sof, x1]^2  x1 + D[sof, x0]^2 x0 // Simplify;
varsof= varsof0 /. {x0 -> v0 n0, x1 -> v1 n1} // Simplify // InputForm
Return[varsof]]


End[] 
EndPackage[]

Print["OverDiag[{y,m},options"];
Print["MeanLeadTime[datavec,options]"];


  datavec={{43,52,56,52}, "CNBSS-1inv4",1,1,45};
  Print["datavec"];