(*:Mathematica:: V.10 *)
(*:Contex: ofit" *)
(*Keywords:  categorical *)
(*Requirements:  None *)
(*History:  created 2015 Stuart G. Baker *)
(*inputs
*)


BeginPackage["overdiagsof`"]

SOFCNBSS::usage="SOFCNBSS"
SOFNorway::usage="SOFNorway"


Clear[SOFCNBSS,SOFNorway]


Begin["Private`"]


SOFNorway[]:=
Module[{v1x,v0x,num,v1,v0,age,mat,siof,var,se,n0},
num=100000;
v1x={ 240, 260,350, 340}/num//N;
v0x={180,210,200,200}/num//N;
age={54,56,58,60};




mat={age,v0x,v1x};
r=(61-54)/(64-50)//N;
Print["age ", age, " age fraction ",r];
Print@TableForm[mat, TableHeadings->{{"age","v0","v1"},None}];
siof=(v1-v0)/v1//N;
n0= 109784 r;
n1= 119472 r;
v0=Total[v0x];
v1=Total[v1x];
var=v0 (n0 v0+ n1 v1)/(v1^3 n0 n1)//N;
se=Sqrt[var];
Print["  v0 = ",v0 ,"    v1 = ",v1];
Print["SIOF se ",{siof,se}];
Return[Null]]


SOFCNBSS[]:=
Module[{res40Stop,res40Cont,res50Stop,res50Cont,mat,headings},
  data40stop=Data40Stop[];
  data40cont=Data40Cont[];
  data50stop=Data50Stop[];
  data50cont=Data50Cont[];
  mat1={data40stop,data40cont,data50stop,data50cont};
   headings1={{"age 40Stop","age 40 Cont", "age 50 Stop"," age 50 Cont"},{"screen ", "control", "detected"}};
  
   res40Stop=GenSOF@data40stop;
   res40Cont=GenSOF@data40cont;
   res50Stop=GenSOF@data50stop;
   res50Cont=GenSOF@data50cont;
    mat2={res40Stop, res40Cont, res50Stop,res50Cont};
   headings2={{"age 40Stop","age 40 Cont", "age 50 Stop"," age 50 Cont"},{"SOFest ", "SOFse", "SOFlow", "SOFupp"}};
   
   mat=Transpose@Join[Transpose[mat1],Transpose[mat2]];
  
   headings={{"age 40Stop","age 40 Cont", "age 50 Stop"," age 50 Cont"},{"screen","control", "detected", "SOFest ", "SOFse", "SOFlow", "SOFupp"}};
  
   Print@TableForm[mat,TableHeadings->headings];
 Return[Null]]


GenSOF[{x1_,x0_,x1S_}]:=
Module[{x1C,var,se,low,upp,difz,sez,resr},
            x1C=x1-x1S;
             difz=(x1-x0)/x1S;
            varz= (-2 x0 x1C + x0 (x0+x1S) + x1C x1) /(x1S)^3;
       sez=Sqrt[varz];
       frac=1;
       dif=difz/frac;
       se=sez/frac;
               low=dif-1.96 se;
             upp=dif+1.96 se;
         res= {dif,se,low,upp};   
         resr=Round[res 100];
Return[resr]]


Data40Cont[]:=
Module[{xs0,xc0,d,x1,x0},
  x1=119 + 37 + 28; 
   x0=148;
   x1S=119; 
Return[{x1, x0,x1S}]]

Data50Cont[]:=
Module[{xs0,xc0,d,x1,x0},
 x1= 149 + 32 + 27;
    x0= 84 + 66 + 44;
   x1S=149;
Return[{x1, x0,x1S}]]


Data40Stop[]:=
Module[{xs0,xc0,d,x1,x0},
xs0={284,327,379,435,487,544,912,1386,1725};
xc0={225,262,308,363,421,476,817,1311,1622};
d=213;
x1=xs0[[5]];
x0=xc0[[5]];
Return[{x1, x0,d}]]


Data50Stop[]:=
Module[{xs0,xc0,d},
xs0={335,381,411,456,514,572,899,1295,1525};
xc0={256,297,342,399,468,529,891,1286,1511};
d=271;
x1=xs0[[5]];
x0=xc0[[5]];
Return[{x1, x0,d}]]





End[] 

EndPackage[]

