(*Mathematica:: Version 8.0      *)
(*:Context:: "mfit`"                     *)
(*:Title::  MFit            		*)
(*:Summary::   mfitsupport            	*)
(*:References::                         *)
(*Date  2013 Stuart G. Baker   *)


BeginPackage["mfitsupport`"]  

ComputeAIC::usage="ComputeAIC[zpar,zmse,n]"
GenTimeRangeForFunction::usage="GenTimeRangeForFunction[times]"
GenCommonRange::usage="GenCommonRange[dataset1,dataset2,pos]"
GenRangeForPlot::usage="GenRangeForPlot[range,format]"
ShortModelName::usage="ShortModelName[name]"
GoodModelPairQ::usage="GoodModelPairQ[modelset,pos,zbestmat1,zbestmat2]"
PosGoodPair::usage="PosGoodPair[modelset,pos,zbestmat1,zbestmat2,{modname1,modname2}]"

Clear[GenTimeRangeForFunction,GenCommonRange,GenRangeForPlot,ShortModelName]

Begin["Private`"]	  


 ComputeAIC[zpar_,zmse_,n_]:=
      Module[{k,aic},
       k=Length[zpar];
       (*
       aic=n Log[zmse] + 2 k + 2 k (k+1)/Max[1,n-k-1];
       *)
       aic=n Log[zmse] + 2 k;
       Return[aic]]

GenTimeRangeForFunction[times_]:=
Module[{timesore,mintime,len,maxtime},
          mintime=Min[times];
          maxtime=Max[times];
  Return[{mintime,maxtime}]]

GenCommonRange[dataset1_,dataset2_,pos_]:=
 Module[{xA1,xB1,yA1,yB1,xA2,xB2,yA2,yB2,range},
 {{xA1,xB1},{yA1,yB1}}=GenRange1[dataset1,pos];
 {{xA2,xB2},{yA2,yB2}}=GenRange1[dataset2,pos];
 xA=Min[xA1,xA2];
 xB=Max[xB1,xB2];
 yA=Min[yA1,yA2];
 yB=Max[yB1,yB2];
 range={{xA,xB},{yA,yB}};
 Return[range]]
 

 GenRange1[dataset_,pos_]:=
 Module[{data,geneid,genename,times,xname,yname,plotname,dataname,y,range},
    {data,geneid,genename,times,xname,yname,plotname,dataname}=dataset;
      y= data[[pos]];
     range={{0, Max[times]},{Min[y],Max[y]} };
Return[range]]


GenRangeForPlot[range_,format_]:=
 Module[{xmin,xmax,ymin,ymax,difx,dify,rangePLOT},
        {{xmin,xmax},{ymin,ymax}}=range;   
          difx=xmax-xmin;
    	   dify=ymax-ymin;
    	(*If[format=="small", 	rangePLOT={{xmin, xmax},{ymin -.1 dify,ymax+ .2 dify}}];*)
    	If[format=="small", 	rangePLOT={{xmin, xmax},{ymin -.1 dify,ymax+ .5 dify}}];
    	If[format=="large", 	rangePLOT={{xmin, xmax},{ymin -.1 dify,ymax+ .6 dify}}];
Return[rangePLOT]]


ShortModelName[zmod_]:=
Module[{zmodshort},
If[zmod=="flat",            zmodshort="flat"];
If[zmod=="lineD",         zmodshort="lineD"];
If[zmod=="lineU",         zmodshort="lineU"];
If[zmod=="hockeyD",   zmodshort="hocD"];
If[zmod=="hockeyU",    zmodshort="hocU"];
If[zmod=="transitionD", zmodshort="tranD"];
If[zmod=="transitionU", zmodshort="tranU"];
If[zmod=="sigmoidD",   zmodshort="sigD"];
If[zmod=="sigmoidU",   zmodshort="sigU"];
If[zmod=="impulseD",   zmodshort="impD"];
If[zmod=="impulseU",   zmodshort="impU"];
If[zmod=="stepU",         zmodshort="stepU"];
If[zmod=="stepD",          zmodshort="stepD"];
If[zmod=="impulse+D", zmodshort="imp+D"];
If[zmod=="impulse+U", zmodshort="imp+U"];
If[zmod=="step+U",       zmodshort="step+U"];
If[zmod=="step+D",      zmodshort="step+D"];
If[zmod=="polynomial3",  zmodshort="poly3"];
If[zmod=="polynomial5",  zmodshort="poly5"];
If[zmod=="polynomial7",  zmodshort="poly7"];
Return[zmodshort]]




PosGoodPair[modelset_,pos_,zbestmat1_,zbestmat2_,{modname1_,modname2_}]:=
Module[{bothfitQ,zmod1,zmod2,res},
   {bothfitQ,zmod1,zmod2}=GoodModelPairQ[modelset,pos,zbestmat1,zbestmat2];
   If[bothfitQ==1 && zmod1==modname1 && zmod2==modname2,res=pos, res=0];
Return[res]]
 

GoodModelPairQ[modelset_,pos_,zbestmat1_,zbestmat2_]:=
Module[{zbestvec1,zbestvec2, ztype1,ztype2,zmod1,zmod2,bothfitQ,res,testmodQ},
     zbestvec1=zbestmat1[[pos]];
      zbestvec2=zbestmat2[[pos]];
   (*type of fit 1 is best 2 is next*)
      ztype1=zbestvec1[[1]];
      ztype2=zbestvec2[[1]];
     zmod1=zbestvec1[[2]];
     zmod2=zbestvec2[[2]];
     testmodQ=MemberQ[modelset,zmod1] && MemberQ[modelset,zmod2];
  (*If either best or next is selected in both*)
       If[(ztype1=="A" || ztype1=="B") && (ztype2=="B" || ztype2=="A") && testmodQ, bothfitQ=1,bothfitQ=0]; 
  (*output*)   
     res={bothfitQ,zmod1,zmod2};
Return[res]]


End[] 
EndPackage[]


