(*Mathematica:: Version 8.0      *)
(*:Context:: "mfit`"                     *)
(*:Title::  MFit            		*)
(*:Summary::   mfitside          	*)
(*:References::                         *)
(*Date  2013 Stuart G. Baker   *)

(*Input
ComputeAIC				mfitsupport.m
FormPairVec				mfitform.m  
GenFunc			   		mfitcore.m  
SplitData					mfitcore.m
GenCommonRange		mfitsupport.m
GenRangeForPlot			mfitsupport.m
GenTimeRangeForFunction 	mfitsupport.m*)

BeginPackage["mfitplotside`","mfitcore`","mfitform`", "mfitsupport`"]  

\[CapitalDelta]::usage=" ";
PlotPairSideVec::usage="PlotPairSideVec[pos,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,
                                          color1,color2,format]"

Clear[PlotPairSideVec]

Begin["Private`"]	  


PlotPairSideVec[pos_,zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,
  color1_,color2_,format_]:=
Module[{zbestvec1,zbestvec2,range,s, zplot1,zplot2,rangePLOT,zplotR1,zplotR2,zplot},
  (*BEST FITTING RESULTS FOR PARTICULAR GENE POSITION*)
      zbestvec1=zbestmat1[[pos]];
      zbestvec2=zbestmat2[[pos]];
 (*CREATE COMMON RANGE*)   
      range=GenCommonRange[dataset1,dataset2,pos];
      rangePLOT=GenRangeForPlot[range,format];
       s=par[[-1]];
 (*CREATE SEPARATE PLOTS*)
      zplot1=PlotSideOne[zbestvec1,dataset1,s,splitQ,range, color1,format]; 
       zplot2=PlotSideOne[zbestvec2,dataset2,s,splitQ,range,color2,format];
       zplotR1=Show[zplot1,PlotRange->rangePLOT,Frame->True];
       zplotR2=Show[zplot2,PlotRange->rangePLOT,Frame->True];
       zplot={zplotR1,zplotR2};
    Return[zplot]]
 

 PlotSideOne[zbestvec_,dataset_,s_,splitQ_,range_,color_,format_]:=
Module[{ztype,zmod,zstat,zfunc,zpar,zmse,
	        zmodA,zstatA,zfuncA,zparA,zmseA,
	        zmodB,zstatB,zfuncB,zparB,zmseB,
	         zmodvec,zstatvec,zfuncvec,zparvec,zmsevec,pos,
              data,geneid,genename,times,xname,yname,plotname,dataname,
               y,x,dataXY,dataXYfit,dataXYtest,timex,n,
               labelvec,
              plotdata0,plotdata1, rangePLOT,plot},
        (*INPUTS*)    
            {ztype,zmod,zstat,zfunc,zpar,zmse,
	       zmodA,zstatA,zfuncA,zparA,zmseA,
	        zmodB,zstatB,zfuncB,zparB,zmseB,
	     zmodvec,zstatvec,zfuncvec,zparvec,zmsevec,pos}= zbestvec;
	     {data,geneid,genename,times,xname,yname,plotname,dataname}=dataset;
         (*DATA FOR POINTS*)
            y= data[[pos]];
	       x= times;
	      dataXY=Transpose[{x,y}];
         (*PLOT POINTS*)
              {dataXYfit, dataXYtest}=SplitData[pos,dataset,splitQ];
          If[format=="small",    
               plotdata0=ListPlot[dataXYfit,PlotStyle->{Red}];
              plotdata1=ListPlot[dataXYtest,PlotStyle->{Black}]];
          If[format=="large",    
               plotdata0=ListPlot[dataXYfit,PlotStyle->{Red,PointSize[.02]}];
              plotdata1=ListPlot[dataXYtest,PlotStyle->{Black,PointSize[.02]}]];
        
        (*Label Points*)
          If[format=="large", 
             {{xmin,xmax},{ymin,ymax}}=range;
               xL=xmin+ .65 (xmax-xmin);
               xR=xmin+ .95 (xmax-xmin);
              yF=ymin+ .2 (ymax-ymin);
              yE=ymin+ .1 (ymax-ymin); 
              pointnameF=Style["fitted point",Red, Medium];
               pointnameF=Style["fitted point",Red, Medium];
               pointnameE=Style["evaluation point",Black, Medium];
               pointF=Graphics@{PointSize[.02],Red,Point[{xR,yF}]};
               pointE=Graphics@{PointSize[.02],Black,Point[{xR,yE}]};
               pointtextE=Graphics@Text[pointnameE,{xL,yE},{-1,0}];     
                pointtextF=Graphics@Text[pointnameF,{xL,yF},{-1,0}];    
                respoint={pointF,pointE,pointtextE,pointtextF}];
 
   If[format=="small",
              {{xmin,xmax},{ymin,ymax}}=range;
                xL=xmin+ .55 (xmax-xmin);
                xR=xmin+ .95 (xmax-xmin);
               yF=ymin+ .1 (ymax-ymin);
               yE=ymin+ .01 (ymax-ymin); 
                pointnameF=Style["fitted",Red];
                pointnameE=Style["evaluation",Black];
                pointF=Graphics@{PointSize[.02],Red,Point[{xR,yF}]};
                pointE=Graphics@{PointSize[.02],Black,Point[{xR,yE}]};
                pointtextE=Graphics@Text[pointnameE,{xL,yE},{-1,0}];     
                 pointtextF=Graphics@Text[pointnameF,{xL,yF},{-1,0}];    
                respoint={pointF,pointE,pointtextE,pointtextF}];
 
        
          (*LABEL ON FRAME*)
            geneid0=ToString@geneid[[pos]];
            genename0=genename[[pos]];
            n=Length[dataXYtest];
            fitname=ComputeFitLabel[zstatA,zparA,zmseA,zstatB,zparB,zmseB,n];
            labelvec=GenFrameLabel[zmod,xname,yname,plotname,color,format,genename0,geneid0,fitname];
        (*FUNCTION---------*)
               plotfuncvec=PlotFunc[s,times,range,ztype,zfuncA,zparA,zfuncB,zparB,
                                         zfuncvec,zparvec,color,format];           
     (*RANGE FOR FUNCTION*)  
               rangePLOT=GenRangeForPlot[range,format];                
                ztextvec=PlotText[zbestvec,range,plotname,color,format];   
       (*COMBINE*)
             plot=Show[plotdata0,plotdata1,ztextvec,plotfuncvec,respoint,
	            PlotRange->rangePLOT, FrameLabel->labelvec,
	     	   FrameTicks->Automatic,Frame -> True, Axes->None,LabelStyle -> Small,AspectRatio->1];
      Return[plot]]
      
      ComputeFitLabel[zstatA_,zparA_,zmseA_,zstatB_,zparB_,zmseB_,n_]:=
      Module[{aicA,aicB,aicDEL, zstatDEL,aicDELr,zstatDELr,aicDELs,zstatDELs,name},
         (*A is min RPE; B is min RPE of models with fewer parameters*)
         aicA=ComputeAIC[zparA,zmseA,n];
         aicB=ComputeAIC[zparB,zmseB,n];
         aicDEL=aicB-aicA;
         zstatDEL=zstatB-zstatA;
        aicDELr=Round[aicDEL 10]/10//N;
        zstatDELr=Round[zstatDEL 100];
       aicDELs=ToString@ aicDELr;
        zstatDELs=ToString@zstatDELr;
        del=ToString[\[CapitalDelta]];
        name=StringJoin[del,"RPE = ",zstatDELs,"%     ",del,"AIC= ", aicDELs];
      Return[name]]  
         
       
      GenFrameLabel[zmod_,xname_,yname_,plotname_,color_,format_,genename0_,geneid0_,fitname_]:=
      Module[{plotnamef,xnamef,ynamef,plotnamex},
                  If[format=="large",
                        plotnamex=StringJoin[plotname," ",genename0," ",geneid0];
                        plotnamef=Style[plotnamex,color,Medium];
      		         xnamef=Style[xname,Medium];
      		         ynamef=Style[yname,Medium]];
      		   If[format=="small",
                        plotnamef=Style[plotname,color,Medium];
     		         xnamef=xname;
      		         ynamef=yname];
                   labelvec={xnamef, ynamef, plotnamef," "};
      Return[labelvec]]
      
      (*----------------------------PLOT FUNCTION SIDE BY SIDE---*)
   
   PlotFunc[s_,times_,range_,ztype_,zfuncA_,zparA_,zfuncB_,zparB_,zfuncvec_,zparvec_,color_,format_]:=  
   Module[{res},
     If[format=="large",res=PlotFuncLarge[s,times,range,ztype,zfuncA,zparA,zfuncB,zparB,
                                      zfuncvec,zparvec,color]];
    If[format=="small",res=PlotFuncSmall[s,times,range,ztype,zfuncA,zparA,zfuncB,zparB,
                                     zfuncvec,zparvec,color]];
Return[res]] 
     
      PlotFuncSmall[s_,times_,range_,ztype_,zfuncA_,zparA_,zfuncB_,zparB_,zfuncvec_,zparvec_,color_]:=
      Module[{mintime,maxtime,plotfuncBEST,plotfuncNEXT,plotfuncvec},
              {mintime,maxtime}=GenTimeRangeForFunction[times];
                funcA=GenFunc[{zfuncA,zparA},s];   
                funcB=GenFunc[{zfuncB,zparB},s];   
                 If[ztype=="A", funcBEST=funcA;funcNEXT=funcB];
                 If[ztype=="B", funcBEST=funcB; funcNEXT=funcA];
                  plotfuncBEST=Plot[funcBEST, {s, mintime, maxtime},PlotRange->All,PlotStyle->{color}];
                  plotfuncNEXT=Plot[funcNEXT, {s, mintime, maxtime},PlotRange->All,
                                PlotStyle->{Dashing[{.01,.01}],Orange}];
                  plotfuncvec={plotfuncBEST,plotfuncNEXT};
           Return[plotfuncvec]]
      

      PlotFuncLarge[s_,times_,range_,ztype_,zfuncA_,zparA_,zfuncB_,zparB_,zfuncvec_,zparvec_,color_]:=
      Module[{mintime,maxtime,funcA,plotfuncA,pairvec,pairvecC,zfuncBEST,zparBEST,
                    zfuncSET,zpairSET,pairset,funcSET,plotfuncSET,plotfuncvec},
              (*BEST FITTING MODEL*)
                 {mintime,maxtime}=GenTimeRangeForFunction[times];
                  funcA=GenFunc[{zfuncA,zparA},s];   
                 funcB=GenFunc[{zfuncB,zparB},s];   
                  If[ztype=="A", funcBEST=funcA; zparBEST=zparA];
                 If[ztype=="B", funcBEST=funcB; zparBEST=zparB];
                plotfuncBEST=Plot[funcBEST, {s, mintime, maxtime},PlotRange->All,PlotStyle->{color}];
                  (*REMAINING MODELS*)
           (*
           pairvec=Transpose[{zfuncvec,zparvec}];
             pairvecC=Complement[pairvec,{{zfuncBEST,zparBEST}}];
              funcSET=GenFunc[#,s]& /@ pairvecC;   
             plotfuncSET=Plot[#, {s, mintime, maxtime},PlotRange->All,
                                  PlotStyle->{Dashing[{.01,.01}],Orange}]& /@ funcSET;
                                  Print@plotfuncSET;
                   plotfuncvec=Join[plotfuncSET,{plotfuncBEST}]; 
               *)      
                  plotfuncvec={plotfuncBEST};
             Return[plotfuncvec]]
   

(*------------------LABEL SIDE BY SIDE---------------------------------------------------*)

PlotText[zbestvec_,range_,plotname_,color_,format_]:=
Module[{res},
  If[format=="large",res=PlotTextLarge[zbestvec,range,plotname,color]];
  If[format=="small",res=PlotTextSmall[zbestvec,range,plotname,color]];
Return[res]]


PlotTextLarge[zbestvec_,range_,plotname_,color_]:=
Module[{ztype,zmod,zstat,zfunc,zpar,zmse,
	        zmodA,zstatA,zfuncA,zparA,zmseA,
	        zmodB,zstatB,zfuncB,zparB,zmseB,
	         zmodvec,zstatvec,zfuncvec,zparvec,zmsevec,pos,
               zmodAs,zmodBs,
               xmin,xmax,ymin,ymax,xM,xMshift,yM,
                 zstatAr,zstatAs,zstatBr,zstatBs,ztextA,ztextB,
               delaic,del, aics,aictext,zlabx,zlabtext,res},
      (*input*)         
         {ztype,zmod,zstat,zfunc,zpar,zmse,
	                     zmodA,zstatA,zfuncA,zparA,zmseA,
	                    zmodB,zstatB,zfuncB,zparB,zmseB,
	            zmodvec,zstatvec,zfuncvec,zparvec,zmsevec,pos}= zbestvec;
    (*modename*)
          zmods=Style[zmod,color,Medium];
    (*COORDINATES OF LABELS*)        
         {{xmin,xmax},{ymin,ymax}}=range;
         xM=xmin+ .1 (xmax-xmin);
         xS=xmin+ .4 (xmax-xmin);         
         xF=xmin+ .7 (xmax-xmin);         
         yM=ymax+ .5(ymax-ymin);
     (*model name*)
        zmodx=Graphics@Text[zmods,{xM,yM},{-1,0}];    
        len=Length[zmodvec];
         rangeset=(Range[len]-1);
        yvec=yM - rangeset .05 (ymax-ymin);
         tri=Transpose[{zstatvec,zmodvec,yvec}];
         ztextvec=GenZText[xS,xF,#,zmod,color]& /@ tri;
       res=Flatten[ztextvec]~ Join~ {zmodx};
   Return[res]]
  
  
PlotTextSmall[zbestvec_,range_,plotname_,color_]:=
Module[{ztype,zmod,zstat,zfunc,zpar,zmse,
	        zmodA,zstatA,zfuncA,zparA,zmseA,
	        zmodB,zstatB,zfuncB,zparB,zmseB,
	         zmodvec,zstatvec,zfuncvec,zparvec,zmsevec,pos,
                 zmodsA,zmodsB,zmodxA,zmodxB,
                xmin,xmax,ymin,ymax,xM,xS,yM,ytop,ybot,
                 zstatAr,zstatAs,zstatBr,zstatBs,
                 zmodtopx,zmodbotx,zstattopx,zstatbotx,
                 zmodtop,zmodbot,zstattop,zstatbot,
                 zmodx,zstatxA,zstatxB,res},
      (*input*)         
                 {ztype,zmod,zstat,zfunc,zpar,zmse,
                  zmodA,zstatA,zfuncA,zparA,zmseA,
                    zmodB,zstatB,zfuncB,zparB,zmseB,
               zmodvec,zstatvec,zfuncvec,zparvec,zmsevec,pos}= zbestvec;
       (*fit*)  
          zstatAr=IntegerPart[Round[zstatA 100]];
          zstatBr=IntegerPart[Round[zstatB 100]];
          zstatAs=StringJoin["RPE= ",ToString[zstatAr],"%"];
          zstatBs=StringJoin["RPE= ",ToString[zstatBr],"%"];    
       (*model*)   
          If[ztype=="A", zmodsA=Style[zmodA,color], zmodsA=Style[zmodA,Orange]];
	  If[ztype=="B", zmodsB=Style[zmodB,color], zmodsB=Style[zmodB,Orange]];
         (*top is top in plot*)
           If[ztype=="A", 
              zmodtop=Style[zmodA,color]; 
              zstattop=Style[zstatAs,color]; 
              zmodbot=Style[zmodB,Orange];
              zstatbot=Style[zstatBs,Orange]];
        If[ztype=="B", 
              zmodtop=Style[zmodB,color]; 
              zstattop=Style[zstatBs,color]; 
              zmodbot=Style[zmodA,Orange];
              zstatbot=Style[zstatAs,Orange]];              
    (*COORDINATES OF LABELS*)        
         {{xmin,xmax},{ymin,ymax}}=range;
         xM=xmin+ .1 (xmax-xmin); (*model*)
         xS=xmin+ .6 (xmax-xmin);  (*statistic*)       
          ytop=ymax+ .40 (ymax-ymin);
          ybot=ymax+ .25 (ymax-ymin);
       (*LABELS*)   
         zmodtopx=Graphics@Text[zmodtop,{xM,ytop},{-1,0}];  
        zmodbotx=Graphics@Text[zmodbot,{xM,ybot},{-1,0}];  
         zstattopx=Graphics@Text[zstattop,{xS,ytop},{-1,0}];  
         zstatbotx=Graphics@Text[zstatbot,{xS,ybot},{-1,0}];     
        res={zmodtopx,zmodbotx,zstattopx,zstatbotx};
   Return[res]]

GenZText[xS_,xF_,{zstati_,zmodi_,yM_},zmod_,color_]:=
 Module[{zstatr, zmoda, zstata,zstatb,zstatc,zstat,zmodc, zmodx,colorX},
        If[zmod==zmodi,colorX=color,colorX=Black];
       (*model*)
         zmoda=Style[zmodi,colorX];
         zmodx=Graphics@Text[zmoda,{xS,yM},{-1,0}];
       (*statistic*)
         zstata=IntegerPart[Round[zstati 100]];
         zstatb=ToString[zstata];
          zstatc=StringJoin["RPE = ",ToString[zstatb],"%"];
         zstatd=Style[zstatc,colorX];
        zstat=Graphics@Text[zstatc,{xF,yM},{-1,0}];
     Return[{zmodx,zstat}]]
     




 




End[] 
EndPackage[]



