(*Mathematica:: Version 8.0      *)
(*:Context:: "mfit`"                     *)
(*:Title::  mfitreport            		*)
(*:Summary::               *)
(*:References::  Finding biologically relevant response patterns in high-throughput experiments*)
(*Date 2013   Stuart G. Baker   *)

(*Inputs
GoodModelPairQ        mfitsupport.m
PosGoodPair:             mfitsupport.m
FormPair			     from mfitform.m
FormPairVec		     from mfitform.m*)



BeginPackage["mfitreport`","mfitcore`","mfitform`","mfitsupport`"]  


ReportShapePairs::usage="ReportShapePairs[modelset,input,modpairvec]"

Clear[ReportShapePairs]



Begin["Private`"]	  

 ReportShapePairs[modelset_,input_,modpairvec_]:=
    Module[{ },
      Print["MODEL PAIR LIST"];
      ReportShapePairsOne[modelset,input,#]& /@ modpairvec;
   Return[Null]]
    
   
   ReportShapePairsOne[modelset_,{zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,
         splitQ_,exportplotQ_,kform_},modpair_]:=
     Module[{len,lenx,range,posvec,posvecFIT,mod1,mod2},
            len=Length@zbestmat1;
             range=Range[len];
         (*select pairs that fit the model*)
             posvec=PosGoodPair[modelset,#,zbestmat1,zbestmat2,modpair]& /@ range;
           posvecFIT=Select[posvec,(#>0)&];
            lenx=Length[posvecFIT];
       If[lenx==0, Print["MODEL PAIR ",modpair, " none"]];
       (*AT LEAST ONE IN MODEL*)
         If[lenx>0,          
         Print["MODEL PAIR: ", modpair,  " number of occurrences = ",lenx];
        {mod1,mod2}=modpair;
        If[mod1==mod2, 
         ReportIsomorph[posvecFIT,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,exportplotQ,kform],
         ReportHeteromorph[posvecFIT,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,exportplotQ,kform]]];
     Return[Null]]
     
     
     (*---------------------------------------ISOMORPH------------------------*)  
     
  ReportIsomorph[posvecFIT_,zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,exportplotQ_,kform_]:=
     Module[{formset,posvecNO,posvecHC,posvecHM,posvecBO},
       (*compute criterion for HC and HM*)
            formset=FormPair[posvecFIT,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform];
     (*set of gene positions for each type*)
         posvecNO=PosFormSet[formset,0];
         posvecHC=PosFormSet[formset,1];
         posvecHM=PosFormSet[formset,2];
         posvecBO=PosFormSet[formset,3];
      (*report if at least one of each type*)
        If[Length[posvecNO]>0,
              ReportSame[{zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform},posvecNO]];
        If[Length[posvecHC]>0,
              ReportSame[{zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform},posvecHC]];
         If[Length[posvecHM]>0,
              ReportSame[{zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform},posvecHM]];
          If[Length[posvecBO]>0,
             ReportSame[{zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform},posvecBO]];
     Return[Null]]
       
       PosFormSet[formset_,z_]:=
           Module[{modvec,formsetx,htypevec,hCvec,hMvec,posvec},
             formsetx=Select[formset,(#[[2]]==z)&];
             If[Length[formsetx]>0,
             {modvec,htypevec,hCvec,hMvec,posvec}=Transpose[formsetx];
             res=posvec,
             res={}];
             Return[res]]
           

       
       
     ReportSame[{zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,kform_},posvec_]:=
     Module[{mat,posvecs},
           mat=ReportSameOne[{zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform},#]& /@ posvec;
           PrintSame[mat];
      Return[Null]]

       ReportSameOne[{zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,kform_},pos_]:=
         Module[{geneid,genename,geneid0,genename0, mod,hname,htype,hC,hM,res,hCr,hCy},
           geneid=dataset1[[2]];
           genename=dataset1[[3]];
           genename0=genename[[pos]];
           geneid0=geneid[[pos]];
           {mod,htype, hC,hM,posx}=FormPairVec[pos,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform];
           If[htype==0, hname="same"; htype=0];
           If[htype==1, hname="HC"; htype=hC];
           If[htype==2, hname="HM"; htype=hM];
           If[htype==3, hname="both"; htype=Min[hC,hM]];
           hCr=Round[hC 100];
           hMr=Round[hM 100];
           res={htype,genename0,geneid0,hname,hCr,hMr,pos};
          Return[res]]
          
  PrintSame[mat_]:=
  Module[{mats,matx,colname,headings,posvecs},
    (*largest to smallest*)
             mats=Reverse@Sort[mat];  
          (*drop sorting variable and positiion variable*)
            matx=Transpose@Drop[Drop[Transpose[mats],1],-1];
         (*print table groups*)
            colname={"genename","genid","class","HC%","HM%"};
            headings={None,colname};
           PrintTableFormGroupCore[matx,10,headings];
       Return[Null]]
     
  (*-----------------------------------------HETEROMORPH------------------*)   
     
  ReportHeteromorph[posvecFIT_,zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,exportplotQ_,kform_]:=
       Module[{posvecs},
          If[Length[posvecFIT]>0,
            ReportDiffer[{zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform},posvecFIT]];
        Return[Null]]
   
   ReportDiffer[{zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,kform_},posvec_]:=
       Module[{mat},
          mat=ReportDifferOne[{zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform},#]& /@ posvec;
           PrintDiffer[mat];
  Return[Null]]
  
         ReportDifferOne[{zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,kform_},pos_]:=
           Module[{geneid,genename,geneid0,genename0, mod,htype,hC,hM,hB,res},
             geneid=dataset1[[2]];
             genename=dataset1[[3]];
             genename0=genename[[pos]];
             geneid0=geneid[[pos]];
             {mod,htype, hC,hM,posx}=FormPairVec[pos,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform];
             hB=Min[hC,hM];
             res={hB,genename0,geneid0,pos};
           Return[res]]
    
       
 PrintDiffer[mat_]:=
   Module[{mats,matx,colname,headings},
         (*largest to smallest*)
           mats=Reverse@Sort[mat];  
     (*drop sorting variable and positiion variable*)
          matx=Transpose@Drop[Drop[Transpose[mats],1],-1];
       (*print table groups*)
          colname={"genename","genid"};
          headings={None,colname};
          PrintTableFormGroupCore[matx,10,headings];
     Return[Null]]     
 
 (*------ PRINT BY BLOCKS OF ROWS---------*)
     
 PrintTableFormGroupCore[mat_,lenblock_,headings_]:=
 Module[{ncol,nrow,i,zerovec,numblocks,numtot,matpad,matset},
   {nrow,ncol}=Dimensions[mat];
   numblocks=Ceiling[nrow/lenblock];
   numtot=numblocks lenblock;
  zerovec={Table[0,{i,1,ncol}]};
   matpad=PadRight[mat,numtot,zerovec];
  matset=Partition[matpad,lenblock];
  PrintTableFormGroupOne[#,headings]& /@ matset;
  Return[Null]]
   

PrintTableFormGroupOne[mat_,headings_]:=
Module[{matx},
 matx=Select[mat,(#[[1]]=!=0)&];
 Print["            ",TableForm[matx,TableHeadings->headings]];
 Return[Null]]
 



 
End[] 
EndPackage[]