(*Mathematica:: Version 8.0      *)
(*:Context:: "mfit`"                     *)
(*:Title::  MFit            		*)
(*:Summary::   mfitoverlay          	*)
(*:References::                         *)
(*Date  2013 Stuart G. Baker   *)

(*Input
FormPairVec				mfitform.m  
GenFunc			   		mfitcore.m  
GenCommonRange		mfitsupport.m
GenRangeForPlot			mfitsupport.m
GenTimeRangeForFunction 	mfitsupport.m*)

BeginPackage["mfitplotoverlay`","mfitcore`","mfitform`","mfitsupport`"]  

PlotPairOverlayVec::usage="PlotPairCombined[pos,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ]"

Clear[PlotPairOverlayVec]

Begin["Private`"]	  



PlotPairOverlayVec[pos_,zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,
    kform_,color1_,color2_,format_]:=
 Module[{zbestvec1,zbestvec2,plot1,plot2,plot,s,zmod1,zmod2,
            plotname1,plotnames1,xM,xZ,yM1,plotnametext1,zmod1short,zmod2short,
            mod0,wtype, hC,hM,pos0,
            plotname2,plotnames2,yM2,plotnametext2},
   (*PLOTS*)
         s=par[[-1]];
         zbestvec1=zbestmat1[[pos]];
         zbestvec2=zbestmat2[[pos]];
        range=GenCommonRange[dataset1,dataset2,pos];  
         {zmod1,plot1}=PlotOneOverlay[zbestvec1,dataset1,s,color1,range,format];
         {zmod2,plot2}=PlotOneOverlay[zbestvec2,dataset2,s,color2,range,format];
      (*Labels*)
        {mod0,wtype, hC,hM,pos0}=FormPairVec[pos,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform];
         plotname1=dataset1[[-2]];
         plotname2=dataset2[[-2]];
         labelplot= LabelOverlay[range,{zmod1,plotname1,color1},{zmod2,plotname2,color2},{hC,hM},format];
      (*Combine*)
           plot=Show[plot1,plot2,labelplot];
   Return[plot]]

LabelOverlay[range_,{zmod1_,plotname1_,color1_},{zmod2_,plotname2_,color2_},{hC_,hM_},format_]:=
  Module[{xmin,xmax,ymin,ymax,difx,dify,
             XMleft,XMright,yM1,yM2, yMIN1,yMIN2,
              zmod1short,plotnames1,modname1,
              zmod2short, plotnames2,modname2,
             HCs,HMs,HCx,HMx,HCtext,HMtext,xH},      
(*LABEL*)
               {{xmin,xmax},{ymin,ymax}}=range;   
            xMleft=xmin+ .1 (xmax-xmin);
            xMright=xmin+ .6 (xmax-xmin);
       (*FORMAT*)
          If[format=="large",
                plotnames1=Style[plotname1,color1,Medium];
                plotnames2=Style[plotname2,color2,Medium];
                yM1=ymax+ .35 (ymax-ymin);
                yM2=ymax+ .25 (ymax-ymin);
               zmod1x=zmod1;
               zmod2x=zmod2;
               modname1=Style[zmod1x,color1,Medium];
	        modname2=Style[zmod2x,color2,Medium]];
         If[format=="small",  
                plotnames1=Style[plotname1,color1];
               plotnames2=Style[plotname2,color2];
                yM1=ymax+ .40 (ymax-ymin);
                yM2=ymax+ .25 (ymax-ymin);
                zmod1x=ShortModelName[zmod1];      
      	       zmod2x=ShortModelName[zmod2];
  	         modname1=Style[zmod1,color1];
  	          modname2=Style[zmod2,color2]];
  (*LABEL IN PLOT FOR DATASET*)  	        
  (*  	        plotnames1=Style[plotname1,color1,Medium];*)
                  plotnametext1=Graphics@Text[plotnames1,{xMleft,yM1},{-1,0}]; 
                  modnametext1=Graphics@Text[modname1,{xMright,yM1},{-1,0}]; 
  (*LABEL IN PLOT FOR DATASET 2*)
  (*              plotnames2=Style[plotname2,color2,Medium];*)
  	          plotnametext2=Graphics@Text[plotnames2,{xMleft,yM2},{-1,0}];          
                  modnametext2=Graphics@Text[modname2,{xMright,yM2},{-1,0}]; 
    (*LABEL HC and HM*)
      If[zmod1==zmod2,
            HCs=ToString[IntegerPart[Round[hC 100]]];
          HMs=ToString[IntegerPart[Round[hM 100]]];
          If[format=="large",          xH=xmin+ .8 (xmax-xmin)];
          If[format=="small",          xH=xmin+ .5 (xmax-xmin)];
          HCx=StringJoin["HC= ",HCs,"%"];
          HMx=StringJoin["HM= ",HMs,"%"];
             yMIN1=ymin+ .2 (ymax-ymin);
              yMIN2=ymin+ .1 (ymax-ymin);          
          HCtext=Graphics@Text[HCx,{xH, yMIN1},{-1,0}];  	         
          HMtext=Graphics@Text[HMx,{xH, yMIN2},{-1,0}];  	    
       res={plotnametext1,plotnametext2,modnametext1,modnametext2,HCtext,HMtext},
       (*else*)
       res={plotnametext1,plotnametext2,modnametext1,modnametext2}];
       Return[res]]



 PlotOneOverlay[zbestvec_,dataset_,s_,color_,range_,format_]:=
   Module[{ztype,zmod,zstat,zfunc,zpar,zmse,
	        zmodA,zstatA,zfuncA,zparA,zmseA,
	        zmodB,zstatB,zfuncB,zparB,zmseB,
	         zmodvec,zstatvec,zfuncvec,zparvec,zmsevec,pos, k,
               plotname,dataname,data,geneid,genename,times,
               geneidpos,genenamepos,
               y,x,dataXY,dataXYfit,dataXYtest,
               dif,maxtime,mintime,
                 xmin,xmax,ymin,ymax,difx,dify,dx,dy,ticks,yminr,ymaxr,ticksy,ticksx,
                geneidx,genetext,zstats,ind,yZ,plotfunc,xZ,ztext,nametop,nameside0,label,
               rangePLOT,plot,plotx},
         (*INPUTS*)  
         {ztype,zmod,zstat,zfunc,zpar,zmse,
	        zmodA,zstatA,zfuncA,zparA,zmseA,
	        zmodB,zstatB,zfuncB,zparB,zmseB,
	         zmodvec,zstatvec,zfuncvec,zparvec,zmsevec,pos} = zbestvec;
                {data,geneid,genename,times,xname,yname,plotname,dataname}=dataset;
           (*GENE POS*)
                 geneidpos=geneid[[pos]];
 	          genenamepos=genename[[pos]];
         (*DATA*)
 	       y= data[[pos]];
 	       x= times;
           (*RANGE FOR FUNCTION*)        
               {mintime,maxtime}=GenTimeRangeForFunction[times];
           (*RANGE FOR LABEL same over two plots*)
          {{xmin,xmax},{ymin,ymax}}=range;   
                  difx=xmax-xmin;
   	         dify=ymax-ymin;
   	  (*LABEL ON FRAME*)
	           geneidx=StringJoin[" id= ",ToString[geneidpos]]; 
	             nametop=StringJoin[genenamepos, "    ",geneidx];
	              nametopx=Style[nametop,Medium];
	    (*FORMAT*)
              If[format=="large",
	              xnamex=Style[xname,Medium];
	              ynamex=Style[yname,Medium]];
              If[format=="small",
	              xnamex=xname;
	              ynamex=yname];
	          label={xnamex, ynamex, nametopx,Null};
	     (*FUNCTION*)   
                  func=GenFunc[{zfunc,zpar},s];   
 	         plotfunc=Plot[func, {s, mintime, maxtime},PlotRange->All,PlotStyle->{color}];      
	   (*COMBINE*)
	                rangePLOT=GenRangeForPlot[range,format];
	             	plot=Show[plotfunc,PlotRange->rangePLOT, FrameLabel->label,
  	                   FrameTicks->Automatic,Frame -> True, Axes->None,LabelStyle -> Small,AspectRatio->1];
            Return[{zmod,plot}]]




End[] 
EndPackage[]



