(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"                   *)
(*:Title::  core algorithms  *)
(*:Summary::                         *)
(*:References::                       *)
(*Date   2014 Stuart G.Baker *)
(*Input
EstimatedBenefitCore			markerfitbasic.m
GenCutpointsCore				markerfitbasic.m
 ComputeSortedBenefitScore  	markerfitbasic.m
 *)

BeginPackage["markerfitRDtest`","markerfitbasic`"]  
 
 EvaluateTestSampleRD::usage="EvaluateTestSampleRD[dataTEST,parvec,numcut,quantL,quantU,quantUsize,showcut]"

Clear[EvaluateTestSampleRD]

Begin["Private`"]	  

 EvaluateTestSampleRD[dataTEST_,parvec_,numcut_,fracmax_,quantL_,quantU_,quantUsize_,
          showcut_,plottype_]:=
  Module[{dcutvec1,res1,dcutvec2,res2},
          {dcutvec,xvec}=GenCutpointsRD[dataTEST,parvec,numcut,fracmax, 
           quantL,quantU, quantUsize,showcut,plottype];
           res=EstimatedBenefitCutpoint[dataTEST,parvec,dcutvec];
        Return[{res,xvec}]]

GenCutpointsRD[data_,parvec_,numcut_,fracmax_,quantL_,quantU_,quantUsize_,showcut_,plottype_]:=
              Module[{pair0,pair1,range},
             {pair0,pair1}=ComputeSortedBenefitScore[data,parvec];      
            range=GenCutpointsCore[{pair0,pair1},parvec,numcut,fracmax,
                          quantL,quantU,quantUsize,showcut,plottype];
         Return[range]]   

		     
   EstimatedBenefitCutpoint[data_,parvec_,dcutvec_]:=
              Module[{pair0,pair1,res,resx},
                   {pair0,pair1}=ComputeSortedBenefitScore[data,parvec];      
                  res=EstimatedBenefitCore[pair0,pair1,#]& /@ dcutvec;
                  resx=Transpose[res];
              Return[resx]]
         
 
   

    
End[] 
EndPackage[]

