(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"        *)
(*:Title::  TrialFit *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input 
   FitRiskModelPairResp        		   markerfitcadittrain.m
   EvaluateTestSampleResp		   markerfitcadittest.m
   ReportParametersAUC		   markerfitbasic.m
   ReportTestSample			   markerfitbasic.m *)
  
 
BeginPackage["markerfitresp`","markerfitresptrain`", "markerfitresptest`","markerfitbasic`","markerfitlogit`"]  


TrialFitResp::usage="TrialFitResp[datacore,input]"

Clear[TrialFitResp]

Begin["Private`"]	  

 
 
 TrialFitResp[datacore_,{dataset_,maxboot_,showcut_,showfit_,showprog_,showtab_,threshold_,
            numcut_,fracmax_,
               newfitQ_,newbootQ_,split_,numfilter_,maxsteps0_,
               showplot_,quantL_,quantU_,quantUsize_,format_},aucdif_,level_]:=
          Module[{x0,x1,y0,y1,xname, datasetname,res,xvec,parmat,
                         dataTRespIN,dataTEST,nTEST0,nTEST1,aucdifs,plotname,paramatvec,
                        parvecC0,parvecC,parametersC,posC,spec,testresultC,stepp},
               	   PrintMod["Resp",level,showprog,showtab];
               	    If[level=="F",maxsteps=1];
		   If[level=="M",maxsteps=2];
		  If[level=="X",maxsteps=5];
		      If[level=="Z",maxsteps=10];
	       Print["Resp ",level,"  number in model ",maxsteps];
               	   
                   {x0,x1,y0,y1,xname,datasetname}=dataset;  
                   {dataTRespIN,dataTEST,nTEST0,nTEST1}=datacore;
              (*TRAINING SAMPLE*)
                 parvecC=FitRiskModelResp[dataTRespIN,xname,numfilter,maxsteps,
                    showfit,showprog,showtab,aucdif]; 
                 parvecCr=Round[parvecC 10000]/10000//N;
               {parametersCr,posCr,auclistCr} = parvecC;
               parmat=ReportParametersAUC[parametersCr,posCr,auclistCr,xname,"resp",showfit];
        (*TEST SAMPLE*)
          {parametersC,posC,auclistC} = parvecC;
            parvec={parametersC,posC};
            {res,xvec}=EvaluateTestSampleResp[dataTEST,parvec,numcut,fracmax,quantL,
                quantU,quantUsize,showcut,"score"];  
           parmatvec={parmat};
      Return[{res,xvec,parmatvec}]]
   
   
  
     
 ReportParametersResp[parameters_,pos_,auclist_,xname_,groupname_,showfit_]:=
     Module[{xnamevec,mat,rowname,aucvec,parvec,tab},
        parvec=Join[parameters,{" "}];
        xnamevec=Join[{"cons"}, xname[[pos]], {" "}];
        aucvec={" "} ~Join~  auclist;
       mat={parvec,xnamevec,aucvec};
       rowname=StringJoin[groupname, " ",#]& /@ {"coefficient","parameter","auclist"};
       tab=TableForm[mat, TableHeadings->{rowname,None}];
      If[showfit, Print[tab]];
      Return[tab]]

End[] 
EndPackage[]

