(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"        *)
(*:Title::        TrialFit *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*Input*)

BeginPackage["markerfitmodel`",
"markerfitRD`", "markerfitRDtrain`","markerfitRDtest`",
"markerfitCADIT`", "markerfitCADITtrain`","markerfitCADITtest`",
"markerfitresp`", "markerfitresptrain`","markerfitresptest`",
"markerfitbasic`","markerfitsplit`",
"markerfitlogit`", "markerfitplot`","markerfitboot`", "markerfitbootci`"]


TrialFitModel::usage="TrialFit[data,options]"


Clear[TrialFitModel]

Begin["Private`"]	  


 TrialFitModel[datacore_,{name_,level_},parameterset_]:=
    Module[{input,method,tuningparameters,check,numcvsplits,plotformat,
             aucdif1,aucdif2,numchoose1,numchoose2, 
             plotinfo,res},
    (*parameters*)
    {input,method,tuningparameters,check,numcvsplits,plotformat}=parameterset;
   {aucdif1,aucdif2,numchoose1,numchoose2}= tuningparameters;
     
     If[name=="RD"  && level=="F",     plotinfo= TrialFitRiskDifference[datacore,input,aucdif1,"F"]];
     If[name=="RD"  && level=="M",     plotinfo= TrialFitRiskDifference[datacore,input,aucdif2,"M"]];
     If[name=="RD"  && level=="X",     plotinfo= TrialFitRiskDifference[datacore,input,aucdif2,"X"]];
      If[name=="RD"  && level=="Z",     plotinfo= TrialFitRiskDifference[datacore,input,aucdif2,"Z"]];
    
      If[name=="Cadit" && level=="F", plotinfo= TrialFitCadit[datacore,input,aucdif1,"F"]];
      If[name=="Cadit" && level=="M", plotinfo= TrialFitCadit[datacore,input,aucdif2,"M"]];
      If[name=="Cadit" && level=="X", plotinfo= TrialFitCadit[datacore,input,aucdif2,"X"]];
      If[name=="Cadit" && level=="Z", plotinfo= TrialFitCadit[datacore,input,aucdif2,"Z"]];
    
    
     If[name=="Resp"  && level=="F",     plotinfo= TrialFitResp[datacore,input,aucdif1,"F"]];
     If[name=="Resp"  && level=="M",     plotinfo= TrialFitResp[datacore,input,aucdif2,"M"]];
     If[name=="Resp"  && level=="X",     plotinfo= TrialFitResp[datacore,input,aucdif2,"X"]];
    If[name=="Resp"  && level=="Z",     plotinfo= TrialFitResp[datacore,input,aucdif2,"Z"]];
   
   res=Join[{{name,level}},plotinfo];
   Return[res]]


End[] 
EndPackage[]

