(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"                   *)
(*:Title::  core algorithms  *)
(*:Summary::                         *)
(*:References::                       *)
(*Date   2014 Stuart G.Baker *)
(*Input
ComputeSortedBenefitScoreCadit	markerfitbasic.m
EstimatedBenefitCore			markerfitbasic
GenCutpointsCore				markerfitbasic.m *)

BeginPackage["markerfitCADITtest`","markerfitbasic`"]  
 
 EvaluateTestSampleCadit::usage="EvaluateTestSampleCadit[dataTEST,parvec,numcut,quantL,quantU,quantUsize,showcut]"

Clear[EvaluateTestSampleCadit]

Begin["Private`"]	  

 EvaluateTestSampleCadit[dataTEST_,parvec_,numcut_,fracmax_,
           quantL_,quantU_,quantUsize_,showcut_,plottype_]:=
        Module[{dcutvec1,res1,dcutvec2,res2},
           {dcutvec,xvec}=GenCutpointsCadit[dataTEST,parvec,numcut,fracmax, 
                                       quantL,quantU, quantUsize,showcut,plottype];
            res=EstimatedBenefitCutpointCadit[dataTEST,parvec,dcutvec];
     Return[{res,xvec}]]

    GenCutpointsCadit[data_,parvec_,numcut_,fracmax_,quantL_,quantU_,quantUsize_,showcut_,plottype_]:=
              Module[{pair0,pair1,range},
            {pair0,pair1}=ComputeSortedBenefitScoreCadit[data,parvec];      
            range=GenCutpointsCore[{pair0,pair1},parvec,numcut,fracmax,quantL,quantU,quantUsize,showcut,plottype];
         Return[range]]       



EstimatedBenefitCutpointCadit[data_,parvec_,dcutvec_]:=
              Module[{pair0,pair1,res,resx},
                   {pair0,pair1}=ComputeSortedBenefitScoreCadit[data,parvec]; 
                  res=EstimatedBenefitCore[pair0,pair1,#]& /@ dcutvec;
                   resx=Transpose[res];
              Return[resx]]
         
  
 
End[] 
EndPackage[]

