
(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"        *)
(*:Title::        TrialFit *)
(*:References::                  *)
(*Date   2015 Stuart G. Baker *)
(*Input
GenStoredName	markerfitibasic.m
PlotCut			markefitplot.m
PlotInfoModel		markerfitbasic.m
TrialFitModel		markerfitmodel.m
GenDataSplit		markerfitsplit.m
TrialFitParameters	markerfitinputcheck.m*)

(*Package List
   markerfit.m 		   	calls all files and input check
   markerfitinputcheck.m	checks input
    markerfitmodel.m 		evaluate models in test sample
  (*Models*)
   markerfitRD.m		 
       markerfitRDtrain.m	  
       markerfitRDtest.m    		
     markerfitresp.m	  
      markerfitresptrain.m	   	
       markerfitresptest.m    	
   markerfitCADIT.m	     
       markerfitCADITtrain.m	  
       markerfitCADITtest.m   	
   markerfitCADITB.m	 
  (*support*)
   markerfitsplit.m			data splitting
   markerfitbasic.m			key support functions
   markerfitboost.m	 		boosting
   markerfitlogit.m 		   	fit logistic regression 
   markerfitplot.m		   	plotting results
   markerfitboot.m		   	bootstrap test sample       
   markerfitbootci.m	   	simultaneous confidence interval algorithm for boostrap
  (*data*)
  markerfitsim.m		   	generate simulated data
   markerfitdata.m			format data from breast cancer trial (not publicly available) 
   markerfitdatamicro.m		format microarray data
   markerfitrawmicro.m       	raw microarray data
 (*fig*)
    markerfitfig.m 		shows schematic figure*)

 (*Key Function 
 TrialFit[dataset] where
     dataset={x0,x1,y0,y1,xname,datasetname} where
      x0 is g x n matrix of baseline variables for randomization group 0
      x1 is g x n matrix of baseline variables for randomization group 1
      y0 is length n list of binary outcomes (0 or 1) for randomization group 0
      y1 is length n list of binary outcomes (0 or 1) for randomization group 1
      xname= a length g list of names of baseline variables 
      datasetname=name of dataset*)
      
   
 
BeginPackage["markerfit`","markerfitinputcheck`",
"markerfitmodel`",
"markerfitdata`",
"markerfitRD`", "markerfitRDtrain`","markerfitRDtest`",
"markerfitCADIT`", "markerfitCADITtrain`","markerfitCADITtest`",
"markerfitresp`", "markerfitresptrain`","markerfitresptest`",
"markerfitbasic`","markerfitsplit`",
"markerfitlogit`", "markerfitplot`","markerfitboot`", "markerfitbootci`",
"markerfitsim`"]

TrialFit::usage="TrialFit[data,options]"


Clear[TrialFit]

Options[TrialFit]=
 {FractionSplit->.5,
    ModelSet->"Basic",
  NewFitQ->True,
  ShowProgQ->False,
  ShowTabQ->False,
  MinimumSubgroupSize->20,
  NumCut->8,
  PlotFormat->"quantiles",
  NumFilter->20,
  MaxBoot->20}



NewFitQ::usage="true or false for using stored parameter estimates"
FractionSplit::usage="fraction split into test sample (between .2 and .8)"
MinimumSubgroupSize="miniumum sample size for subgroup"
NumCut::usage="number of cutpoints for subgroups in test sample (1 to 10) "
ShowProgQ::usage="show information about progress of fitting"
ShowTabQ::usage="show data and results tables"
NumFilter::usage="number in initial univariate filter"
MaxBoot::usage="number of bootstrap iterations for confidence intervals"
PlotFormat::usage=" quantiles or score for horzontal axis"

Begin["Private`"]	  


 TrialFit[dataset_,options___Rule]:=
    Module[{optionvec,check,parameterset,method,split,datacore,modelsetNAME,modelset,indexm,indexc,plotspec,
      plotinfoset,ymin,ymax},
         optionvec= {FractionSplit,NumCut,NumFilter,NewFitQ,
                             ShowProgQ,ShowTabQ, MaxBoot, 
                              MinimumSubgroupSize,PlotFormat,ModelSet}/. {options}/.Options[TrialFit]; 
      (*MODEL SET*)
         modelsetNAME=optionvec[[-1]];
            If[modelsetNAME==="Basic",
	                  modelset={{"RD","F"},{"RD","M"},{"RD","X"},     
	                                  {"Cadit","F"},{"Cadit","M"},{"Cadit","X"},
                                  {"Resp","F"},{"Resp","M"},{"Resp","X"}}];
          If[modelsetNAME==="Extended",
                    modelset={{"RD","M"},{"RD","X"},{"RD","Z"},     
		    	          {"Cadit","M"},{"Cadit","X"},{"Cadit","Z"},
                              {"Resp","M"},{"Resp","X"},{"Resp","Z"}}];
                    
            If[modelsetNAME==="All",
                    modelset={{"RD","F"},{"RD","M"},{"RD","X"},{"RD","Z"},     
		    	            {"Cadit","F"},{"Cadit","M"},{"Cadit","X"},{"Cadit","Z"},
                                   {"Resp","F"},{"Resp","M"},{"Resp","X"},{"Resp","Z"}}];                        
               
               
          If[modelsetNAME=!="All" && modelsetNAME=!="Basic" && modelsetNAME=!="Extended",
                  modelset=modelsetNAME];      
          
   
             
     Print["MODELSET: ",modelset];
     lenmod=Length[modelset];
     (*check input and create sets of parameters*)
        {check,parameterset,plotspec}=TrialFitParameters[dataset,optionvec];
          split=optionvec[[1]];
         datasetname=dataset[[-1]]; 
      plotmat=Null;  
   (*computation*)  
    If[check,
    seed=19;
           {datacore,datainfo}=GenDataSplit[dataset,split,seed];  
            mca0=False; (*no Bonferonit adjustmetn for multiple models*)
           TrialFitMethod1[dataset,datainfo,datacore,modelset,modelsetNAME,parameterset,datasetname,plotspec,mca0]];
     Return[Null]]
    


(*--------------------------Method 1-----------------------------------------------*)
               
 TrialFitMethod1[dataset_,datainfo_,datacore_,modelset_,modelsetNAME_,parameterset_,datasetname_,plotspec_,mca_]:= 
 Module[{input,method,newfitQ,fracmax,maxboot,tuningparameters,check,numcvsplits,numsplit,plotformat,
             yminvec,ymaxvec,plotvec0,ymin,ymax,plotvec,ncol,mat,
             plotmat,plot,plotvec1},
             {input,method,tuningparameters,check,numcvsplits,plotformat}=parameterset;
           numcut=input[[8]];
           fracmax=input[[9]];
           newfitQ=input[[10]];
          split=input[[12]];
          numsplit=Round[split 100];
          ReportRun[input,tuningparameters,datainfo];
          EvaluateAll[plotspec];
          (*FIT MODELS*)
           lenmod=Length[modelset];
       	
	  storedname=GenStoredNameX[datasetname,1,modelset,numcut,numsplit];
	If[newfitQ==False,
	                          mat=Quiet@Drop[ReadList[storedname],1][[1]];
	                           Print["   importing stored parameter estimates from ",storedname]];
	             If[newfitQ==True,
	                       Print["Fitting benefit functions"];
	                         mat=TrialFitModel[datacore,#,parameterset]& /@ modelset;   
	                        Print["    exporting training sample fits ",storedname];
                     Export[storedname,mat]];  
          If[modelsetNAME=="Basic" || modelsetNAME=="Extended", ncol=3];
          If[modelsetNAME=="All",ncol=4];
          
 PlotFromModelFit[mat,fracmax,plotspec,ncol,plotformat,"all",mca];       

 Return[Null]]  
 

 
PlotFromModelFit[mat_,fracmax_,plotspec_,ncol_,plotformatx_,plotname_,mca_]:=
Module[{resset,xvecset,parset,pair,xvec,tri1,numcomp,plotinfovec,plotx,modvec,typevec,reportlist},
(*input*)
    {modelset,resset,xvecset,parset}=Transpose[mat];
(*print paramters*)
    pair=Transpose[{parset,modelset}];
    Print["PARAMETER ESTIMATES"];
    {modvec,typevec}=Transpose[modelset];
    reportlist=MemberQ[typevec,"Z"];
    lenz=Length[modelset];
    If[reportlist==False,
       matz= ReportParameter[parset,modelset,#]& /@ Range[lenz]; 
       matz1=Partition[Flatten[matz],9];
       colname={"func", "num", "grp", "0", "1","2", "3", "4", "5"};
       rowname=None;
       Print@TableForm[matz1,TableHeadings->{rowname,colname}]];
    If[reportlist==True, 
      PrintParameter[#]& /@pair]; 
   
(*plot set*)
    xvec=xvecset[[1]];
  tri1=Transpose[{resset,modelset}];
numcomp=Length[modelset];
    plotinfovec=PlotInfoModel[#,fracmax,xvec,plotspec,numcomp,mca]& /@ tri1;
     plotx=PlotGrid[plotinfovec,ncol,plotformatx];
     If[plotformatx=="quantiles",add="Q"];
      If[plotformatx=="quantileonly",add="R"];
     If[plotformatx=="score",add="S"];
     namex=StringJoin["TEST",add,plotname];     
    ExportPlot[namex,datasetname,plotx];
Return[mat]]


ReportParameter[parset_,modelset_,j_]:=
Module[{len,mod,var1,num1,mat1,var2,num2,mat2, var,num,mat,i,blank},
   mod=modelset[[j,1]];
   type=modelset[[j,2]];
   If[type=="F", len=1];
   If[type=="M", len=2];
   If[type=="X", len=5];
      If[type=="Z", len=10];
   
 If[mod=="RD",
   var1=parset[[j,1,1,1]];
  num1=parset[[j,1,1,2]];
  mat1=ParCore[var1,num1,"RD",len,1];
  var2=parset[[j, 2,1,1]];
  num2=parset[[j,2,1,2]];
  mat2=ParCore[var2,num2,"RD",len,2];
  mat=Join[mat1,mat2]];
  
  If[mod=="Cadit",
    var=parset[[j,1,1,1]];
    num=parset[[j,1,1,2]];
    mat=ParCore[var,num,"Cadit", len, 1]];

  
  If[mod=="Resp",
    var=parset[[j,1,1,1]];
    num=parset[[j,1,1,2]];
    mat=ParCore[var,num,"Resp",len,0]];

  Return[mat]];
  
  
  
   
   ParCore[var_,num0_,mod_,k_,row_]:=
   Module[{len,var1,num1,blank,i},
   num=PaddedForm[#,3]& /@num0;
    len=Length[var];
       If[len == 6,
     var1=Join[{mod,k,row},var];
     num1=Join[{mod,k,row},num]];
     If[len<6,
      zero=Table[0,{i,1,6-len}];
      blank=Table[" ",{i,1,6-len}];
      num1=Join[{mod,k,row},num,blank];
      var1=Join[{mod,k,row},var,blank]];
   mat={var1,num1};
   Return[mat]]
   


PrintParameter[{tab_,model_}]:=
Module[{len,tab0,tab1},
  Print[model];
  len=Length[tab];
  If[len==1, Print["  ",tab[[1]]]];
  If[len==2, {tab0,tab1}=tab;
  Print["  ",tab0];
  Print["  ",tab1]];
Return[Null]]

 PlotGrid[plotinfovec_,ncol_,plotformatx_]:=
 Module[{yminvec,ymaxvec,i,len,rem,nullvec,plotvecadd,plotvec,plotmat,plot},
    {yminvec,ymaxvec,plotvec0}=Transpose[plotinfovec];
      ymin=Min[yminvec];
     ymax=Max[ymaxvec];
      If[ncol==1,
        plotvec=PlotCut[#,{ymin,ymax},"score",0,ncol]& /@ plotvec0;
       plot=Show[plotvec]];
     If[ncol>1,
        plotvec=PlotCut[#,{ymin,ymax},plotformatx,1,ncol]& /@ plotvec0;
        plot=PlotGridFormat[plotvec,ncol]];
    Return[plot]]
 
 PlotGridFormat[plotvec_,ncol_]:=
 Module[{len,rem,plotvecadd,nullvec,plotmat,plot},
       len=Length[plotvec];
      rem=Mod[len,ncol];
     If[rem==0,
         plotvecadd=plotvec,
         nullvec=Table[Null,{i,1,ncol-rem}];
        plotvecadd=Join[plotvec,nullvec]];
     (*partition*)
     plotmat=Partition[plotvecadd,ncol];
      plot=Show[GraphicsGrid[plotmat],ImageSize->Large];
 Return[plot]]
 

 
 (*-------------------------------------------------Suppport-----------------------------------------------*)
     
  ExportPlot[plotnamecore_,datasetname_,plot_]:=
  Module[{plotname1,plotname2},
        Print[plot];
        plotname1=StringJoin["markerfit",datasetname,"FIG",plotnamecore,".eps"];
        Print["exporting ",plotname1];
  	Export[plotname1,plot];
  	
	plotname2=StringJoin["markerfit",datasetname,"FIG",plotnamecore,".pdf"];
	 Print["exporting ",plotname2];
  	Export[plotname2,plot];
     Return[Null]]; 


ReportRun[input_,tuningparameters_,datainfo_]:=
Module[{fracmax,numfilter,maxboot,numcut,aucdif1,aucdif2,numchoose1,numchoose2,
             datasetname,nvar,nALL0,nALL1,split},
         fracmax=input[[9]];
        numfilter=input[[13]];
         maxboot=input[[2]];
         numcut=input[[8]];
        {aucdif1,aucdif2,numchoose1,numchoose2}= tuningparameters;
        {datasetname,nvar,nALL0,nALL1,split}=datainfo;
	 Print["DATA SET:  ",datasetname," sample  sizes:  ", {nALL0,nALL1}, " split= ",split, 
          " number of variables = ",nvar];
        Print["FITTING INFORMATION:   filter number=",numfilter, "  bootstrap number =",maxboot];
        Print["QUANTILES:  largest = ",fracmax, " number cutpoints= ",numcut];
    Return[Null]]



GenStoredNameX[datasetname_,method_,modelset_,numcut_,numsplit_]:=
Module[{numcuts,lenmods,methods,numsplits,storedname},
      numcuts=ToString[numcut];
      numsplits=ToString[numsplit];
      lenmods=ToString[lenmod];
      lenmods=StringJoin@Flatten[modelset];
      methods=ToString[method];
      storedname=StringJoin["trialSTORE", datasetname,methods,lenmods,numcuts,numsplits,".m"];
    (* Print["STORED NAME ",storedname];*)
 Return[storedname]]  

End[] 
EndPackage[]

