(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"        *)
(*:Title::  TrialFit *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input *)
  
 
BeginPackage["markerfitsplit`"]  


GenDataSplit::usage="GenDataSplit[dataset,split]"
GenDataSplit5::usage="GenDataSplit5[dataset]"

Clear[GenDataSplit,GenDataSplit5]

Begin["Private`"]	  


 
     GenDataSplit[dataset_,split_,seed_:19]:=
       Module[{x0,x1,y0,y1,xname, datainfo,
                  nvar,datasetname,difboot,
                nALL0,nALL1, nTRAIN0,nTRAIN1,nTEST0,nTEST1,
                rangeALL0,rangeALL1,
                xTRAIN0,xTRAIN1,yTRAIN0,yTRAIN1,dataTRAIN,
                  indexTRAIN0,indexTRAIN1,indexTEST0,indexTEST1,
                 xTEST0,xTEST1,yTEST0,yTEST1,dataTEST,res},
              {x0,x1,y0,y1,xname,datasetname}=dataset;
          (*split*)
              nALL0=Length[y0];
              nALL1=Length[y1];
              nTRAIN0=Round[nALL0 (1-split)];
              nTRAIN1=Round[nALL1 (1- split)];
              nTEST0=nALL0-nTRAIN0;
              nTEST1=nALL1-nTRAIN1;
              nALL=nALL0+nALL1;
              SeedRandom[18];
              rangeALL0=RandomSample@Range[nALL0];
              SeedRandom[seed];
              rangeALL1=RandomSample@Range[nALL1];
              indexTRAIN0=Take[rangeALL0,nTRAIN0];
              indexTRAIN1=Take[rangeALL1,nTRAIN1];
              indexTEST0=Drop[rangeALL0,nTRAIN0];
              indexTEST1=Drop[rangeALL1,nTRAIN1]; 
      (*training sample*)         
              xTRAIN0=SelectColumns[x0,indexTRAIN0];
              xTRAIN1=SelectColumns[x1,indexTRAIN1];
              yTRAIN0=y0[[indexTRAIN0]];
              yTRAIN1=y1[[indexTRAIN1]]; 
              dataTRAIN={xTRAIN0,xTRAIN1,yTRAIN0,yTRAIN1};
          (*test sample*)    
               xTEST0= SelectColumns[x0,indexTEST0];
               xTEST1=SelectColumns[x1,indexTEST1];
               yTEST0=y0[[indexTEST0]];
               yTEST1=y1[[indexTEST1]]; 
               dataTEST={xTEST0,xTEST1,yTEST0,yTEST1};
               nvar=Length[x0];
         (*REPORT*)    
          datainfo={datasetname,nvar,nALL0,nALL1,split};
           res={dataTRAIN,dataTEST,nTEST0,nTEST1};
           Return[{res,datainfo}]]
     
     GenDataSplit5[dataTRAIN_,numcvsplits_]:=
            Module[{x0,x1,y0,y1,xname, nALL0,nALL1, rangeALL0,rangeALL1,datacorevec5},
              {x0,x1,y0,y1}=dataTRAIN;
                    nALL0=Length[y0];
                   nALL1=Length[y1];
                   SeedRandom[18];
                   rangeALL0=RandomSample@Range[nALL0];
                   SeedRandom[19];
                   rangeALL1=RandomSample@Range[nALL1];
                   indexset0=GenIndexSet[nALL0,numcvsplits];
                   indexset1=GenIndexSet[nALL1,numcvsplits];
                   datacorevec5=GenDataSplit5Core[dataTRAIN,
                    nALL0,nALL1,indexset0,indexset1,rangeALL0,rangeALL1,#,numcvsplits]& /@ 
                              Range[numcvsplits];
           Return[datacorevec5]]
                
                   
             GenDataSplit5Core[dataTRAINorig_,nALL0_,nALL1_,vecset0_,vecset1_,
             rangeALL0_,rangeALL1_,splitnumber_,numcvsplits_]:=
                  Module[{x0,x1,y0,y1,xname,datasetname, 
	                      remainder,
	                      indexTRAIN0,indexTRAIN1,indexTEST0,indexTEST1,
	                     xTRAIN0,xTRAIN1,yTRAIN0,yTRAIN1,dataTRAIN,
                 xTEST0,xTEST1,yTEST0,yTEST1,dataTEST,res},
                        {x0,x1,y0,y1}=dataTRAINorig;
                  remainder=Complement[Range[numcvsplits],{splitnumber}];
                   indexTRAIN0=Flatten[vecset0[[remainder]]];
                   indexTEST0=vecset0[[splitnumber]];
                   indexTRAIN1=Flatten[vecset1[[remainder]]];
		   indexTEST1=vecset1[[splitnumber]];
            (*training sample*)         
                   xTRAIN0=SelectColumns[x0,indexTRAIN0];
                   xTRAIN1=SelectColumns[x1,indexTRAIN1];
                   yTRAIN0=y0[[indexTRAIN0]];
                   yTRAIN1=y1[[indexTRAIN1]]; 
                   dataTRAIN={xTRAIN0,xTRAIN1,yTRAIN0,yTRAIN1};
                   dimTRAIN=Dimensions[#]& /@ dataTRAIN;
                  (*test sample*)    
                    xTEST0= SelectColumns[x0,indexTEST0];
                    xTEST1=SelectColumns[x1,indexTEST1];
                    yTEST0=y0[[indexTEST0]];
                    yTEST1=y1[[indexTEST1]]; 
                    dataTEST={xTEST0,xTEST1,yTEST0,yTEST1};
                res={dataTRAIN,dataTEST,nTEST0,nTEST1};
                Return[res]]
     
       GenIndexSet[lentot_,numcvsplits_]:=
        Module[{range,len,index1,index2,index3,index4,index5},
              range=Range[lentot];
         If[numcvsplits==3,
           len=Ceiling[lentot/3];
              index1=Range[len];
              index2=len+index1;
              index3=Complement[range, Join[index1,index2]];
            indexset={index1,index2,index3}];
         If[numcvsplits==5,
           len=Ceiling[lentot/5];
              index1=Range[len];
              index2=len+index1;
              index3=2 len+ index1;
              index4=3 len+index1;
              index5=Complement[range, Join[index1,index2,index3,index4]];
            indexset={index1,index2,index3,index4,index5}];
    
    Return[indexset]]  
              
         

End[] 
EndPackage[]

