(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"        *)
(*:Title::  simulation  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)

BeginPackage["markerfitsim`"]  

GenDataSim::usage="GenDataSim"
GenDataSim5::usage="GenDataSim5"

Clear[GenDataSim,GenDataSim5]

Begin["Private`"]	  



GenDataSim[n_,g_,name_,sigma_:20]:=GenDataSimCore[n,g,name,{2,3},{1,2},sigma]

GenDataSim5[n_,g_,name_,sigma_:20]:=GenDataSimCore[n,g,name,{3,3,3,3,3,3,3},{2,2,2,2,2,2,2},sigma]


GenDataSimCore[n_,g_,name_,coef0_,coef1_,sigma_]:=
Module[{m,
   a0, avec0,a1,h0,h1,avec1,len,
   x0,x1,pvec0,pvec1,y0,y1,p0,p1,
   var,se,dif,low,upp,
      range,xname,datasetname,res},
 SeedRandom[100];    
(*report*)   
          x0=RandomVariate[NormalDistribution[0,sigma], {g,n}];
            x1=RandomVariate[NormalDistribution[0,sigma], {g,n}];     
      (*probabilities of outcome*)
             h0=.3;
             a0=Round[Log[h0/(1-h0)] 100]/100//N;
             h1=.2;
             a1=Round[Log[h1/(1-h1)] 100]/100//N;
            len0=Length[coef0];
	    len1=Length[coef1];
            {pvec0,pvec1}=GenProb[{g,x0,x1,a0,coef0,a1,coef1,"first","last"},showplot];
          (*outcome data*)
            y0= Flatten[RandomVariate[BernoulliDistribution[#]]& /@ pvec0];
	   y1= Flatten[RandomVariate[BernoulliDistribution[#]]& /@ pvec1];
        (*combine*)
           len=Length[x0];
           xname=ToString[#]& /@ Range[len];
           datasetname=name;
           res={x0,x1,y0,y1,xname,datasetname}; 
 	  p0=Mean[y0]//N;
 	  p1=Mean[y1]//N;
   var=p0 (1-p0)/n + p1 (1-p1)/n;
 	  se=Sqrt[var];
 	  dif=p1-p0;
 	  low=dif-1.96 se;
 	  upp=dif+1.96 se;
 	  show=False;
 	 
 If[show,
	Print["SIMULATED DATA"];
	Print[" number of genes = ",g];
	Print[" normal with mean 0 and sigma = ",sigma];
	Print[" sample size per arm= ",n];
        Print["PARAMETERS IN RISK PREDICTION MODEL"]
         Print[" parameters group 0 ",Flatten[{a0,coef0}]];
         Print[" variable names in group 0 ", Range[len0]];
         Print[" parameters group 1 ",Flatten[{a1,coef1}]];
        Print[" variable names in group 1 ", Take[Range[g],-len1]];
      	  Print["OVERALL OUTCOME PROBABILITIES"];
	  Print[" overall outcome probablities in arm 0, 1, difference ",{p0,p1}];
        Print[" overall difference in outcome probabilities and 95% CI ",{dif,low,upp}]];
 Return[res]]
  

GenProb[{g_,x0_,x1_,a0_,avec0_,a1_,avec1_,genepos0_,genepos1_},showplot_]:=
 Module[{mrange0,mrange1, m, x0m,x1m, avec02,avec12, w0,p0,w1,p1,p0z,p1z,
     output,res},
     (*position of genes*)
      m=Length[avec0];
   {mrange0,mrange1}=GenePos[g,m,genepos0,genepos1];
        (*pararamters for both*)
         avec02=avec0 ~Join~ avec0;
         avec12=avec1 ~Join~ avec1;      
       (*probabilities in control arm*) 
            x0m=x0[[mrange0]];
            If[genepos0=="both", w0= a0 + avec02 .x0m]; 
             If[genepos0=="first", w0= a0 + avec0 .x0m]; 
             If[genepos0=="last", w0= a0 + avec0 .x0m]; 
             If[genepos0=="next", w0= a0 + avec0 .x0m]; 
            p0= Expit[w0];  
      (*probabilities in experimental arm*)
             x1m=x1[[mrange1]];
             If[genepos1=="both", w1= a1 + avec12 .x1m]; 
            If[genepos1=="first", w1= a1 + avec1 .x1m]; 
            If[genepos1=="last", w1= a1 + avec1 .x1m];  
             If[genepos1=="next", w1= a1 + avec1 .x1m];  
             p1=Expit[w1];
          res={p0,p1};    
        Return[res]]      



Expit[x_]:=Exp[x]/(1+Exp[x])

PositiveSign[x_]:=Sign[Sign[x]-1]+1
NegativeSign[x_]:=1-Sign[Sign[x]+1]
NonNegativeSign[x_]:=Sign[Sign[x]+1]
NonPositiveSign[x_]:=Abs @ Sign[Sign[x]-1]  
ReplaceUpperBound[x_,ub_,new_]:=
   x NegativeSign[x-ub] + NonNegativeSign[x-ub] new
ReplaceLowerBound[x_,ub_,new_]:=
   x PositiveSign[x-ub] + NonPositiveSign[x-ub] new   

GenePos[g_,m_,genepos0_,genepos1_]:=
Module[{mrange0,mrange1},
 (*choice of genes arm 0*)
        If[genepos0=="first",  mrange0=Range[m]];
        If[genepos0=="next",  mrange0=m+Range[m]];
        If[genepos0=="last",  mrange0=g-m + Range[m]];
        If[genepos0=="both",  mrange0=Range[m] ~ Join~ (g-m + Range[m])];   
   (*choices of genes arm 1*)  
      If[genepos1=="first",  mrange1=Range[m]];
        If[genepos1=="next",  mrange1=m+Range[m]];
        If[genepos1=="last",  mrange1=g-m + Range[m]];
       If[genepos1=="both",  mrange1=Range[m] ~ Join~ (g-m + Range[m])];   
Return[{mrange0,mrange1}]]

 
End[] 
EndPackage[]

Print["generating datasim  for manuscript"];
datasim=GenDataSim[600,100,"sim",20];


Print["generating datasim5  for manuscript"];
datasim5=GenDataSim5[600,100,"sim5",20];
