(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"                   *)
(*:Title::  Resp model train  *)
(*:Summary::                         *)
(*:References::                       *)
(*Date   2014 Stuart G. Baker *)
(*Input 
UnivariateFilter		markerfitbasic.m
FitLogitNested			markerfitlogit.m*)

BeginPackage["markerfitresptrain`","markerfitlogit`","markerfitbasic`"]  

FitRiskModelResp::usage=
"FitRiskModelResp[{x0,x1,y0,y1},xname,numfilter,maxsteps,showprog,aucdif]"
  
 
Clear[FitRiskModelResp]
         
Begin["Private`"]	  

FitRiskModelResp[{x0_,x1_,y0_,y1_},xname_,numfilter_,maxsteps_,
     showfit_,showprog_,showtab_,aucdif_]:=
    Module[{n0,n1,i, vec0,vec1, treatmentvec,postop,
             xdata,ydata, yR0,xR0,yR1,xR1, zdata,
             newfitQ,pc, g, xname2,set, pclist,posall,xtop,settop,auclist,parameters,posin,res},
        (*group 0*)
              set0=Transpose[{y0,Transpose[x0]}];
             setR0=Select[set0,(#[[1]]==1)&];
             {yR0,xR0}=Transpose[setR0];
          (*group 1*)
             set1=Transpose[{y1,Transpose[x1]}];
             setR1=Select[set1,(#[[1]]==1)&];
             {yR1,xR1}=Transpose[setR1];
        (*combine*)  
           n0=Length[yR0];
           n1=Length[yR1];
           vec0=Table[0,{i,1,n0}];
           vec1=Table[1,{i,1,n1}];
            zdata=Join[vec0,vec1];
       (*create matrix g by n0+n1*) 
             xdata=Transpose@Join[xR0,xR1];
            res=FitRiskModel[{xdata,zdata},"Resp",xname,numfilter,maxsteps,
            		showfit,showprog,showtab,aucdif];
   Return[res]];
   
  
   FitRiskModel[{xdata_,ydata_},groupname_,xname_,numfilter_,maxsteps_,
         showfit_,showprog_,showtab_,aucdif_]:=
        Module[{t,set,tlist,posall,g,posallx,n,
                    auc,parameters,posin,res,posbest,xtop},
         (*find positions of best variables*)
         {tlist,posall,xtop}=UnivariateFilter[xdata,ydata,xname,numfilter,showprog];   
        (*stepwise*)
              {auclist,parameters,posin}=FitLogitNested[xdata,ydata,posall,showprog,aucdif,maxsteps];
           (*output*)     
           parametersr=Round[parameters 1000]/1000//N;
            res={parametersr,posin,auclist}; 
     Return[res]];
      
    
End[] 
EndPackage[]

