(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"                   *)
(*:Title::  logistic fitting algoritms  *)
(*:Summary::                         *)
(*:References::                       *)
(*Date   2013 Stuart G. Baker *)

BeginPackage["markerfitlogit`"]  



 
 FitLogitNested="FitLogitNested"

Clear[FitLogitNested]
         
Begin["Private`"]	  



  FitLogitNested[xdata_,ydata_,posall0_,showprog_,aucdif_,maxsteps_]:=
                 Module[{auc0,parameters0,posin0,posall,tri0,tri1,trix,trilist,numiter,
                              auclist,paramtersx,posinx,res},
              (*starting value*)  
                       {auc0,parameters0,posin0,posall}=LogitModelStart[xdata,ydata,posall0,showprog];
                       tri0={auc0,parameters0,posin0};
                  If[maxsteps==1, 
                     res={{auc0},parameters0,posin0}];
                  
                If[maxsteps>1,     
                 trilist= FixedPointList[
                       LogitModelStep[xdata,ydata,posall,#,showprog]&,
                       tri0, 
                       maxsteps-1];
                   trix=trilist[[-1]];
                 {aucx,parametersx,posinx}=trix;   
                 {auclist,parlist,poslist}=Transpose[trilist];
                 res={auclist,parametersx,posinx}];
          
           If[showprog && maxsteps==1,Print["      {auc, position list}= ",{auc0,posin0}]];
           If[showprog && maxsteps>1,  Print["      {auc, position list}= ",{aucx,posinx}]];
             Return[res]]
         
    




(*
 FitLogitNested[xdata_,ydata_,posall0_,showprog_,aucdif_,maxsteps_]:=
                Module[{auc0,parameters0,posin0,posall,tri0,tri1,trix,trilist,numiter,
                             auclist,paramtersx,posinx,res},
             (*starting value*)  
                      {auc0,parameters0,posin0,posall}=LogitModelStart[xdata,ydata,posall0,showprog];
                      tri0={auc0,parameters0,posin0};
            (*stepwise as long as difference in AUC < aucdif*)
                 trilist= FixedPointList[
                      LogitModelStep[xdata,ydata,posall,#,showprog]&,
                      tri0, 
                      maxsteps];
              (*Final value is penultimate in list as satisfies criterion*)
                  numiter=Length[trilist];
                  If[numiter >2,
                      trix=trilist[[-2]],
                      trix=trilist[[1]] ];
                  {aucx,parametersx,posinx}=trix;   
                  {auclist,parlist,poslist}=Transpose[trilist];
             (*output*)
             res={auclist,parametersx,posinx};
              If[showprog,Print["      {auc, position list}= ",{aucx,posinx}]];
             Return[res]]
*)         
    



    
   
   LogitModelStart[xdata_,ydata_,posall0_,showprog_]:=
         Module[{len,cons,i,xin,xmat0,modelstart,auc,paramters},
              (*create data matrix with last one is largest*)
                  posin=Take[posall0,-1];
                 len=Length@ydata;
                 cons=Table[1,{i,1,len}];
                 xin=xdata[[posin]];
                 xmat0=Transpose@Join[{cons},xin];
            (*fit inital model*)     
                 modelstart = LogitModelFit[{xmat0,ydata}];
	         auc=CompAUC[modelstart];
                 parameters=modelstart["BestFitParameters"];
                 If[showprog,Print["  START: {auc, position list} = ",{auc,posin}]];
        Return[{auc,parameters,posin,posall0}]]
        
        LogitModelStep[xdata_,ydata_,posall_,{auc0_,parameters0_,posin0_},showprog_:False]:=
              Module[{auc,parametrs,posin,posaddlist,res},
                     posaddlist=Complement[posall,posin0];
                 If[Length[posaddlist]>0 || auc0<=.99,
               {auc,parameters,posin}=LogitModelPick[xdata,ydata,posin0,posaddlist];
                   If[showprog,Print["  STEP: {auc, position list}= ",{auc,posin}]],
            (*stop if reach end*)
               {auc,parameters,posin}={100,parameters0,posin0};
               If[showprog,Print["  MAX #: {auc, position list}= ",{auc,posin}]]];
        Return[{auc,parameters,posin}]]
   
  
  
      LogitModelPick[xdata_,ydata_,posin0_,posaddlist_]:=
      Module[{tri, tris, trimax},
         (*FIT TO EAC POSSIBLE VALUE*)
          tri=LogitModelOne[xdata,ydata,posin0,#]& /@ posaddlist;
         (*PICK RESULT WITH  largest AUC*)
          tris=Sort[tri];
          trimax=tris[[-1]];
        Return[trimax]]   
      
      
       LogitModelOne[xdata_,ydata_,posin0_,posadd_]:=
            Module[{len,cons,i, xin,add,xmat0,modeladd,auc,parameters,posin1},
                (*UPDATE DESIGN MATRIX*)
                    len=Length@ydata;
                    cons=Table[1,{i,1,len}];
                    xin=xdata[[posin0]];
                    xadd=xdata[[{posadd}]];
                     xmat0=Transpose@Join[{cons},xin,xadd];
                (*UPDATE LIST OF VARIABLES IN MODEL*)  
                   posin=Join[posin0,{posadd}];
                (*FIT NEW MODEL*)   
                   model =LogitModelFit[{xmat0,ydata}];
		   parameters=model["BestFitParameters"];
		(*NEW AUC*)   
                   auc=CompAUC[model];
        Return[{auc,parameters,posin}]]
      
      
      

(*----AUC computation*)

CompAUC[model_]:=
Module[{r0,roc,auc},
    r0=Sort@model["PredictedResponse"];
    roc=CompROC[r0];
  auc=CompAUCFromROC[roc];
Return[auc]]


CompROC[r0_]:=
 Module[{r,w,P,p, R,ws,wsr,
     tprnum,tprden,tprx,tprz, 
     fprnum,fprden,fprx,fprz,
     roc},
   (*-BASIC COMPUTATION-----------------*)
   (*sample population  SORTED-------------------------*)
         r=Sort[r0];
   (*TPR --need to revese risk levels -uses r and p*)
   (*---reversal example tpr1 = r3 w3 / p and tpr2=  (r2 w2 + r3 23)/p *) 
         tprnum=Drop[FoldList[Plus,0,Reverse[r]],1];
           tprden=Apply[Plus,r];
       tprx=tprnum/tprden;
    (*FPR*)
      	  fprnum=Drop[FoldList[Plus,0,Reverse[(1-r)]],1];
         fprden=Apply[Plus,(1-r)];
         fprx=fprnum/fprden;
 (*ROC*)
         fprz=Join[{0},fprx];
         tprz=Join[{0},tprx];
        roc=Transpose[{fprz,tprz}];
  Return[roc]] 
        
  
  CompAUCFromROC[roc_]:=
  Module[{fprvec,trpvec,tmvec,auc},
       (*fpr and tpr*)
       {fprvec,tprvec}=Transpose[roc];
      (*sum dif fpr x mean tpr*)
       wvec=difAUC[#]& /@ Partition[fprvec,2,1];
       tmvec=Mean[#]& /@ Partition[tprvec,2,1];
       auc=Apply[Plus, wvec tmvec]; 
   Return[auc]]
  
  
    difAUC[{a_,b_}]:= b-a

  
End[] 
EndPackage[]

