(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"                   *)
(*:Title::  Cadit model train  *)
(*:Summary::                         *)
(*:References::                       *)
(*Date   2014 Stuart G. Baker *)
(*Input 
FitLogitNested			markerfitlogit.m*)

BeginPackage["markerfitCADITtrain`","markerfitlogit`","markerfitbasic`"]  

FitRiskModelCadit::usage=
"FitRiskModelCadit[{x0,x1,y0,y1},xname,numfilter,maxsteps,showprog,aucdif]"
  
 
Clear[FitRiskModelCadit]
         
Begin["Private`"]	  

FitRiskModelCadit[{x0_,x1_,y0_,y1_},xname_,numfilter_,maxsteps_,
     showfit_,showprog_,showtab_,aucdif_]:=
    Module[{n0,n1,i, vec0,vec1, treatmentvec,postop,
           xdata,ydata, cadit, ctab,clen,
           newfitQ,pc, g, xname2,set, pclist,posall,xtop,settop,auclist,parameters,posin,res},
        (*create treatmenticator of randomization group*) 
           n0=Length[y0];
           n1=Length[y1];
           vec0=Table[0,{i,1,n0}];
           vec1=Table[1,{i,1,n1}];
            treatmentvec=Join[vec0,vec1];
       (*create matrix g by n0+n1*) 
             xdata=Transpose@Join[Transpose[x0],Transpose[x1]];
        (*create cadit*)
            ydata=Join[y0,y1]; 
            cadit=GenCadit[treatmentvec,ydata];
       (*find positions of best variables*)
         pc=FitUnivariateCadit[xdata,cadit];
          g=Length[pc];
	  set=Sort@Transpose[{pc,Range[g],xname}];
          {pclist,posall,xtop}=Transpose[Take[set,-numfilter]]; 
  (*report top*)
           settop=Reverse@Transpose[{pclist,posall,xtop}];
            If[showprog,
              clen=Min[Length[settop],5];
              settopx=Take[settop,clen];
              Print["  cadit univariate selection"];
              ctab=TableForm[settopx,TableHeadings->{Automatic,{"prob cadit", "position","variable"}}];
              Print["  ",ctab]];
     (*stepwise*)
            {auclist,parameters,posin}=FitLogitNested[xdata, cadit,posall,showprog,aucdif,maxsteps];
       (*output*)     
            res={parameters,posin,auclist};     
       If[showprog,
       Print["  Cadit:  AUC list  last is excluded: ",auclist]];
   Return[res]];
   
  
      
  GenCadit[treatmentvec_,ydata_]:= gencaditone[#]&  /@ Transpose[{treatmentvec, ydata}]


gencaditone[{treatment_,y_}]:=
Module[{cadit},
(*outcome 1 is favorable and treatment 1 is beneficial*)
If[(y==1 && treatment==1) || (y==0 && treatment==0), cadit=1, cadit=0];
Return[cadit]]
  
 
FitUnivariateCadit[xdata_,cadit_,show_:False]:=
     Module[{g,n,cons,parvec,i},
                 {g,n}=Dimensions[xdata];
                 cons=Table[1,{i,1,n}];
                 parvec=FitUnivariateCaditOne[{cons,cadit},#, show]&  /@ xdata;
       Return[parvec]]
     
     
FitUnivariateCaditOne[{cons_,cadit_},x_,show_]:=
     Module[{m,mod,par,res},
      m=Transpose[{cons,x}];
      mod=LinearModelFit[{m,cadit}];
      par=mod["BestFitParameters"];
    If[show==True, Print[par]];
      res=par[[2]];
    Return[res]];
    
    
End[] 
EndPackage[]

