(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"        *)
(*:Title::  TrialFit *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input 
   FitRiskModelPairCadit        		   markerfitcadittrain.m
   EvaluateTestSampleCadit		   markerfitcadittest.m
   ReportParametersAUC		   markerfitbasic.m
   ReportTestSample			   markerfitbasic.m *)
  
 
BeginPackage["markerfitCADIT`","markerfitCADITtrain`", "markerfitCADITtest`","markerfitbasic`","markerfitlogit`"]  


TrialFitCadit::usage="TrialFitCadit[datacore,input]"

Clear[TrialFitCadit]

Begin["Private`"]	  

 
 
 TrialFitCadit[datacore_,{dataset_,maxboot_,showcut_,showfit_,showprog_,showtab_,threshold_,
            numcut_,fracmax_,
               newfitQ_,newbootQ_,split_,numfilter_,maxsteps0_,
               showplot_,quantL_,quantU_,quantUsize_,format_},aucdif_,level_]:=
          Module[{x0,x1,y0,y1,xname, datasetname,res,xvec,parmat,
                         dataTRAIN,dataTEST,nTEST0,nTEST1,aucdifs,plotname,paramatvec,
                        parvecC0,parvecC,parametersC,posC,spec,testresultC,stepp},
               	  PrintMod["Cadit",level,showprog,showtab];
               	  
               	   If[level=="F",maxsteps=1];
		   If[level=="M",maxsteps=2];
		   If[level=="X",maxsteps=5];
		   If[level=="Z",maxsteps=10];
	           Print["Cadit ",level,"  number in model ",maxsteps];
               	  
                   {x0,x1,y0,y1,xname,datasetname}=dataset;  
                   {dataTRAIN,dataTEST,nTEST0,nTEST1}=datacore;	
              (*TRAINING SAMPLE*)
                 parvecC=FitRiskModelCadit[dataTRAIN,xname,numfilter,maxsteps,
                    showfit,showprog,showtab,aucdif]; 
                 parvecCr=Round[parvecC 10000]/10000//N;
               {parametersCr,posCr,auclistCr} = parvecC;
               parmat=ReportParametersAUC[parametersCr,posCr,auclistCr,xname,"cadit",showfit];
        (*TEST SAMPLE*)
          {parametersC,posC,auclistC} = parvecC;
            parvec={parametersC,posC};
            {res,xvec}=EvaluateTestSampleCadit[dataTEST,parvec,numcut,fracmax,quantL,
                quantU,quantUsize,showcut,"score"];  
           parmatvec={parmat};
      Return[{res,xvec,parmatvec}]]
   
   
    
     
 ReportParametersCadit[parameters_,pos_,auclist_,xname_,groupname_,showfit_]:=
     Module[{xnamevec,mat,rowname,aucvec,parvec,tab},
        parvec=Join[parameters,{" "}];
        xnamevec=Join[{"cons"}, xname[[pos]], {" "}];
        aucvec={" "} ~Join~  auclist;
       mat={parvec,xnamevec,aucvec};
       rowname=StringJoin[groupname, " ",#]& /@ {"coefficient","parameter","auclist"};
       tab=TableForm[mat, TableHeadings->{rowname,None}];
      If[showfit, Print[tab]];
      Return[tab]]

End[] 
EndPackage[]

