(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"        *)
(*:Title::  bootstrap confidenc intervals for sets of points *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2013 Stuart G. Baker *)

BeginPackage["markerfitbootci`"]  

FindCIM::usage="FindCIM"
Coverage::usage="Coverage"
CIMTest::usage="CIMTest"
UppVec::usage="UppVec"
LowVec::usage="LowVec"

Clear[FindCIM,Coverate,CIMTest,LowVec,UppVec]

Begin["Private`"]	  

 (*use .975 for each side*)
 (*
  FindCIM[xmat_,meanvec_,sevec_,alphaSubgroup_,show_]:=
  BinSearch[Coverage[xmat,meanvec,sevec,#]&, 1-alphaSubgroup, {1,2,3}, show]
  (*2.24 corresponds to 97.5% CI result*)
 *)
 
 
   FindCIM[xmat_,meanvec_,sevec_,alphaSubgroup_,show_]:=
   BinSearch[Coverage[xmat,meanvec,sevec,#]&, 1-alphaSubgroup, {1,10,20}, show]
  (*2.24 corresponds to 97.5% CI result*)
 
 (*----------------coverage function-----------*)
 
  Coverage[xmat_,meanvec_,sevec_,k_]:= 
  Module[{indvec,res},
  indvec=VecInd[#,meanvec,sevec,k]&  /@ xmat;
  res=Mean[indvec]//N;
  Return[res]]
    
    VecInd[xvec_,meanvec_,sevec_,k_]:= 
    Module[{lowvec,uppvec,lowvec0,uppvec0,tri,indvec,ind},
      (*bounds based on k*)
        lowvec0= meanvec- k sevec;
        uppvec0=meanvec + k sevec;
        lowvec= LowVec[lowvec0];
        uppvec=UppVec[uppvec0];
        lowvec=lowvec0;
        uppvec=uppvec0;
     (*
     Print[" lowvec0  ",{lowvec0,lowvec}];
       Print["  uppvec0  ",{uppvec0,uppvec}];
     *)
     (*indicator if in bounds*)
       tri={xvec,lowvec,uppvec};
       indvec=XInd[#]& /@ Transpose[tri];
       ind=Apply[Times, indvec];
    Return[ind]]
    
    XInd[{x_,low_,upp_}]:=
      Module[{res},
        If[x >= low && x<=upp, res=1,res=0];
      Return[res]]
   
 UppVec[vec_]:= Min[1,#]&  /@ vec
 LowVec[vec_]:= Max[-1,#]&  /@ vec
 
 
 
  (*binary search  for monotonically increasing function*)

BinSearch[f_,yk_,{a0_,b0_,c0_},show_]:=
 Module[{tri0,topnum,dif},
    tri0={a0,b0,c0}//N;
   (*initial coverage set*) 
    ya=f[a0];
    yb=f[b0];
   yc=f[c0];
  If[show, Print[" start ",{{a0,b0,c0},{ya,yb,yc}}]];
  topnum=20;
  (*difference from target*)
 dif=.001;
   trifin= FixedPoint[
                BinSearchStep[f,yk,#,show]&,
                 tri0, 
                 topnum,
                 SameTest->(( Abs[f[#2[[2]]]-yk]  <dif) &)]; 
  {af,bf,cf}=trifin;
  (*final coverage*)
  ybf=f[bf];
 Return[{bf,ybf}]]
 

BinSearchStep[f_,yk_,{a0_,b0_,c0_},show_]:=
Module[{ya,yb,yc,a1,b1,c1,ya1,yab1,yc1,res,type},
  (*starting coverage*)
   ya=f[a0];
   yb=f[b0];
   yc=f[c0];

   If[yk<ya,                     type="y<a";      a1=a0-(c0-b0); b1= (2 a0 - (c0-b0))/2;  c1=a0];
   If[yk>=ya && yk<=yb , type="a<y<b";      a1=a0;             b1=(a0+b0)/2;              c1=b0];
   If[yk>yb  && yk<=yc,   type="b<y<c";      a1=b0;             b1=(b0+c0)/2;              c1=c0];
   If[yk>yc                    , type="c<y";       a1=c0;            b1=(2 c0 + b0-a0)/2;     c1=c0+ (b0-a0)];
  res={a1,b1,c1}//N;
  ya1=f[a1];
  yb1=f[b1];
  yc1=f[c1];
 If[show,Print["multiplier set=",{a1,b1,c1},"  coverage set= ",{ya1,yb1,yc1}]];
 Return[res]]


   (*starting values for multiplier are {1,2,3}*)
  (*output is zboot=multiplier of se, coverage which should be close to 1-alphaSubgroup*)
   
   (*function for BinSearch*)
   
 
  
   
   NonNegativeSign[x_]:=Sign[Sign[x]+1]
   
 (*-----------------------------------------------------------------------*)  

 CIMTest[]:=
Module[{x0,test},
 x0=RandomVariate[NormalDistribution[0,1], {1000,2}];
(*2.24 corresponds to 97.5% CI result is .95 for joint*)
 test=Coverage[x0,{0,0},{1,1},2.24];
Print["test coverage ",test];
Return[Null]]
 
End[] 
EndPackage[]



