(*Mathematica:: Version 8.0      *)
(*:Context:: "markerfit`"        *)
(*:Title::  TrialFit *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input 
   ComputeBootSet				  markerfitboot.m *)
  
 
BeginPackage["markerfitbasic`", "markerfitplot`","markerfitboot`", "markerfitbootci`"]  

ReportTestSample::usage="ReportTestSample"
ReportParametersAUC::usage="ReportParametersAUC"
ComputeSortedBenefitScore::usage="ComputeSortedBenefitScore[data,parvec]"
ComputeSortedBenefitScoreCadit::usage="ComputeSortedBenefitScoreCadit[data,parvec]"
GenCutpointsCore::usage="GenCutpointsCore"
EstimatedBenefitCore::usage=" EstimatedBenefitCore[pair0,pair1,d]"
UnivariateFilter::usage="UnivariateFilter"
PlotInfoModel::usage="PlotInfoModel"
EvaluateAll::usage="EvaluateAll"
GenColor::usage="GenColor"
PrintMod::usage="PrintMod"

Clear[ReportTestSample,ComputeSortedBenefitScore,EvaluateAll,GenColor,
GenCutpointsCore,EstimatedBenefitCore,UnivariateFilter,PlotInfoModel,
PrintMod]

Begin["Private`"]	  

 PlotInfoModel[{resvec_,model_},fracmax_,xvec_,plotspec_,numcomp0_,mca_]:=   
        Module[{a,b,plotname,out,color},
          {a,b}=model;
         If[numcomp0==1,    color=Black,      color=GenColor[model]];
         plotname=Style[StringJoin[a,":",b],color];
         plotname=StringJoin[a,":",b];
         If[mca==False, numcomp=1, numcomp=numcomp0];
      out= ReportTestSample[resvec,plotspec,{fracmax,xvec,plotname,color,numcomp}];
        Return[out]] 
         
  ReportTestSample[{dvec_,difvec_,sevec_,m0_,m1_,n0_,n1_},
        {numcut_,showcut_,showfit_,showprog_,showtab_,datasetname_,aucdif_,maxboot_,y0_,y1_},
        {fracmax_,xvec_,plotname_,color_,numcomp_}]:=
      Module[{frac,inputvec,inputvecQ,storedname,ymin,ymax,qvec,
                 alpha,zorig,rownames,colnames, vecALL,dif0,low0,upp0,plotcut},
       (*m0=  number of events among participants with benefit scores >= cutpoint in group 0*)
       (*m1= number of events among participants with benefit scores >= cutpoint  in group 1*)
       (*n0 = number of participants with benefit scores >= cutpoint in group 0*)
       (*n1 = number of participants with benefit scores >= cutpoint in group 1*)
       (*frac =fraction of unique scores greater than or equal to cutpoint*)
        mat={difvec,xvec};
        (*TABLE OF CUTPOINTS*)
    If[showcut,
      matr=Round[mat 1000]/1000//N;
      tab=TableForm[matr,TableHeadings->{{"difference", "benefitscore"},Automatic}];
     Print["     ",tab]];   
  (*FRACTION IN SCORES*)
         frac=(n0+n1)/(n0[[1]]+n1[[1]])//N;
       inputvec={dvec,frac,difvec,sevec,m0,m1,n0,n1};
   (*TABLE OF COUNTS*)
   If[showtab,
       Print["  test sample counts:   number greater than each score"];  
       mat={m0,n0-m0,n0,m1, n1-m1, n1};
       rowname={"arm 0 events","arm 0 non-events","arm 0 total","arm 1 events", "arm 1 non-events","arm 1 total"};
       Print["   ",TableForm[mat,TableHeadings->{rowname,Automatic}]]];
 (*BOOTSTRAP*)
      difboot=ComputeBootSet[inputvec,maxboot,numcut,showtab,"random"];      
   (*CONFIDENCE INTERVAL*)
          alphaS=.01/numcomp;
          alphaS=.05;
          (*
          Print["alpha for bootstrap CI int test sample ",alphaS];
          *)
          showbinsearch=False;
	 {zboot,coverage}=FindCIM[difboot,difvec,sevec,alphaS,showbinsearch];
      (*OVERALL Z-STAT*)
          alphaORIG=.05;
          zorig=InvCDF[1-alphaORIG/2];
     (*EVALUATE ALL*)    
        {vecALL,{dif0,low0,upp0}}=EvaluateALLY[y0,y1,zorig,False];   
   (*CUTPOINT TABLE*)
      If[showtab,	
        Print[" "];
        Print["CUTPOINT CONFIDENCE INTERVAL CALCULATIONS"];
         zbon=InvCDF[1-alphaS/(2 numcut)];
         zunadj=InvCDF[1-alphaS/2];
         headx={"alpha", "z-unadjusted", "z-Bonferoni", "z-bootstrap", "coverage of z-boot"};
         vecx=Round[1000 {alphaS,zunadj,zbon,zboot,coverage}]/1000//N;
        Print["  ",TableForm[{vecx},TableHeadings->{None,headx}]]]; 
   (*RESULTS TABLE*) 
     If[showtab,
        matTEST=GenTable[inputvec,zboot];
         mat=Join[{vecALL},matTEST];  
         rownames=Range[numcut+2]-2;
        colnames={"benefit\nscore","quantile","events\ngroup\n0","events\ngroup\n1",
                       "total\ngroup\n0","total\ngroup\n1","dif","se","low","upp"};
        Print[" "];
        Print["SUMMARY OF RESULTS"];
        Print["  ",TableForm[mat,TableHeadings->{rownames, colnames}]]]; 
(*SUBPOPULATION TREATMENT EFFECT PATTERN PLOT  in test sample*) 
       rangefrac={0} ~Join~ (Range[numcut])/numcut;	
        qvec=Round[rangefrac fracmax 100]/100//N;
          ymin=Min[difvec-zboot sevec];
        ymax=Max[difvec+zboot sevec];
        plotcore={inputvec,dif0,low0,upp0,dif0,zboot,plotname,qvec,color};
 Return[{ymin,ymax,plotcore}]]

EvaluateAll[plotspec_]:=
Module[{y0,y1,zorig,vecALL,res0,dif0,low0,upp0,alphaORIG},
    y0=plotspec[[-2]];
       y1=plotspec[[-1]];
       alphaORIG=0.05;
        zorig=InvCDF[1-alphaORIG/2];
        {vecALL,res0}=EvaluateALLY[y0,y1,zorig,True];   
        {dif0,low0,upp0}=Round[res0 1000]/1000//N;
       Print["OVERALL ESTIMATE:  ",dif0, " with 95% CI ",{low0,upp0}];
Return[Null]]



 ReportParametersAUC[parvec_,pos_,auclist_,xname_,groupname_,showfit_]:=
    Module[{xnamevec,mat,rowname,aucvec,tab},
        aucvec=Round[auclist 1000]/1000//N;
        xnamevec= Join[{"cons"},xname[[pos]]];
       mat={xnamevec,parvec};
      rowname=StringJoin[groupname, " ",#]& /@ {"variable","coefficient"};
       tab=TableForm[mat, TableHeadings->{rowname,None}];
      If[showfit,Print[aucvec]; Print[tab]];
      Return[tab]]



  (*---------------------Evaluate All------------------------*)
 
  EvaluateALLY[y0_,y1_,z_,show_:False]:=
 Module[{frac,xname,name, m0,m1,alpha,p0,p1,dif,var,se,low,upp,n0,n1,vec,vecr,head},
    (*intial evaluation*)
               p0=Mean[y0]//N;
             p1=Mean[y1]//N;
             m0=Apply[Plus, y0];
             m1=Apply[Plus,y1];
             n0=Length[y0];
             n1=Length[y1];
              dif=p1-p0;
             var=p1(1-p1)/n1+ p0 (1-p0)/n0;
             se=Sqrt[var];
              low=dif-z se;
              upp=dif+z se;
              If[show,
              Print["EVALUATE ALL  p1 p0 ",{p1,p0}," dif low upp ",{dif,low,upp}]];
              frac=1;
            res={"overall",frac,m0,m1,n0,n1} ~Join~ round[{dif,se,low,upp}];
   Return[{res,{dif,low,upp}}]]

 
 
  (*---------------------Benefit Score------------------------*)
 
  
  ComputeSortedBenefitScore[{x0_,x1_,y0_,y1_},parvec_]:=
             Module[{parameters0,posvec0,n0,parameters1,posvec1,n1,
             parcons0,parcons1,par0,par1,
                      xvec00,xvec01, s00,s01,r00,r01,d0,
                      xvec10,xvec11, s10,s11,r10,r11,d1,         
                     pair0,pair1,len2, 
                     partop0,pairtop1,
                     rtop0,rtop1,
                     ytop0,ytop1,ym0,ym1,dif,var0,var1,var},
            (*parameters*) 
                 {parameters0,posvec0,parameters1,posvec1}=parvec;      
                 parcons0=parameters0[[1]];
                 parcons1=parameters1[[1]];       
                 par0=Drop[parameters0,1];
                 par1=Drop[parameters1,1];  
           (*difference in risk in control group*)  
                 xvec00=x0[[posvec0]];
                 xvec01=x0[[posvec1]];
                 s00= parcons0 + par0 .xvec00;
                 s01= parcons1 + par1 .xvec01;
                 r00=Exp[s00]/(1+Exp[s00]);
                 r01=Exp[s01]/(1+Exp[s01]);
                 d0=r01-r00;
            (*difference in risk in experimental group*)  
                  xvec10=x1[[posvec0]];
                  xvec11=x1[[posvec1]];
                  s10= parcons0 + par0 .xvec10;
                  s11= parcons1 + par1 .xvec11;
                  r10=Exp[s10]/(1+Exp[s10]);
                  r11=Exp[s11]/(1+Exp[s11]);
                  d1=r11-r10;
               (*pairs*)
                  pair0=Sort@Transpose[{d0,y0}];
                   pair1=Sort@Transpose[{d1,y1}];
               Return[{pair0,pair1}]]
              
  
    
    ComputeSortedBenefitScoreCadit[{x0_,x1_,y0_,y1_},parvec_]:=
            Module[{parameters0,posvec0,n0,parameters1,posvec1,n1,
            parconsC,parC,
                     xvec0, s0,r0,d0,
                     xvec1, s1,r1,d1,         
                    pair0,pair1,len2, 
                    partop0,pairtop1,
                    rtop0,rtop1,
                    ytop0,ytop1,ym0,ym1,dif,var0,var1,var},
           (*parameters for Cadit*) 
                {parametersC,posvecC}=parvec;      
                parconsC=parametersC[[1]];
                parC=Drop[parametersC,1];
          (*compute probability cadit = 1 in group 0*)  
                xvec0=x0[[posvecC]];
                s0= parconsC + parC .xvec0;
                r0=Exp[s0]/(1+Exp[s0]);
               d0= 2 r0-1;
             (*compute probability cadit = 1 in group 1*)  
                xvec1=x1[[posvecC]];
                s1= parconsC + parC .xvec1;
                r1=Exp[s1]/(1+Exp[s1]);      
                d1=2 r1-1;
             (*pairs*)
                 pair0=Sort@Transpose[{d0,y0}];
                  pair1=Sort@Transpose[{d1,y1}];
              Return[{pair0,pair1}]]
                   


  GenCutpointsCore[{pair0_,pair1_},parvec_,numcut_,fracmax_,quantL_,quantU_,quantUsize_,
      showcut_,plottype_:"score"]:=
              Module[{dvec0,yvec0,dvec1,yvec1,
                       dvecUnion0,dvecUnion1,dvecUnion,
                        len,index, num,inc,i,lentot,range,matr,tab,mat,ranger,dcutvecr,
                        set,setcut,dcutvec},
                        {dvec0,yvec0} =Transpose[pair0];
                        {dvec1,yvec1} =Transpose[pair1];
                        dvecUnion0=Union[dvec0];
		        dvecUnion1=Union[dvec1];
		        dvecUnion=Sort@Union[Join[dvec0,dvec1]];
		  (*MAXIMUM CUTPOINT*)      
		      If[quantU==Automatic,
		             dsort0=Sort[dvec0];
		             dsort1=Sort[dvec1];
		             dmax0=dsort0[[-quantUsize]];
		             dmax1=dsort1[[-quantUsize]];
		             dmax=Min[dmax0,dmax1]];
		     If[quantU=!=Automatic,
		          dmax=Quantile[dvecUnion,quantU]];
		   (*MINUMUM CUTPOInT*)
		            dmin=Quantile[dvecUnion,quantL];
		   (*CUTPOINT VECTOR =range*)
		        dvecQ=Sort@Select[dvecUnion, (#<=dmax)&];
		         len=Length[dvecQ];
		         quant= Round[ 100 len/Length[dvecUnion]]//N;
                          index=Range@len;
		          rangefrac={0} ~Join~ (Range[numcut])/numcut;		      
	         If[plottype=="score",
	               (*equally spaced cutpoints up to dmax*)
        	        dcutvec= dmin+ (dmax-dmin) rangefrac;
		        xvec=dcutvec];
        	 If[plottype=="quant",
        	       (*equally spaced quantiles up to fracmax*)
        	        dvec=Join[dvec0,dvec1];
        	         xvec=Round[rangefrac fracmax 100]/100//N;
        	        dcutvec=Quantile[dvec,#]& /@ xvec];
        	  (*report table*)	
        	  showcutx=False;
        	  If[showcutx,	
        		rowname={"cutpoints", "x-axis"};
        		cmat={dcutvec,xvec};
        		cmatr=Round[cmat 1000]/1000//N;
        		Print["    cutpoints"];
        		Print["  ",TableForm[cmatr,TableHeadings->{rowname,Automatic}]]];
           	 If[showcutx,
	                  lentot=Length@Join[dvec0,dvec1];
	                  Print["Test sample:   total number of benefit scores ",lentot, " number unique= ",len]];
	     Return[{dcutvec,xvec}]]
	     
		 
		  

  ReportCutpoint[dvec_,cutvec_,name_]:=
   Module[{list,mat,rowname},
   Print["cutpoints tail counts ",name];
   list=ReportCutpointOne[dvec,#]& /@ cutvec;
   mat=Transpose[list];
   rowname={"    cutpoint","tail counts"};
   Print["     ",TableForm[mat,TableHeadings->{rowname,Automatic}]];
   Return[list]]
  
   ReportCutpointOne[dvec_,cut_]:=
   Module[{dvecx,len,cutx},
               dvecx=Select[dvec, (#>=cut)&];
               len=Length[dvecx];
               cutx=Round[cut 1000]/1000//N;
               Return[{cutx,len}]]
  
 
      EstimatedBenefitCore[pair0_,pair1_,d_]:=
                       Module[{m0,n0,p0,var0,m1,n1,p1,var1,dif,var,se,res},
                            {m0,n0,p0,var0}=ComputeForGroup[pair0,d];
                            {m1,n1,p1,var1}=ComputeForGroup[pair1,d];
                              dif=(p1-p0);
                              var=var0+var1;
                              se=Sqrt[var];
                              res={d,dif,se,m0,m1,n0,n1};
                      Return[res]]
    
    ComputeForGroup[pair_,d_]:=
    Module[{pairtop,dtop,ytop,m,p,n,var},
                 (*select greater than or equal to cutpoint*)
                 pairtop=Select[pair,(#[[1]] >= d)&];
    	          {dtop,ytop}=Transpose@pairtop;
                      m=Apply[Plus,ytop];
                       p=Mean[ytop]//N;
                      n=Length[ytop];
                      var=p (1-p)/n;
               Return[{m,n,p,var}]]
   
 
(*----------------support functions-----------------------*)

SelectColumns[x_,indexvec_]:=
Module[{x1,x2,x3},
x1=Transpose[x];
x2=x1[[indexvec]];
x3=Transpose[x2];
Return[x3]]
  
TakeColumns[x_,len_]:= Transpose@Take[Transpose[x],len];
 
 GenTable[{d_,frac_,dif_,se_,m0_,m1_,n0_,n1_},z_]:=
 Module[{low,upp,difr,lowr,uppr,dr,fracr,matr,hear},
          low=dif-z se;
          upp=dif+z se;
          difr=round@dif;
          ser=round@se;
          lowr=round@low;
          uppr=round@upp;
          fracr=Round[frac 1000]/1000//N;
          dr=round@d;
         matr=Transpose[{dr,fracr,m0,m1,n0,n1,difr,ser,lowr,uppr}];
 Return[matr]]
 
 
round[x_]:=Round[x 1000]/1000//N;	
InvCDF[alpha_]:= InverseNormal[0,1,alpha]
InverseNormal[mu_, sigma_, z_]:= mu + Sqrt[2] sigma InverseErf[2 z - 1]
 

   UnivariateFilter[xdata_,ydata_,xname_,numfilter_,showprog_:False]:=
    Module[{t,g,set,tlist,posall,xnametop}, 
           t=Abs@TStat[{xdata,ydata}];
        (*take largest ordered smallest to largest*) 
 	    g=Length[t];
 	    set=Sort@Transpose[{t,Range[g],xname}];
             {tlist,posall,xnametop}=Transpose[Take[set,-numfilter]]; 
           If[showprog,
	               tr=Round[t 100]/100//N;
	               setr=Sort@Transpose[{tr,Range[g],xname}];
	               settop=Reverse@Take[setr,-5];
	               Print["    ",TableForm[settop,TableHeadings->{Automatic,{"t-statistic", "position","variable"}}]]];
  Return[{tlist,posall,xnametop}]]




TStat[{xdata_,ydata_}]:=
      Module[{g,n,posvec0,posvec1, x0,x1, m0,v0,m1,v1, set,g0,n0,g1,n1},
              (*position of outcome y=0*)    
               posvec0=Flatten@Position[ydata,0];
          (*position of outcome y=1*)
              {g,n}=Dimensions[xdata];
               posvec1=Complement[Range[n],posvec0];
         (*gene by person matrix for y=0*);
                x0= Transpose@(Transpose[xdata])[[posvec0]];
          (*gene by person matrix for y=1*);
                x1= Transpose@(Transpose[xdata])[[posvec1]];
          (*mean and variance*)
                m0=Mean[#]& /@ x0;
                v0=Variance[#]& /@  x0;
                m1=Mean[#]& /@ x1;
                v1=Variance[#]& /@ x1;
           (*ASOLUTE VALUE t-stat of difference in control group*)
                 {g0,n0}=Dimensions[x0];
	        {g1,n1}=Dimensions[x1];
	        t=Abs@(m1-m0)/Sqrt[v0/n0+v1/n1]//N;
            Return[t]]
 


GenColor[model_]:=
Module[{name,tune,color},
{name,tune}=model;
If[name=="RD",color=Red];
If[name=="RDB",color=Orange];
If[name=="RDC",color=Brown];
If[name=="Cadit",color=Blue];
If[name=="CaditB",color=Purple];
If[name=="Vote",color=Green];
If[name=="Max",color=Gray];
If[name=="Resp",color=Magenta];
Return[color]]



PrintMod[name_,level_,showprog_,showtemp_]:=
Module[{temp},
    temp=PrintTemporary["    fitting model ",name," ",level];      
     Pause[2];
    NotebookDelete[temp];
    If[showprog==True || showtab==True, Print[" "]; Print[name," ",level]];
Return[Null]]


End[] 
EndPackage[]

