/*****************************************************************************/
/*****************************************************************************/
/* The following files are required to run this example:                     */
/*   diethealthout0-diethealthout200 (parameter estimates from the logistic  */
/*     regression model fit for the original data and for each of the        */
/*     replicates)                                                           */
/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
/* This example analysis uses regression calibration and fits a logistic     */
/* regression model to assess the relationships between seven dietary        */
/* components and a health outcome.  For this analysis, the example data     */
/* were simulated to include data from 100,000 participants, and the 24-hour */
/* dietary recall is the main dietary instrument.  This analysis allows for  */
/* participants that never consume alcohol.  The dietary components are      */
/* alcohol, red meat, whole grains, sodium, potassium, protein, and energy,  */
/* and the health outcome is a binary event variable.  The simulated data    */
/* include repeated intake measurements from 24-hour dietary recalls.        */
/*                                                                           */
/* This analysis uses bootstrap variance estimation, so the multivariate     */
/* measurement error model and logistic model are fit using the original     */
/* data set and 200 replicate data sets.  This step of the example uses      */
/* parameter estimates calculated from the previous step and performs        */
/* bootstrap variance estimation of the standard errors.                     */
/*****************************************************************************/




title1 "Fit Multivariate Measurement Error Model Using MCMC with 24-Hour Recall as Main Instrument, Allowing for Never Consumers";
title2 "Predict Intake and Perform Regression Calibration";
title3 "Assess Relationships between Seven Dietary Components and a Health Outcome";



***********************************************************************;
*** The path must be modified in the following lines to specify the ***;
*** location of the SAS macros, the SAS data files, and the SAS     ***;
*** library that will be used for output                            ***;
***********************************************************************;

%let home = /prj/dcp/statprog/meas.err/develop.public.resources.stat.meth;

*** Output data library ***;
libname outlib "&home/multivar_epidemiology_example5_mcmc_nc_main24hr/outlib";



**************************************************************************;
*** Import the data sets of parameter estimates from the 200 replicate ***;
*** analyses performed for bootstrap variance estimation               ***;
**************************************************************************;

data diethealthout_1to200;
  set outlib.diethealthout1 - outlib.diethealthout40;
run;



************************************************************************************************;
*** Calculate the standard deviations of the parameter estimates from the replicate analyses ***;
************************************************************************************************;

proc means data=diethealthout_1to200 noprint;
  var intercept rc_or_alcohol_unit_iqr rc_or_redmeat_unit_iqr rc_or_whlgrain_unit_iqr rc_or_sodium_unit_iqr
      rc_or_potassium_unit_iqr rc_or_protein_unit_iqr rc_or_energy_unit_iqr rc_or_std_entry_age_unit_iqr
      rc_or_std_log_bmi_unit_iqr;
  output out=bootstrap_data_std std=intercept rc_or_alcohol_unit_iqr rc_or_redmeat_unit_iqr rc_or_whlgrain_unit_iqr
                                    rc_or_sodium_unit_iqr rc_or_potassium_unit_iqr rc_or_protein_unit_iqr rc_or_energy_unit_iqr
                                    rc_or_std_entry_age_unit_iqr rc_or_std_log_bmi_unit_iqr;
run;



**************************************************************************************;
*** Create a data set with parameter estimates from the original data and standard ***;
*** deviations of the parameter estimates from the replicate analyses              ***;
**************************************************************************************;

data diethealthout_0to200(keep = intercept rc_or_alcohol_unit_iqr rc_or_redmeat_unit_iqr rc_or_whlgrain_unit_iqr
                                 rc_or_sodium_unit_iqr rc_or_potassium_unit_iqr rc_or_protein_unit_iqr rc_or_energy_unit_iqr
                                 rc_or_std_entry_age_unit_iqr rc_or_std_log_bmi_unit_iqr);
  set outlib.diethealthout1 bootstrap_data_std;
run;

proc transpose data=diethealthout_0to200 out=diethealthout_transpose(rename = (col1=estimate col2=boot_se));
run;



***********************************************************************************************;
*** Print the summarized results of the health outcome model adjusted for measurement error ***;
***********************************************************************************************;

proc print data=diethealthout_transpose(drop = _label_) noobs;
  title4 "Summary of Parameter Estimates and Bootstrap Variance Estimation of Standard Errors";
  format estimate boot_se 8.3;
run;
