(*Mathematica:: Version 8.0      *)
(*:Context:: "mfit`"                     *)
(*:Title::  MFit            		*)
(*:Summary::   mfitplot            	*)
(*:References::                         *)
(*Date  2013 Stuart G. Baker   *)

(*Input
PosGoodPair				mfitsupport.m
PlotPairOverlayVec		mfitplotoverlay.m 
PlotPairSideVec			mfitplotside.m  *)


BeginPackage["mfitplot`","mfitplotoverlay`", "mfitplotside`","mfitcore`","mfitform`","mfitsupport`"]  


PlotTargetGene::usage="PlotTargetGene[zvec,dataset,par,splitQ]"
PlotShapePairs::usage="PlotShapePairs[modelset,input,modpairvec,format]"


Clear[PlotTargetGene,PlotShapePairs]

Begin["Private`"]	  


   (*-------------------------PLOT SHAPE PAIRS----*)
   
   PlotShapePairs[modelset_,input_,modpairvec_,format_]:=
    Module[{ },
         Print["MODEL PAIR PLOTS"];
         PlotShapePairsOne[modelset,input,#,format]& /@ modpairvec;
      Return[Null]]
   
   
   PlotShapePairsOne[modelset_,{zbestmat1_,zbestmat2_,dataset1_,dataset2_,
        par_,splitQ_,exportplotQ_,kform_}, modpair_,format_]:=
   Module[{len,lenx,range,posvec,posvecFIT,posvecFITx,mod1,mod2},
         len=Length@zbestmat1;
         range=Range[len];
       (*select pairs that fit the model*)
         posvec=PosGoodPair[modelset,#,zbestmat1,zbestmat2,modpair]& /@ range;
        posvecFIT=Select[posvec,(#>0)&];
         lenx=Length[posvecFIT];
     If[lenx==0, Print[" MODEL PAIR ",modpair, " none"]];
     If[lenx>0,
     Print["MODEL PAIR: ", modpair,  " number of occurrences = ",lenx];
      Print[" "];
    PlotPairCombined[posvecFIT,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,
       exportplotQ,kform,format];
    Print["  "]];
   Return[Null]]
   

(*------------------------PlotTarget- Gene----------------------------------------------*)


PlotTargetGene[pos_,zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,exportplotQ_,
   kform_,format_]:=
Module[{plotmat},
 plotmat=PlotPairCombinedVec[pos,zbestmat1,zbestmat2,dataset1,dataset2,
              par,splitQ,kform,format];
  Return[plotmat]]



(*----------------------------------PlotPairCombined--------(side by side and overlay------------------------------------*)

PlotPairCombined[posvec_,zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,exportplotQ_,
   kform_,format_]:=
Module[{plotmat,zmod1,zmod2,name,
            plotname,dataname,data,geneid,genename,times,geneid0,genename0},
  (*PLOT*)
   plotmat=PlotPairCombinedVec[#,zbestmat1,zbestmat2,dataset1,dataset2,par,
                 splitQ,kform,format]& /@ posvec;
  (*FOR LABELING PLOT*)
   (*take any positition to get name*)
      pos0=posvec[[1]];
      zmod1=zbestmat1[[pos0,2]];
      zmod2=zbestmat2[[pos0,2]];
     {data,geneid,genename,times,xname,yname,plotname,dataname}=dataset1;   
     geneid0=geneid[[posvec]];    
      genename0=genename[[posvec]];
      plotmatx=Partition[Flatten[plotmat],3];
       Print[Show[GraphicsRow[#],ImageSize->Large]]& /@ plotmatx;
 Return[Null]]



PlotPairCombinedVec[pos_,zbestmat1_,zbestmat2_,dataset1_,dataset2_,par_,splitQ_,kform_,format_]:=
Module[{color1,color2,plot,plot1,plot2},
  color1=Blue;
 color2=Darker[Green];
 plot0=PlotPairOverlayVec[pos,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,kform,color1,color2,format];
 {plot1,plot2}=PlotPairSideVec[pos,zbestmat1,zbestmat2,dataset1,dataset2,par,splitQ,color1,color2,format];
Return[{plot0,plot1,plot2}]]






End[] 
EndPackage[]



